/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.spilling;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.modifiers.spilling.ISpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluid;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluidManager;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;

public class UpdateSpillingFluidsPacket
implements ISimplePacket {
    private final List<SpillingFluid> fluids;

    public UpdateSpillingFluidsPacket(class_2540 buf) {
        int size = buf.method_10816();
        ImmutableList.Builder fluids = ImmutableList.builder();
        List<ISpillingEffect> effects = Collections.singletonList(NoEffect.INSTANCE);
        for (int i = 0; i < size; ++i) {
            fluids.add((Object)new SpillingFluid(FluidIngredient.read((class_2540)buf), effects));
        }
        this.fluids = fluids.build();
    }

    public void encode(class_2540 buf) {
        buf.method_10804(this.fluids.size());
        for (SpillingFluid fluid : this.fluids) {
            fluid.ingredient().write(buf);
        }
    }

    public void handle(Supplier<ISimplePacket.Context> context) {
        SpillingFluidManager.INSTANCE.updateFromServer(this.fluids);
    }

    public UpdateSpillingFluidsPacket(List<SpillingFluid> fluids) {
        this.fluids = fluids;
    }

    private static class NoEffect
    implements ISpillingEffect {
        private static final ISpillingEffect INSTANCE = new NoEffect();

        private NoEffect() {
        }

        @Override
        public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        }

        public JsonObject serialize(JsonSerializationContext context) {
            throw new UnsupportedOperationException("Cannot serialize spilling fluids on the client");
        }
    }
}

