/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.spilling.effects;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.spilling.ISpillingEffect;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.utils.JsonUtils;

public record DamageSpillingEffect(DamageType type, float damage) implements ISpillingEffect
{
    public static final class_2960 ID = TConstruct.getResource("damage");
    public static JsonDeserializer<DamageSpillingEffect> LOADER = (element, classType, context) -> {
        JsonObject json = element.getAsJsonObject();
        String typeName = class_3518.method_15265((JsonObject)json, (String)"damage_type");
        DamageType type = DamageType.byName(typeName);
        if (type == null) {
            throw new JsonSyntaxException("Unknown damage type '" + typeName + "'");
        }
        float damage = class_3518.method_15259((JsonObject)json, (String)"damage_amount");
        return new DamageSpillingEffect(type, damage);
    };

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        class_1657 player = context.getPlayerAttacker();
        class_1282 source = player != null ? class_1282.method_5532((class_1657)player) : class_1282.method_5511((class_1309)context.getAttacker());
        this.type.apply(source);
        ToolAttackUtil.attackEntitySecondary(source, this.damage * scale, context.getTarget(), context.getLivingTarget(), true);
    }

    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = JsonUtils.withType(ID);
        json.addProperty("damage_type", this.type.getName());
        json.addProperty("damage_amount", (Number)Float.valueOf(this.damage));
        return json;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DamageType {
        NORMAL{

            @Override
            public void apply(class_1282 source) {
            }
        }
        ,
        FIRE{

            @Override
            public void apply(class_1282 source) {
                source.port_lib$setFireDamage();
            }
        }
        ,
        MAGIC{

            @Override
            public void apply(class_1282 source) {
                source.method_5515();
            }
        }
        ,
        EXPLOSION{

            @Override
            public void apply(class_1282 source) {
                source.method_5518();
            }
        }
        ,
        PIERCING{

            @Override
            public void apply(class_1282 source) {
                source.method_5508();
            }
        };

        private final String name = this.name().toLowerCase(Locale.US);

        public abstract void apply(class_1282 var1);

        @Nullable
        public static DamageType byName(String name) {
            for (DamageType type : DamageType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }
}

