/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.AbstractCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public abstract class ItemCastingRecipe
extends AbstractCastingRecipe
implements IDisplayableCastingRecipe {
    protected final FluidIngredient fluid;
    protected final ItemOutput result;
    protected final int coolingTime;

    public ItemCastingRecipe(class_3956<?> type, class_2960 id, String group, class_1856 cast, FluidIngredient fluid, ItemOutput result, int coolingTime, boolean consumed, boolean switchSlots) {
        super(type, id, group, cast, consumed, switchSlots);
        this.fluid = fluid;
        this.result = result;
        this.coolingTime = coolingTime;
    }

    @Override
    public long getFluidAmount(ICastingContainer inv) {
        return this.fluid.getAmount(inv.getFluid());
    }

    public boolean matches(ICastingContainer inv, class_1937 worldIn) {
        return this.getCast().method_8093(inv.getStack()) && this.fluid.test(inv.getFluid());
    }

    @Override
    public class_1799 method_8110() {
        return this.result.get();
    }

    @Override
    public int getCoolingTime(ICastingContainer inv) {
        return this.coolingTime;
    }

    @Override
    public boolean hasCast() {
        return this.cast != class_1856.field_9017;
    }

    @Override
    public List<class_1799> getCastItems() {
        return Arrays.asList(this.cast.method_8105());
    }

    @Override
    public class_1799 getOutput() {
        return this.result.get();
    }

    @Override
    public List<FluidStack> getFluids() {
        return this.fluid.getFluids();
    }

    public FluidIngredient getFluid() {
        return this.fluid;
    }

    @Override
    public int getCoolingTime() {
        return this.coolingTime;
    }

    public static interface IFactory<T extends AbstractCastingRecipe> {
        public T create(class_2960 var1, String var2, @Nullable class_1856 var3, FluidIngredient var4, ItemOutput var5, int var6, boolean var7, boolean var8);
    }

    public static class Serializer<T extends ItemCastingRecipe>
    extends AbstractCastingRecipe.Serializer<T> {
        private final IFactory<T> factory;

        @Override
        protected T create(class_2960 idIn, String groupIn, @Nullable class_1856 cast, boolean consumed, boolean switchSlots, JsonObject json) {
            FluidIngredient fluid = FluidIngredient.deserialize((JsonObject)json, (String)"fluid");
            ItemOutput output = ItemOutput.fromJson((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"result"));
            int coolingTime = class_3518.method_15260((JsonObject)json, (String)"cooling_time");
            return (T)((ItemCastingRecipe)this.factory.create(idIn, groupIn, cast, fluid, output, coolingTime, consumed, switchSlots));
        }

        @Override
        protected T create(class_2960 idIn, String groupIn, @Nullable class_1856 cast, boolean consumed, boolean switchSlots, class_2540 buffer) {
            FluidIngredient fluid = FluidIngredient.read((class_2540)buffer);
            ItemOutput result = ItemOutput.read((class_2540)buffer);
            int coolingTime = buffer.readInt();
            return (T)((ItemCastingRecipe)this.factory.create(idIn, groupIn, cast, fluid, result, coolingTime, consumed, switchSlots));
        }

        @Override
        public void writeExtra(class_2540 buffer, T recipe) {
            ((ItemCastingRecipe)recipe).fluid.write(buffer);
            ((ItemCastingRecipe)recipe).result.write(buffer);
            buffer.writeInt(((ItemCastingRecipe)recipe).coolingTime);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    public static class Table
    extends ItemCastingRecipe {
        public Table(class_2960 id, String group, class_1856 cast, FluidIngredient fluid, ItemOutput result, int coolingTime, boolean consumed, boolean switchSlots) {
            super((class_3956)TinkerRecipeTypes.CASTING_TABLE.get(), id, group, cast, fluid, result, coolingTime, consumed, switchSlots);
        }

        public class_1865<?> method_8119() {
            return (class_1865)TinkerSmeltery.tableRecipeSerializer.get();
        }
    }

    public static class Basin
    extends ItemCastingRecipe {
        public Basin(class_2960 id, String group, class_1856 cast, FluidIngredient fluid, ItemOutput result, int coolingTime, boolean consumed, boolean switchSlots) {
            super((class_3956)TinkerRecipeTypes.CASTING_BASIN.get(), id, group, cast, fluid, result, coolingTime, consumed, switchSlots);
        }

        public class_1865<?> method_8119() {
            return (class_1865)TinkerSmeltery.basinRecipeSerializer.get();
        }
    }
}

