/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.entitymelting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.LazySpawnEggItem;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.container.IEmptyContainer;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class EntityMeltingRecipe
implements ICustomOutputRecipe<IEmptyContainer> {
    private final class_2960 id;
    private final EntityIngredient ingredient;
    private final FluidStack output;
    private final int damage;
    private List<class_1299> entityInputs;
    private List<class_1799> itemInputs;

    public boolean matches(class_1299<?> type) {
        return this.ingredient.test(type);
    }

    public FluidStack getOutput(class_1309 entity) {
        return this.output.copy();
    }

    public List<class_1299> getEntityInputs() {
        if (this.entityInputs == null) {
            this.entityInputs = ImmutableList.copyOf((Collection)this.ingredient.getTypes());
        }
        return this.entityInputs;
    }

    public List<class_1799> getItemInputs() {
        if (this.itemInputs == null) {
            this.itemInputs = this.getEntityInputs().stream().map(LazySpawnEggItem::fromEntityType).filter(Objects::nonNull).map(class_1799::new).toList();
        }
        return this.itemInputs;
    }

    public Collection<class_1299<?>> getInputs() {
        return this.ingredient.getTypes();
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerSmeltery.entityMeltingSerializer.get();
    }

    public class_3956<?> method_17716() {
        return (class_3956)TinkerRecipeTypes.ENTITY_MELTING.get();
    }

    @Deprecated
    public boolean matches(IEmptyContainer inv, class_1937 worldIn) {
        return false;
    }

    public EntityMeltingRecipe(class_2960 id, EntityIngredient ingredient, FluidStack output, int damage) {
        this.id = id;
        this.ingredient = ingredient;
        this.output = output;
        this.damage = damage;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public int getDamage() {
        return this.damage;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<EntityMeltingRecipe> {
        public EntityMeltingRecipe fromJson(class_2960 id, JsonObject json) {
            EntityIngredient ingredient = EntityIngredient.deserialize((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"entity"));
            FluidStack output = RecipeHelper.deserializeFluidStack((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            int damage = class_3518.method_15282((JsonObject)json, (String)"damage", (int)2);
            return new EntityMeltingRecipe(id, ingredient, output, damage);
        }

        @Nullable
        protected EntityMeltingRecipe fromNetworkSafe(class_2960 id, class_2540 buffer) {
            EntityIngredient ingredient = EntityIngredient.read((class_2540)buffer);
            FluidStack output = FluidStack.fromBuffer((class_2540)buffer);
            int damage = buffer.method_10816();
            return new EntityMeltingRecipe(id, ingredient, output, damage);
        }

        protected void toNetworkSafe(class_2540 buffer, EntityMeltingRecipe recipe) {
            recipe.ingredient.write(buffer);
            recipe.output.toBuffer(buffer);
            buffer.method_10804(recipe.damage);
        }
    }
}

