/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.tables.TinkerTables;

public class MaterialRecipeBuilder
extends AbstractRecipeBuilder<MaterialRecipeBuilder> {
    private final MaterialVariantId material;
    private class_1856 ingredient = class_1856.field_9017;
    private int value = 1;
    private int needed = 1;
    private ItemOutput leftover = null;

    public MaterialRecipeBuilder setIngredient(class_6862<class_1792> tag) {
        return this.setIngredient(class_1856.method_8106(tag));
    }

    public MaterialRecipeBuilder setIngredient(class_1935 item) {
        return this.setIngredient(class_1856.method_8091((class_1935[])new class_1935[]{item}));
    }

    public MaterialRecipeBuilder setIngredient(class_1856 ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public void save(Consumer<class_2444> consumerIn) {
        this.save(consumerIn, this.material.getId());
    }

    public void save(Consumer<class_2444> consumerIn, class_2960 id) {
        if (this.material == null) {
            throw new IllegalStateException("recipe " + id + " has no material associated with it");
        }
        if (this.ingredient == class_1856.field_9017) {
            throw new IllegalStateException("recipe " + id + " must have ingredient set");
        }
        if (this.value <= 0) {
            throw new IllegalStateException("recipe " + id + " has no value associated with it");
        }
        if (this.needed <= 0) {
            throw new IllegalStateException("recipe " + id + " has no needed associated with it");
        }
        class_2960 advancementId = this.buildOptionalAdvancement(id, "materials");
        consumerIn.accept((class_2444)new Result(id, advancementId));
    }

    private MaterialRecipeBuilder(MaterialVariantId material) {
        this.material = material;
    }

    public static MaterialRecipeBuilder materialRecipe(MaterialVariantId material) {
        return new MaterialRecipeBuilder(material);
    }

    public MaterialRecipeBuilder setValue(int value) {
        this.value = value;
        return this;
    }

    public MaterialRecipeBuilder setNeeded(int needed) {
        this.needed = needed;
        return this;
    }

    public MaterialRecipeBuilder setLeftover(ItemOutput leftover) {
        this.leftover = leftover;
        return this;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable class_2960 ID, class_2960 advancementID) {
            super((AbstractRecipeBuilder)MaterialRecipeBuilder.this, ID, advancementID);
        }

        public void method_10416(JsonObject json) {
            if (!MaterialRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", MaterialRecipeBuilder.this.group);
            }
            json.add("ingredient", MaterialRecipeBuilder.this.ingredient.method_8089());
            json.addProperty("value", (Number)MaterialRecipeBuilder.this.value);
            json.addProperty("needed", (Number)MaterialRecipeBuilder.this.needed);
            json.addProperty("material", MaterialRecipeBuilder.this.material.toString());
            if (MaterialRecipeBuilder.this.value > 1 && MaterialRecipeBuilder.this.leftover != null) {
                json.add("leftover", MaterialRecipeBuilder.this.leftover.serialize());
            }
        }

        public class_1865<?> method_17800() {
            return (class_1865)TinkerTables.materialRecipeSerializer.get();
        }
    }
}

