/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.mantle.transfer.fluid.IFluidHandler;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class DamageableMeltingRecipe
extends MeltingRecipe {
    private static final int[] EMPTY_SIZE = new int[0];
    private final int unitSize;
    private final int[] byproductSizes;

    public DamageableMeltingRecipe(class_2960 id, String group, class_1856 input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, int unitSize, int ... byproductSizes) {
        super(id, group, input, output, temperature, time, byproducts);
        this.unitSize = unitSize;
        this.byproductSizes = byproductSizes;
    }

    private static FluidStack scaleOutput(FluidStack fluid, int damage, int maxDamage, int unitSize) {
        long remainder;
        long amount = fluid.getAmount() * (long)(maxDamage - damage) / (long)maxDamage;
        if (amount <= (long)unitSize) {
            amount = Math.max(unitSize, 1);
        } else if (unitSize > 1 && (remainder = amount % (long)unitSize) > 0L) {
            amount -= remainder;
        }
        return new FluidStack(fluid, amount);
    }

    @Override
    public FluidStack getOutput(IMeltingContainer inv) {
        FluidStack output = this.getOutput();
        class_1799 input = inv.getStack();
        int maxDamage = input.method_7936();
        if (maxDamage <= 0) {
            return output.copy();
        }
        return DamageableMeltingRecipe.scaleOutput(output, input.method_7919(), maxDamage, this.unitSize);
    }

    @Override
    public void handleByproducts(IMeltingContainer inv, IFluidHandler handler) {
        class_1799 input = inv.getStack();
        int maxDamage = input.method_7936();
        if (maxDamage <= 0) {
            super.handleByproducts(inv, handler);
        } else {
            int itemDamage = input.method_7919();
            for (int i = 0; i < this.byproducts.size(); ++i) {
                FluidStack fluidStack = (FluidStack)this.byproducts.get(i);
                handler.fill(DamageableMeltingRecipe.scaleOutput(fluidStack, itemDamage, maxDamage, i < this.byproductSizes.length ? this.byproductSizes[i] : this.unitSize), false);
            }
        }
    }

    @Override
    public class_1865<?> method_8119() {
        return (class_1865)TinkerSmeltery.damagableMeltingSerializer.get();
    }

    public static class Serializer
    extends MeltingRecipe.AbstractSerializer<DamageableMeltingRecipe> {
        @Override
        protected DamageableMeltingRecipe createFromJson(class_2960 id, String group, class_1856 input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, JsonObject json) {
            int unitSize = class_3518.method_15282((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"), (String)"unit_size", (int)1);
            int[] byproductSizes = EMPTY_SIZE;
            if (json.has("byproducts")) {
                byproductSizes = StreamSupport.stream(class_3518.method_15261((JsonObject)json, (String)"byproducts").spliterator(), false).mapToInt(element -> class_3518.method_15282((JsonObject)element.getAsJsonObject(), (String)"unit_size", (int)1)).toArray();
            }
            return new DamageableMeltingRecipe(id, group, input, output, temperature, time, byproducts, unitSize, byproductSizes);
        }

        @Override
        protected DamageableMeltingRecipe createFromNetwork(class_2960 id, String group, class_1856 input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, class_2540 buffer) {
            int unitSize = buffer.method_10816();
            int[] byproductSizes = buffer.method_10787();
            return new DamageableMeltingRecipe(id, group, input, output, temperature, time, byproducts, unitSize, byproductSizes);
        }

        @Override
        protected void toNetworkSafe(class_2540 buffer, DamageableMeltingRecipe recipe) {
            super.toNetworkSafe(buffer, recipe);
            buffer.method_10804(recipe.unitSize);
            buffer.method_10806(recipe.byproductSizes);
        }
    }
}

