/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialIngredient;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialMeltingRecipe
implements IMeltingRecipe,
IMultiRecipe<MeltingRecipe> {
    private final class_2960 id;
    private final MaterialVariant input;
    private final int temperature;
    private final FluidStack result;
    private List<MeltingRecipe> multiRecipes = null;

    public MaterialMeltingRecipe(class_2960 id, MaterialVariantId input, int temperature, FluidStack result) {
        this.id = id;
        this.input = MaterialVariant.of(input);
        this.temperature = temperature;
        this.result = result;
    }

    public boolean matches(IMeltingContainer inv, class_1937 worldIn) {
        if (this.input.isUnknown()) {
            return false;
        }
        class_1799 stack = inv.getStack();
        if (stack.method_7960() || MaterialCastingLookup.getItemCost(stack.method_7909()) == 0) {
            return false;
        }
        return this.input.matchesVariant(stack);
    }

    @Override
    public int getTemperature(IMeltingContainer inv) {
        return this.temperature;
    }

    @Override
    public int getTime(IMeltingContainer inv) {
        int cost = MaterialCastingLookup.getItemCost(inv.getStack().method_7909());
        return IMeltingRecipe.calcTimeForAmount(this.temperature, this.result.getAmount() * (long)cost);
    }

    @Override
    public FluidStack getOutput(IMeltingContainer inv) {
        int cost = MaterialCastingLookup.getItemCost(inv.getStack().method_7909());
        return new FluidStack(this.result, this.result.getAmount() * (long)cost);
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerSmeltery.materialMeltingSerializer.get();
    }

    public List<MeltingRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            if (this.input.get().isHidden()) {
                this.multiRecipes = Collections.emptyList();
            } else {
                MaterialId inputId = this.input.getId();
                this.multiRecipes = MaterialCastingLookup.getAllItemCosts().stream().filter(entry -> ((IMaterialItem)entry.getKey()).canUseMaterial(inputId)).map(entry -> {
                    FluidStack output = this.result;
                    if (entry.getIntValue() != 1) {
                        output = new FluidStack(output, output.getAmount() * (long)entry.getIntValue());
                    }
                    return new MeltingRecipe(this.id, "", MaterialIngredient.fromItem((IMaterialItem)entry.getKey(), inputId), output, this.temperature, IMeltingRecipe.calcTimeForAmount(this.temperature, output.getAmount()), Collections.emptyList());
                }).collect(Collectors.toList());
            }
        }
        return this.multiRecipes;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<MaterialMeltingRecipe> {
        public MaterialMeltingRecipe fromJson(class_2960 id, JsonObject json) {
            MaterialVariantId inputId = MaterialVariantId.fromJson(json, "input");
            int temperature = class_3518.method_15260((JsonObject)json, (String)"temperature");
            FluidStack output = RecipeHelper.deserializeFluidStack((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            return new MaterialMeltingRecipe(id, inputId, temperature, output);
        }

        @Nullable
        protected MaterialMeltingRecipe fromNetworkSafe(class_2960 id, class_2540 buffer) {
            MaterialVariantId inputId = MaterialVariantId.parse(buffer.method_10800(Short.MAX_VALUE));
            int temperature = buffer.readInt();
            FluidStack output = FluidStack.fromBuffer((class_2540)buffer);
            return new MaterialMeltingRecipe(id, inputId, temperature, output);
        }

        protected void toNetworkSafe(class_2540 buffer, MaterialMeltingRecipe recipe) {
            buffer.method_10814(recipe.input.getVariant().toString());
            buffer.writeInt(recipe.temperature);
            recipe.result.toBuffer(buffer);
        }
    }
}

