/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1865;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialMeltingRecipeBuilder
extends AbstractRecipeBuilder<MaterialMeltingRecipeBuilder> {
    private final MaterialVariantId inputId;
    private final int temperature;
    private final FluidStack result;

    public static MaterialMeltingRecipeBuilder material(MaterialVariantId materialId, int temperature, FluidStack result) {
        if (temperature < 0) {
            throw new IllegalArgumentException("Invalid temperature " + temperature + ", must be 0 or greater");
        }
        return new MaterialMeltingRecipeBuilder(materialId, temperature, result);
    }

    public static MaterialMeltingRecipeBuilder material(MaterialVariantId materialId, FluidStack result) {
        return MaterialMeltingRecipeBuilder.material(materialId, result.getFluid().getAttributes().getTemperature(result) - 300, result);
    }

    public static MaterialMeltingRecipeBuilder material(MaterialId materialId, class_3611 result, int amount) {
        return MaterialMeltingRecipeBuilder.material(materialId, new FluidStack(result, (long)amount));
    }

    public void save(Consumer<class_2444> consumer) {
        this.save(consumer, this.inputId.getId());
    }

    public void save(Consumer<class_2444> consumer, class_2960 id) {
        class_2960 advancementID = this.buildOptionalAdvancement(id, "melting");
        consumer.accept((class_2444)new Result(id, advancementID));
    }

    private MaterialMeltingRecipeBuilder(MaterialVariantId inputId, int temperature, FluidStack result) {
        this.inputId = inputId;
        this.temperature = temperature;
        this.result = result;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable class_2960 ID, class_2960 advancementID) {
            super((AbstractRecipeBuilder)MaterialMeltingRecipeBuilder.this, ID, advancementID);
        }

        public void method_10416(JsonObject json) {
            json.addProperty("input", MaterialMeltingRecipeBuilder.this.inputId.toString());
            json.addProperty("temperature", (Number)MaterialMeltingRecipeBuilder.this.temperature);
            json.add("result", (JsonElement)RecipeHelper.serializeFluidStack((FluidStack)MaterialMeltingRecipeBuilder.this.result));
        }

        public class_1865<?> method_17800() {
            return (class_1865)TinkerSmeltery.materialMeltingSerializer.get();
        }
    }
}

