/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRequirements;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierSalvage;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ModifierRecipeLookup {
    public static final String DEFAULT_ERROR_KEY = TConstruct.makeTranslationKey("recipe", "modifier.requirements_error");
    public static final ValidatedResult DEFAULT_ERROR = ValidatedResult.failure(DEFAULT_ERROR_KEY, new Object[0]);
    private static final Multimap<ModifierId, ModifierRequirements> REQUIREMENTS = HashMultimap.create();
    private static final Object2IntMap<ModifierId> INCREMENTAL_PER_LEVEL = new Object2IntOpenHashMap();
    private static final Multimap<ModifierId, ModifierSalvage> SALVAGE = HashMultimap.create();
    private static final RecipeCacheInvalidator.DuelSidedListener LISTENER = RecipeCacheInvalidator.addDuelSidedListener(() -> {
        REQUIREMENTS.clear();
        INCREMENTAL_PER_LEVEL.clear();
        SALVAGE.clear();
    });

    public static void addRequirements(ModifierRequirements requirements) {
        LISTENER.checkClear();
        REQUIREMENTS.put((Object)requirements.getModifier(), (Object)requirements);
    }

    public static void addRequirements(class_1856 ingredient, ModifierEntry entry, ModifierMatch requirements, String errorMessage) {
        if (requirements != ModifierMatch.ALWAYS) {
            ValidatedResult error = errorMessage.isEmpty() ? DEFAULT_ERROR : ValidatedResult.failure(errorMessage, new Object[0]);
            ModifierId modifier = entry.getId();
            ModifierRecipeLookup.addRequirements(new ModifierRequirements(ingredient, modifier, requirements.getMinLevel(modifier) + entry.getLevel(), requirements, error));
        }
    }

    public static Collection<ModifierRequirements> getRequirements(ModifierId modifier) {
        return REQUIREMENTS.get((Object)modifier);
    }

    public static ValidatedResult checkRequirements(class_1799 stack, IToolStackView tool) {
        List<ModifierEntry> modifiers = tool.getModifierList();
        for (ModifierEntry entry : tool.getUpgrades().getModifiers()) {
            for (ModifierRequirements requirements : ModifierRecipeLookup.getRequirements(entry.getId())) {
                ValidatedResult result = requirements.check(stack, entry.getLevel(), modifiers);
                if (!result.hasError()) continue;
                return result;
            }
        }
        return ValidatedResult.PASS;
    }

    public static void setNeededPerLevel(ModifierId modifier, int neededPerLevel) {
        if (INCREMENTAL_PER_LEVEL.containsKey((Object)modifier)) {
            int original = INCREMENTAL_PER_LEVEL.getInt((Object)modifier);
            if (original != neededPerLevel) {
                TConstruct.LOG.warn("Inconsistent amount needed per level for {}, originally {}, newest {}, keeping largest", (Object)modifier, (Object)original, (Object)neededPerLevel);
            }
            if (neededPerLevel > original) {
                INCREMENTAL_PER_LEVEL.put((Object)modifier, neededPerLevel);
            }
        } else {
            INCREMENTAL_PER_LEVEL.put((Object)modifier, neededPerLevel);
        }
    }

    public static int getNeededPerLevel(ModifierId modifier) {
        return INCREMENTAL_PER_LEVEL.getOrDefault((Object)modifier, 0);
    }

    public static void addSalvage(ModifierSalvage salvage) {
        LISTENER.checkClear();
        SALVAGE.put((Object)salvage.getModifier(), (Object)salvage);
    }

    @Nullable
    public static ModifierSalvage getSalvage(class_1799 stack, IToolStackView tool, ModifierId modifier, int modifierLevel) {
        for (ModifierSalvage salvage : SALVAGE.get((Object)modifier)) {
            if (!salvage.matches(stack, tool, modifierLevel)) continue;
            return salvage;
        }
        return null;
    }
}

