/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.util.Lazy;
import io.github.tropheusj.serialization_hooks.ingredient.CombinedIngredient;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.tools.TinkerModifiers;

public abstract class AbstractModifierRecipeBuilder<T extends AbstractModifierRecipeBuilder<T>>
extends AbstractRecipeBuilder<T> {
    protected static final Lazy<class_1856> DEFAULT_TOOL = Lazy.of(() -> class_1856.method_8106(TinkerTags.Items.MODIFIABLE));
    protected static final Lazy<ModifierMatch> UNARMED_MODIFIER = Lazy.of(() -> ModifierMatch.entry(TinkerModifiers.unarmed));
    protected static final String UNARMED_ERROR = TConstruct.makeTranslationKey("recipe", "modifier.unarmed");
    protected final ModifierEntry result;
    protected class_1856 tools = class_1856.field_9017;
    protected int maxToolSize = 16;
    protected SlotType slotType;
    protected int slots;
    protected int maxLevel = 0;
    protected ModifierMatch requirements = ModifierMatch.ALWAYS;
    protected String requirementsError = null;
    protected int salvageMinLevel = 1;
    protected int salvageMaxLevel = 0;
    protected boolean includeUnarmed = false;

    public T includeUnarmed() {
        this.includeUnarmed = true;
        return (T)((Object)this);
    }

    public T setTools(class_1856 tools) {
        return this.setTools(tools, 16);
    }

    public T setTools(class_1856 tools, int maxSize) {
        this.tools = tools;
        this.maxToolSize = maxSize;
        return (T)((Object)this);
    }

    public T setTools(class_6862<class_1792> tag) {
        return this.setTools(class_1856.method_8106(tag));
    }

    public T setRequirements(ModifierMatch requirements) {
        this.requirements = requirements;
        return (T)((Object)this);
    }

    public T setRequirementsError(String requirementsError) {
        this.requirementsError = requirementsError;
        return (T)((Object)this);
    }

    public T setMinSalvageLevel(int level) {
        if (level < 1) {
            throw new IllegalArgumentException("Min level must be greater than 0");
        }
        this.salvageMinLevel = level;
        return (T)((Object)this);
    }

    public T setSalvageLevelRange(int minLevel, int maxLevel) {
        this.setMinSalvageLevel(minLevel);
        if (maxLevel < minLevel) {
            throw new IllegalArgumentException("Max level must be grater than or equal to min level");
        }
        this.salvageMaxLevel = maxLevel;
        return (T)((Object)this);
    }

    public T setMaxLevel(int level) {
        if (level < 1) {
            throw new IllegalArgumentException("Max level must be greater than 0");
        }
        this.maxLevel = level;
        return (T)((Object)this);
    }

    public T setSlots(SlotType slotType, int slots) {
        if (slots < 0) {
            throw new IllegalArgumentException("Slots must be positive");
        }
        this.slotType = slotType;
        this.slots = slots;
        return (T)((Object)this);
    }

    public void save(Consumer<class_2444> consumer) {
        this.save(consumer, this.result.getId());
    }

    public abstract T saveSalvage(Consumer<class_2444> var1, class_2960 var2);

    private void writeCommon(JsonObject json, @Nullable Boolean unarmed) {
        class_1856 ingredient = this.tools;
        if (this.tools == class_1856.field_9017) {
            ingredient = (class_1856)DEFAULT_TOOL.get();
        }
        if (unarmed == Boolean.TRUE) {
            ingredient = class_1856.method_8106(TinkerTags.Items.UNARMED);
        } else if (unarmed == null) {
            ingredient = new CombinedIngredient(new class_1856[]{ingredient, class_1856.method_8106(TinkerTags.Items.UNARMED)});
        }
        json.add("tools", ingredient.method_8089());
        if (this.maxToolSize != 16) {
            json.addProperty("max_tool_size", (Number)this.maxToolSize);
        }
        if (this.slotType != null && this.slots > 0) {
            JsonObject slotJson = new JsonObject();
            slotJson.addProperty(this.slotType.getName(), (Number)this.slots);
            json.add("slots", (JsonElement)slotJson);
        }
    }

    protected AbstractModifierRecipeBuilder(ModifierEntry result) {
        this.result = result;
    }

    protected class SalvageFinishedRecipe
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public SalvageFinishedRecipe(@Nullable class_2960 ID, class_2960 advancementID) {
            super((AbstractRecipeBuilder)AbstractModifierRecipeBuilder.this, ID, advancementID);
        }

        public void method_10416(JsonObject json) {
            AbstractModifierRecipeBuilder.this.writeCommon(json, AbstractModifierRecipeBuilder.this.includeUnarmed ? null : Boolean.valueOf(false));
            json.addProperty("modifier", AbstractModifierRecipeBuilder.this.result.getId().toString());
            json.addProperty("min_level", (Number)AbstractModifierRecipeBuilder.this.salvageMinLevel);
            if (AbstractModifierRecipeBuilder.this.salvageMaxLevel != 0) {
                json.addProperty("max_level", (Number)AbstractModifierRecipeBuilder.this.salvageMaxLevel);
            }
        }

        public class_1865<?> method_17800() {
            return (class_1865)TinkerModifiers.modifierSalvageSerializer.get();
        }
    }

    protected abstract class ModifierFinishedRecipe
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        private final boolean withUnarmed;

        public ModifierFinishedRecipe(@Nullable class_2960 ID, class_2960 advancementID, boolean withUnarmed) {
            super((AbstractRecipeBuilder)AbstractModifierRecipeBuilder.this, ID, advancementID);
            this.withUnarmed = withUnarmed;
        }

        public ModifierFinishedRecipe(@Nullable class_2960 ID, class_2960 advancementID) {
            this(ID, advancementID, false);
        }

        public void method_10416(JsonObject json) {
            AbstractModifierRecipeBuilder.this.writeCommon(json, this.withUnarmed);
            if (this.withUnarmed) {
                JsonObject reqJson = ((ModifierMatch)UNARMED_MODIFIER.get()).serialize();
                reqJson.addProperty("error", UNARMED_ERROR);
                json.add("requirements", (JsonElement)reqJson);
            } else if (AbstractModifierRecipeBuilder.this.requirements != ModifierMatch.ALWAYS) {
                JsonObject reqJson = AbstractModifierRecipeBuilder.this.requirements.serialize();
                reqJson.addProperty("error", AbstractModifierRecipeBuilder.this.requirementsError);
                json.add("requirements", (JsonElement)reqJson);
            }
            json.add("result", (JsonElement)AbstractModifierRecipeBuilder.this.result.toJson());
            if (AbstractModifierRecipeBuilder.this.maxLevel != 0) {
                json.addProperty("max_level", (Number)AbstractModifierRecipeBuilder.this.maxLevel);
            }
        }
    }
}

