/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipeBuilder;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class IncrementalModifierRecipeBuilder
extends AbstractModifierRecipeBuilder<IncrementalModifierRecipeBuilder> {
    private class_1856 input = class_1856.field_9017;
    private int amountPerItem;
    private int neededPerLevel;
    private class_1799 leftover = class_1799.field_8037;

    protected IncrementalModifierRecipeBuilder(ModifierEntry result) {
        super(result);
    }

    public static IncrementalModifierRecipeBuilder modifier(ModifierEntry modifier) {
        return new IncrementalModifierRecipeBuilder(modifier);
    }

    public static IncrementalModifierRecipeBuilder modifier(ModifierId modifier) {
        return IncrementalModifierRecipeBuilder.modifier(new ModifierEntry(modifier, 1));
    }

    public static IncrementalModifierRecipeBuilder modifier(LazyModifier modifier) {
        return IncrementalModifierRecipeBuilder.modifier(modifier.getId());
    }

    public IncrementalModifierRecipeBuilder setInput(class_1856 input, int amountPerItem, int neededPerLevel) {
        if (amountPerItem < 1) {
            throw new IllegalArgumentException("Amount per item must be at least 1");
        }
        if (neededPerLevel <= amountPerItem) {
            throw new IllegalArgumentException("Needed per level must be greater than amount per item");
        }
        this.input = input;
        this.amountPerItem = amountPerItem;
        this.neededPerLevel = neededPerLevel;
        return this;
    }

    public IncrementalModifierRecipeBuilder setInput(class_1935 item, int amountPerItem, int neededPerLevel) {
        return this.setInput(class_1856.method_8091((class_1935[])new class_1935[]{item}), amountPerItem, neededPerLevel);
    }

    public IncrementalModifierRecipeBuilder setInput(class_6862<class_1792> tag, int amountPerItem, int neededPerLevel) {
        return this.setInput(class_1856.method_8106(tag), amountPerItem, neededPerLevel);
    }

    public void save(Consumer<class_2444> consumer, class_2960 id) {
        if (this.input == class_1856.field_9017) {
            throw new IllegalStateException("Must set input");
        }
        class_2960 advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((class_2444)new FinishedAdding(id, advancementId, false));
        if (this.includeUnarmed) {
            if (this.requirements != ModifierMatch.ALWAYS) {
                throw new IllegalStateException("Cannot use includeUnarmed with requirements");
            }
            consumer.accept((class_2444)new FinishedAdding(new class_2960(id.method_12836(), id.method_12832() + "_unarmed"), null, true));
        }
    }

    @Override
    public IncrementalModifierRecipeBuilder saveSalvage(Consumer<class_2444> consumer, class_2960 id) {
        if (this.salvageMaxLevel != 0 && this.salvageMaxLevel < this.salvageMinLevel) {
            throw new IllegalStateException("Max level must be greater than min level");
        }
        class_2960 advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((class_2444)new AbstractModifierRecipeBuilder.SalvageFinishedRecipe(this, id, advancementId));
        return this;
    }

    public static JsonElement serializeResult(class_1799 result) {
        String itemName = Objects.requireNonNull(result.method_7909().getRegistryName()).toString();
        if (result.method_7985()) {
            JsonObject jsonResult = new JsonObject();
            jsonResult.addProperty("item", itemName);
            int count = result.method_7947();
            if (count > 1) {
                jsonResult.addProperty("count", (Number)count);
            }
            jsonResult.addProperty("nbt", Objects.requireNonNull(result.method_7969()).toString());
            return jsonResult;
        }
        return new JsonPrimitive(itemName);
    }

    public IncrementalModifierRecipeBuilder setLeftover(class_1799 leftover) {
        this.leftover = leftover;
        return this;
    }

    private class FinishedAdding
    extends AbstractModifierRecipeBuilder.ModifierFinishedRecipe {
        public FinishedAdding(@Nullable class_2960 ID, class_2960 advancementID, boolean withUnarmed) {
            super(IncrementalModifierRecipeBuilder.this, ID, advancementID, withUnarmed);
        }

        @Override
        public void method_10416(JsonObject json) {
            json.add("input", IncrementalModifierRecipeBuilder.this.input.method_8089());
            json.addProperty("amount_per_item", (Number)IncrementalModifierRecipeBuilder.this.amountPerItem);
            json.addProperty("needed_per_level", (Number)IncrementalModifierRecipeBuilder.this.neededPerLevel);
            if (IncrementalModifierRecipeBuilder.this.leftover != class_1799.field_8037) {
                json.add("leftover", IncrementalModifierRecipeBuilder.serializeResult(IncrementalModifierRecipeBuilder.this.leftover));
            }
            super.method_10416(json);
        }

        public class_1865<?> method_17800() {
            return (class_1865)TinkerModifiers.incrementalModifierSerializer.get();
        }
    }
}

