/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRecipe
extends AbstractModifierRecipe {
    protected final List<SizedIngredient> inputs;

    public ModifierRecipe(class_2960 id, List<SizedIngredient> inputs, class_1856 toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
        super(id, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots);
        this.inputs = inputs;
    }

    protected static BitSet makeBitset(ITinkerStationContainer inv) {
        int inputs = inv.getInputCount();
        BitSet used = new BitSet(inputs);
        for (int i = 0; i < inputs; ++i) {
            if (!inv.getInput(i).method_7960()) continue;
            used.set(i);
        }
        return used;
    }

    protected static int findMatch(SizedIngredient ingredient, ITinkerStationContainer inv, BitSet used) {
        for (int i = 0; i < inv.getInputCount(); ++i) {
            class_1799 stack;
            if (used.get(i) || !ingredient.test(stack = inv.getInput(i))) continue;
            used.set(i);
            return i;
        }
        return -1;
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, class_1937 world) {
        if (!this.result.isBound() || !this.toolRequirement.method_8093(inv.getTinkerableStack())) {
            return false;
        }
        BitSet used = ModifierRecipe.makeBitset(inv);
        for (SizedIngredient ingredient : this.inputs) {
            int index = ModifierRecipe.findMatch(ingredient, inv, used);
            if (index != -1) continue;
            return false;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            if (used.get(i) || inv.getInput(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        class_1799 tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        ValidatedResult commonError = this.validatePrerequisites(tool);
        if (commonError.hasError()) {
            return commonError;
        }
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        SlotType.SlotCount slots = this.getSlots();
        if (slots != null) {
            persistentData.addSlots(slots.getType(), -slots.getCount());
        }
        tool.addModifier(this.result.getId(), this.result.getLevel());
        ValidatedResult toolValidation = tool.validate();
        if (toolValidation.hasError()) {
            return toolValidation;
        }
        return ValidatedResult.success(tool.createStack(Math.min(tinkerable.method_7947(), this.shrinkToolSlotBy())));
    }

    @Override
    public void updateInputs(class_1799 result, IMutableTinkerStationContainer inv, boolean isServer) {
        BitSet used = ModifierRecipe.makeBitset(inv);
        for (SizedIngredient ingredient : this.inputs) {
            int index = ModifierRecipe.findMatch(ingredient, inv, used);
            if (index != -1) {
                inv.shrinkInput(index, ingredient.getAmountNeeded());
                continue;
            }
            TConstruct.LOG.warn("Missing ingredient in modifier recipe input consume");
        }
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerModifiers.modifierSerializer.get();
    }

    @Override
    public int getInputCount() {
        return this.inputs.size();
    }

    @Override
    public List<class_1799> getDisplayItems(int slot) {
        if (slot >= 0 && slot < this.inputs.size()) {
            return this.inputs.get(slot).getMatchingStacks();
        }
        return Collections.emptyList();
    }

    public static class Serializer
    extends AbstractModifierRecipe.Serializer<ModifierRecipe> {
        @Override
        public ModifierRecipe fromJson(class_2960 id, JsonObject json, class_1856 toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            List ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            return new ModifierRecipe(id, ingredients, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots);
        }

        @Override
        public ModifierRecipe fromNetwork(class_2960 id, class_2540 buffer, class_1856 toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            int size = buffer.method_10816();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)SizedIngredient.read((class_2540)buffer));
            }
            return new ModifierRecipe(id, (List<SizedIngredient>)builder.build(), toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots);
        }

        @Override
        protected void toNetworkSafe(class_2540 buffer, ModifierRecipe recipe) {
            super.toNetworkSafe(buffer, recipe);
            buffer.method_10804(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
        }
    }
}

