/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.slotless.OverslimeModifier;

public class OverslimeModifierRecipe
implements ITinkerStationRecipe,
IDisplayModifierRecipe {
    private static final ValidatedResult AT_CAPACITY = ValidatedResult.failure(TConstruct.makeTranslationKey("recipe", "overslime.at_capacity"), new Object[0]);
    private final class_2960 id;
    private final class_1856 ingredient;
    private final int restoreAmount;
    private static final ModifierEntry RESULT = new ModifierEntry(TinkerModifiers.overslime, 1);
    private List<class_1799> toolWithoutModifier;
    private List<class_1799> toolWithModifier = null;

    public OverslimeModifierRecipe(class_2960 id, class_1856 ingredient, int restoreAmount) {
        this.id = id;
        this.ingredient = ingredient;
        this.restoreAmount = restoreAmount;
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, class_1937 world) {
        if (!inv.getTinkerableStack().method_31573(TinkerTags.Items.DURABILITY)) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        class_1799 tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        ModifierId overslimeId = TinkerModifiers.overslime.getId();
        if (tool.getUpgrades().getLevel(overslimeId) == 0) {
            if (tool.getModifierLevel(overslimeId) > 0 && overslime.getOverslime(tool) >= overslime.getCapacity(tool)) {
                return AT_CAPACITY;
            }
            tool = tool.copy();
            tool.addModifier(TinkerModifiers.overslime.getId(), 1);
        } else {
            if (overslime.getOverslime(tool) >= overslime.getCapacity(tool)) {
                return AT_CAPACITY;
            }
            tool = tool.copy();
        }
        int available = IncrementalModifierRecipe.getAvailableAmount(inv, this.ingredient, this.restoreAmount);
        overslime.addOverslime(tool, available);
        return ValidatedResult.success(tool.createStack(Math.min(tinkerable.method_7947(), this.shrinkToolSlotBy())));
    }

    @Override
    public void updateInputs(class_1799 result, IMutableTinkerStationContainer inv, boolean isServer) {
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        int current = 0;
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        if (tool.getModifierLevel(overslime) != 0) {
            current = overslime.getOverslime(tool);
        }
        int maxNeeded = overslime.getOverslime(ToolStack.from(result)) - current;
        IncrementalModifierRecipe.updateInputs(inv, this.ingredient, maxNeeded, this.restoreAmount, class_1799.field_8037);
    }

    @Deprecated
    public class_1799 method_8110() {
        return class_1799.field_8037;
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerModifiers.overslimeSerializer.get();
    }

    @Override
    public int getInputCount() {
        return 1;
    }

    @Override
    public List<class_1799> getDisplayItems(int slot) {
        if (slot == 0) {
            return Arrays.asList(this.ingredient.method_8105());
        }
        return Collections.emptyList();
    }

    @Override
    public List<class_1799> getToolWithoutModifier() {
        if (this.toolWithoutModifier == null) {
            this.toolWithoutModifier = RegistryHelper.getTagValueStream((class_2378)class_2378.field_11142, TinkerTags.Items.DURABILITY).map(MAP_TOOL_FOR_RENDERING).toList();
        }
        return this.toolWithoutModifier;
    }

    @Override
    public List<class_1799> getToolWithModifier() {
        if (this.toolWithModifier == null) {
            OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
            this.toolWithModifier = RegistryHelper.getTagValueStream((class_2378)class_2378.field_11142, TinkerTags.Items.DURABILITY).map(MAP_TOOL_FOR_RENDERING).map(stack -> IDisplayModifierRecipe.withModifiers(stack, null, RESULT, data -> overslime.setShield((ModDataNBT)data, this.restoreAmount))).toList();
        }
        return this.toolWithModifier;
    }

    @Override
    public ModifierEntry getDisplayResult() {
        return RESULT;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<OverslimeModifierRecipe> {
        public OverslimeModifierRecipe fromJson(class_2960 id, JsonObject json) {
            class_1856 ingredient = class_1856.method_8102((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
            int restoreAmount = class_3518.method_15260((JsonObject)json, (String)"restore_amount");
            return new OverslimeModifierRecipe(id, ingredient, restoreAmount);
        }

        @Nullable
        protected OverslimeModifierRecipe fromNetworkSafe(class_2960 id, class_2540 buffer) {
            class_1856 ingredient = class_1856.method_8086((class_2540)buffer);
            int restoreAmount = buffer.method_10816();
            return new OverslimeModifierRecipe(id, ingredient, restoreAmount);
        }

        protected void toNetworkSafe(class_2540 buffer, OverslimeModifierRecipe recipe) {
            recipe.ingredient.method_8088(buffer);
            buffer.method_10804(recipe.restoreAmount);
        }
    }
}

