/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SwappableModifierRecipe
extends ModifierRecipe {
    private final String value;

    public SwappableModifierRecipe(class_2960 id, List<SizedIngredient> inputs, class_1856 toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierId result, String value, @Nullable SlotType.SlotCount slots) {
        super(id, inputs, toolRequirement, maxToolSize, requirements, requirementsError, new ModifierEntry(result, 1), 1, slots);
        this.value = value;
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        SlotType.SlotCount slots;
        ValidatedResult commonError;
        boolean needsModifier;
        class_1799 tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        ModifierId modifier = this.result.getId();
        if (tool.getUpgrades().getLevel(modifier) == 0) {
            needsModifier = true;
            commonError = this.validatePrerequisites(tool);
        } else {
            needsModifier = false;
            commonError = this.validateRequirements(tool);
        }
        if (commonError.hasError()) {
            return commonError;
        }
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        if (needsModifier && (slots = this.getSlots()) != null) {
            persistentData.addSlots(slots.getType(), -slots.getCount());
        }
        persistentData.putString(modifier, this.value);
        if (needsModifier) {
            tool.addModifier(this.result.getId(), 1);
        } else {
            tool.rebuildStats();
        }
        ValidatedResult toolValidation = tool.validate();
        if (toolValidation.hasError()) {
            return toolValidation;
        }
        return ValidatedResult.success(tool.createStack(Math.min(tinkerable.method_7947(), this.shrinkToolSlotBy())));
    }

    @Override
    public class_1865<?> method_8119() {
        return (class_1865)TinkerModifiers.swappableModifierSerializer.get();
    }

    @Override
    public List<class_1799> getToolWithModifier() {
        if (this.toolWithModifier == null) {
            ModifierId id = this.result.getId();
            this.toolWithModifier = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, this.requirements, this.result, data -> data.putString(id, this.value))).collect(Collectors.toList());
            this.toolWithModifier = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, this.requirements, this.result, data -> data.putString(id, this.value))).collect(Collectors.toList());
        }
        return this.toolWithModifier;
    }

    public static class Serializer
    extends AbstractModifierRecipe.Serializer<SwappableModifierRecipe> {
        @Override
        protected ModifierEntry readResult(JsonObject json) {
            JsonObject result = class_3518.method_15296((JsonObject)json, (String)"result");
            return new ModifierEntry(ModifierId.getFromJson(result, "name"), 1);
        }

        @Override
        public SwappableModifierRecipe fromJson(class_2960 id, JsonObject json, class_1856 toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            List ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            String value = class_3518.method_15265((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"), (String)"value");
            return new SwappableModifierRecipe(id, (List<SizedIngredient>)ingredients, toolRequirement, maxToolSize, requirements, requirementsError, result.getId(), value, slots);
        }

        @Override
        public SwappableModifierRecipe fromNetwork(class_2960 id, class_2540 buffer, class_1856 toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            int size = buffer.method_10816();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)SizedIngredient.read((class_2540)buffer));
            }
            String value = buffer.method_19772();
            return new SwappableModifierRecipe(id, (List<SizedIngredient>)builder.build(), toolRequirement, maxToolSize, requirements, requirementsError, result.getId(), value, slots);
        }

        @Override
        protected void toNetworkSafe(class_2540 buffer, SwappableModifierRecipe recipe) {
            super.toNetworkSafe(buffer, recipe);
            buffer.method_10804(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
            buffer.method_10814(recipe.value);
        }
    }
}

