/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.material.IMaterialValue;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderContainer;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.ItemPartRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.tables.TinkerTables;

public class PartRecipe
implements IPartBuilderRecipe,
IMultiRecipe<ItemPartRecipe> {
    protected final class_2960 id;
    protected final String group;
    protected final Pattern pattern;
    protected final class_1856 patternItem;
    protected final int cost;
    protected final IMaterialItem output;
    protected final int outputCount;
    @Nullable
    private List<ItemPartRecipe> multiRecipes;

    public class_1865<?> method_8119() {
        return (class_1865)TinkerTables.partRecipeSerializer.get();
    }

    @Override
    public boolean partialMatch(IPartBuilderContainer inv) {
        if (!this.patternItem.method_8093(inv.getPatternStack())) {
            return false;
        }
        class_1799 stack = inv.getStack();
        if (!stack.method_7960()) {
            if (stack.method_7909() == this.output) {
                return false;
            }
            IMaterialValue materialRecipe = inv.getMaterial();
            if (materialRecipe == null) {
                return false;
            }
            MaterialVariant material = materialRecipe.getMaterial();
            return material.get().isCraftable() && this.output.canUseMaterial(material.getId());
        }
        return true;
    }

    public boolean matches(IPartBuilderContainer inv, class_1937 world) {
        IMaterialValue materialRecipe = inv.getMaterial();
        if (materialRecipe != null) {
            MaterialVariant material = materialRecipe.getMaterial();
            return material.get().isCraftable() && this.output.canUseMaterial(material.getId()) && inv.getStack().method_7947() >= materialRecipe.getItemsUsed(this.cost);
        }
        return false;
    }

    @Deprecated
    public class_1799 method_8110() {
        return new class_1799((class_1935)this.output);
    }

    public class_1799 getRecipeOutput(MaterialVariantId material) {
        class_1799 stack = this.output.withMaterial(material);
        stack.method_7939(this.outputCount);
        return stack;
    }

    public class_1799 assemble(IPartBuilderContainer inv) {
        MaterialVariant material = MaterialVariant.UNKNOWN;
        IMaterialValue materialRecipe = inv.getMaterial();
        if (materialRecipe != null) {
            material = materialRecipe.getMaterial();
        }
        return this.getRecipeOutput(material.getVariant());
    }

    public List<ItemPartRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            this.multiRecipes = MaterialRegistry.getMaterials().stream().filter(mat -> mat.isCraftable() && this.output.canUseMaterial((IMaterial)mat)).map(mat -> {
                MaterialId materialId = mat.getIdentifier();
                return new ItemPartRecipe(materialId, mat.getIdentifier(), this.pattern, this.patternItem, this.getCost(), ItemOutput.fromStack((class_1799)this.output.withMaterial(materialId)));
            }).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }

    public PartRecipe(class_2960 id, String group, Pattern pattern, class_1856 patternItem, int cost, IMaterialItem output, int outputCount) {
        this.id = id;
        this.group = group;
        this.pattern = pattern;
        this.patternItem = patternItem;
        this.cost = cost;
        this.output = output;
        this.outputCount = outputCount;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public String method_8112() {
        return this.group;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<PartRecipe> {
        public PartRecipe fromJson(class_2960 recipeId, JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            Pattern pattern = new Pattern(class_3518.method_15265((JsonObject)json, (String)"pattern"));
            class_1856 patternItem = json.has("pattern_item") ? class_1856.method_8102((JsonElement)json.get("pattern_item")) : class_1856.method_8106(TinkerTags.Items.DEFAULT_PATTERNS);
            int cost = class_3518.method_15260((JsonObject)json, (String)"cost");
            JsonObject output = class_3518.method_15296((JsonObject)json, (String)"result");
            IMaterialItem item = (IMaterialItem)RecipeHelper.deserializeItem((String)class_3518.method_15265((JsonObject)output, (String)"item"), (String)"result", IMaterialItem.class);
            int count = class_3518.method_15282((JsonObject)output, (String)"count", (int)1);
            return new PartRecipe(recipeId, group, pattern, patternItem, cost, item, count);
        }

        @Nullable
        protected PartRecipe fromNetworkSafe(class_2960 recipeId, class_2540 buffer) {
            String group = buffer.method_10800(Short.MAX_VALUE);
            Pattern pattern = new Pattern(buffer.method_10800(Short.MAX_VALUE));
            class_1856 patternItem = class_1856.method_8086((class_2540)buffer);
            int cost = buffer.readInt();
            IMaterialItem item = (IMaterialItem)RecipeHelper.readItem((class_2540)buffer, IMaterialItem.class);
            byte count = buffer.readByte();
            return new PartRecipe(recipeId, group, pattern, patternItem, cost, item, count);
        }

        protected void toNetworkSafe(class_2540 buffer, PartRecipe recipe) {
            buffer.method_10814(recipe.group);
            buffer.method_10814(recipe.pattern.toString());
            recipe.patternItem.method_8088(buffer);
            buffer.writeInt(recipe.cost);
            RecipeHelper.writeItem((class_2540)buffer, (class_1935)recipe.output);
            buffer.writeByte(recipe.outputCount);
        }
    }
}

