/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.ModifierRepairRecipeSerializer;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRepairTinkerStationRecipe
implements ITinkerStationRecipe,
ModifierRepairRecipeSerializer.IModifierRepairRecipe {
    private final class_2960 id;
    private final ModifierId modifier;
    private final class_1856 ingredient;
    private final int repairAmount;

    @Override
    public boolean matches(ITinkerStationContainer inv, class_1937 world) {
        class_1799 tinkerable = inv.getTinkerableStack();
        if (!tinkerable.method_31573(TinkerTags.Items.DURABILITY)) {
            return false;
        }
        ToolStack tool = ToolStack.from(tinkerable);
        if (tool.getModifierLevel(this.modifier) == 0) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        int amountPerItem = tool.getModifierLevel(this.modifier) * this.repairAmount;
        if (amountPerItem <= 0) {
            return ValidatedResult.PASS;
        }
        float repairFactor = 1.0f;
        for (ModifierEntry entry : tool.getModifierList()) {
            repairFactor = entry.getModifier().getRepairFactor(tool, entry.getLevel(), repairFactor);
            if (!(repairFactor <= 0.0f)) continue;
            return ValidatedResult.PASS;
        }
        int available = IncrementalModifierRecipe.getAvailableAmount(inv, this.ingredient, amountPerItem = (int)((float)amountPerItem * repairFactor));
        if (available <= 0) {
            return ValidatedResult.PASS;
        }
        tool = tool.copy();
        ToolDamageUtil.repair(tool, available);
        return ValidatedResult.success(tool.createStack());
    }

    @Override
    public int shrinkToolSlotBy() {
        return 1;
    }

    @Override
    public void updateInputs(class_1799 result, IMutableTinkerStationContainer inv, boolean isServer) {
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        float repairFactor = 1.0f;
        for (ModifierEntry entry : tool.getModifierList()) {
            repairFactor = entry.getModifier().getRepairFactor(tool, entry.getLevel(), repairFactor);
            if (!(repairFactor <= 0.0f)) continue;
            return;
        }
        int amountPerItem = (int)((float)(tool.getModifierLevel(this.modifier) * this.repairAmount) * repairFactor);
        if (amountPerItem < 0) {
            return;
        }
        int repairRemaining = tool.getDamage() - ToolStack.from(result).getDamage();
        IncrementalModifierRecipe.updateInputs(inv, this.ingredient, repairRemaining, amountPerItem, class_1799.field_8037);
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerModifiers.modifierRepair.get();
    }

    public class_1799 method_8110() {
        return class_1799.field_8037;
    }

    public ModifierRepairTinkerStationRecipe(class_2960 id, ModifierId modifier, class_1856 ingredient, int repairAmount) {
        this.id = id;
        this.modifier = modifier;
        this.ingredient = ingredient;
        this.repairAmount = repairAmount;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    @Override
    public ModifierId getModifier() {
        return this.modifier;
    }

    @Override
    public class_1856 getIngredient() {
        return this.ingredient;
    }

    @Override
    public int getRepairAmount() {
        return this.repairAmount;
    }
}

