/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2073;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.StatPredicate;

public class ToolPredicate
extends class_2073 {
    public static final class_2960 ID = TConstruct.getResource("tool");
    @Nullable
    protected final class_1792 item;
    @Nullable
    protected final class_6862<class_1792> tag;
    protected final List<MaterialId> materials;
    protected final boolean hasUpgrades;
    protected final ModifierMatch upgrades;
    protected final ModifierMatch modifiers;
    protected final List<StatPredicate> stats;

    public boolean method_8970(class_1799 stack) {
        if (this.tag != null && !stack.method_31573(this.tag)) {
            return false;
        }
        if (this.item != null && stack.method_7909() != this.item) {
            return false;
        }
        if (!stack.method_31573(TinkerTags.Items.MODIFIABLE)) {
            return false;
        }
        ToolStack tool = ToolStack.from(stack);
        block0: for (MaterialId check : this.materials) {
            for (MaterialVariant mat : tool.getMaterials().getList()) {
                if (!mat.getId().equals(check)) continue;
                continue block0;
            }
            return false;
        }
        if (this.hasUpgrades && tool.getUpgrades().isEmpty()) {
            return false;
        }
        if (this.upgrades != ModifierMatch.ALWAYS && !this.upgrades.test(tool.getUpgrades().getModifiers())) {
            return false;
        }
        if (this.modifiers != ModifierMatch.ALWAYS && !this.modifiers.test(tool.getModifierList())) {
            return false;
        }
        if (!this.stats.isEmpty()) {
            StatsNBT toolStats = tool.getStats();
            for (StatPredicate predicate : this.stats) {
                if (predicate.test(toolStats)) continue;
                return false;
            }
        }
        return true;
    }

    private static <D> JsonArray toArray(List<D> list, Function<D, JsonElement> mapper) {
        JsonArray array = new JsonArray();
        for (D data : list) {
            array.add(mapper.apply(data));
        }
        return array;
    }

    public JsonElement method_8971() {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        if (this.item != null) {
            json.addProperty("item", Objects.requireNonNull(class_2378.field_11142.method_10221((Object)this.item)).toString());
        }
        if (this.tag != null) {
            json.addProperty("tag", this.tag.comp_327().toString());
        }
        if (!this.materials.isEmpty()) {
            json.add("materials", (JsonElement)ToolPredicate.toArray(this.materials, mat -> new JsonPrimitive(mat.toString())));
        }
        if (this.hasUpgrades) {
            json.addProperty("has_upgrades", Boolean.valueOf(true));
        }
        if (this.upgrades != ModifierMatch.ALWAYS) {
            json.add("upgrades", (JsonElement)this.upgrades.serialize());
        }
        if (this.modifiers != ModifierMatch.ALWAYS) {
            json.add("modifiers", (JsonElement)this.modifiers.serialize());
        }
        if (!this.stats.isEmpty()) {
            json.add("stats", (JsonElement)ToolPredicate.toArray(this.stats, StatPredicate::serialize));
        }
        return json;
    }

    public static ToolPredicate deserialize(JsonObject json) {
        class_1792 item = null;
        if (json.has("item")) {
            item = (class_1792)RecipeHelper.deserializeItem((String)class_3518.method_15265((JsonObject)json, (String)"item"), (String)"item", class_1792.class);
        }
        class_6862 tag = null;
        if (json.has("tag")) {
            tag = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)JsonHelper.getResourceLocation((JsonObject)json, (String)"tag"));
        }
        List materials = Collections.emptyList();
        if (json.has("materials")) {
            materials = JsonHelper.parseList((JsonObject)json, (String)"materials", (element, key) -> new MaterialId(class_3518.method_15287((JsonElement)element, (String)key)));
        }
        boolean hasUpgrades = class_3518.method_15258((JsonObject)json, (String)"has_upgrades", (boolean)false);
        ModifierMatch upgrades = ModifierMatch.ALWAYS;
        if (json.has("upgrades")) {
            upgrades = ModifierMatch.deserialize(class_3518.method_15296((JsonObject)json, (String)"upgrades"));
        }
        ModifierMatch modifiers = ModifierMatch.ALWAYS;
        if (json.has("modifiers")) {
            modifiers = ModifierMatch.deserialize(class_3518.method_15296((JsonObject)json, (String)"modifiers"));
        }
        List stats = Collections.emptyList();
        if (json.has("stats")) {
            stats = JsonHelper.parseList((JsonObject)json, (String)"stats", StatPredicate::deserialize);
        }
        return new ToolPredicate(item, (class_6862<class_1792>)tag, materials, hasUpgrades, upgrades, modifiers, stats);
    }

    public static Builder builder(class_1792 item) {
        return new Builder(item, null);
    }

    public static Builder builder(class_6862<class_1792> tag) {
        return new Builder(null, tag);
    }

    public static Builder builder() {
        return new Builder(null, null);
    }

    protected ToolPredicate(@Nullable class_1792 item, @Nullable class_6862<class_1792> tag, List<MaterialId> materials, boolean hasUpgrades, ModifierMatch upgrades, ModifierMatch modifiers, List<StatPredicate> stats) {
        this.item = item;
        this.tag = tag;
        this.materials = materials;
        this.hasUpgrades = hasUpgrades;
        this.upgrades = upgrades;
        this.modifiers = modifiers;
        this.stats = stats;
    }

    public static class Builder {
        @Nullable
        protected final class_1792 item;
        @Nullable
        protected final class_6862<class_1792> tag;
        protected final List<MaterialId> materials = new ArrayList<MaterialId>();
        protected boolean hasUpgrades = false;
        protected ModifierMatch upgrades = ModifierMatch.ALWAYS;
        protected ModifierMatch modifiers = ModifierMatch.ALWAYS;
        protected final List<StatPredicate> stats = new ArrayList<StatPredicate>();

        protected Builder(@Nullable class_1792 item, @Nullable class_6862<class_1792> tag) {
            this.item = item;
            this.tag = tag;
        }

        public Builder withMaterial(MaterialId material) {
            this.materials.add(material);
            return this;
        }

        public Builder withStat(StatPredicate predicate) {
            this.stats.add(predicate);
            return this;
        }

        public ToolPredicate build() {
            return new ToolPredicate(this.item, this.tag, this.materials, this.hasUpgrades, this.upgrades, this.modifiers, this.stats);
        }

        public Builder hasUpgrades(boolean hasUpgrades) {
            this.hasUpgrades = hasUpgrades;
            return this;
        }

        public Builder upgrades(ModifierMatch upgrades) {
            this.upgrades = upgrades;
            return this;
        }

        public Builder modifiers(ModifierMatch modifiers) {
            this.modifiers = modifiers;
            return this;
        }
    }
}

