/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import io.github.fabricators_of_create.porting_lib.util.Lazy;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ToolCapabilityProvider {
    private static final List<BiFunction<class_1799, Supplier<? extends IToolStackView>, IToolCapabilityProvider>> PROVIDER_CONSTRUCTORS = new ArrayList<BiFunction<class_1799, Supplier<? extends IToolStackView>, IToolCapabilityProvider>>();
    private final Lazy<ToolStack> tool = Lazy.of(() -> ToolStack.from(stack));
    private final List<IToolCapabilityProvider> providers = PROVIDER_CONSTRUCTORS.stream().map(con -> (IToolCapabilityProvider)con.apply(stack, this.tool)).filter(Objects::nonNull).collect(Collectors.toList());

    public ToolCapabilityProvider(class_1799 stack) {
    }

    public <T> LazyOptional<T> getCapability(Class<T> cap, @Nullable class_2350 side) {
        ToolStack toolStack = (ToolStack)this.tool.get();
        toolStack.clearCache();
        for (IToolCapabilityProvider provider : this.providers) {
            provider.clearCache();
            LazyOptional<T> optional = provider.getCapability(toolStack, cap);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return LazyOptional.empty();
    }

    public static void register(BiFunction<class_1799, Supplier<? extends IToolStackView>, IToolCapabilityProvider> constructor) {
        PROVIDER_CONSTRUCTORS.add(constructor);
    }

    @FunctionalInterface
    public static interface IToolCapabilityProvider {
        public <T> LazyOptional<T> getCapability(IToolStackView var1, Class<T> var2);

        default public void clearCache() {
        }
    }
}

