/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import slimeknights.mantle.transfer.fluid.IFluidHandlerItem;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ToolFluidCapability
implements IFluidHandlerItem {
    public static final class_2960 TOTAL_TANKS = TConstruct.getResource("total_tanks");
    private final class_1799 container;
    private final Supplier<? extends IToolStackView> tool;

    public int getTanks() {
        return this.tool.get().getVolatileData().getInt(TOTAL_TANKS);
    }

    private <T> T runForTank(int tank, T defaultValue, ITankCallback<T> function) {
        IToolStackView tool = this.tool.get();
        for (ModifierEntry entry : tool.getModifierList()) {
            IFluidModifier fluidModifier = entry.getModifier().getModule(IFluidModifier.class);
            if (fluidModifier == null) continue;
            int currentTanks = fluidModifier.getTanks(tool.getVolatileData());
            if (tank < currentTanks) {
                return function.run(fluidModifier, tool, entry.getLevel(), tank);
            }
            tank -= currentTanks;
        }
        return defaultValue;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.runForTank(tank, FluidStack.EMPTY, IFluidModifier::getFluidInTank);
    }

    public long getTankCapacity(int tank) {
        return this.runForTank(tank, 0L, IFluidModifier::getTankCapacity);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.runForTank(tank, false, (module, tool, level, tank1) -> module.isFluidValid(tool, level, tank1, stack));
    }

    public long fill(FluidStack resource, boolean sim) {
        int totalFilled = 0;
        IToolStackView tool = this.tool.get();
        for (ModifierEntry entry : tool.getModifierList()) {
            long filled;
            IFluidModifier fluidModifier = entry.getModifier().getModule(IFluidModifier.class);
            if (fluidModifier == null || (filled = fluidModifier.fill(tool, entry.getLevel(), resource, sim)) <= 0L) continue;
            if (filled >= resource.getAmount()) {
                return (long)totalFilled + filled;
            }
            if (totalFilled == 0) {
                resource = resource.copy();
            }
            totalFilled = (int)((long)totalFilled + filled);
            resource.shrink(filled);
        }
        return totalFilled;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, boolean sim) {
        FluidStack drainedSoFar = FluidStack.EMPTY;
        IToolStackView tool = this.tool.get();
        for (ModifierEntry entry : tool.getModifierList()) {
            FluidStack drained;
            IFluidModifier fluidModifier = entry.getModifier().getModule(IFluidModifier.class);
            if (fluidModifier == null || (drained = fluidModifier.drain(tool, entry.getLevel(), resource, sim)).isEmpty()) continue;
            if (drainedSoFar.isEmpty()) {
                if (drained.getAmount() >= resource.getAmount()) {
                    return drained;
                }
                drainedSoFar = drained;
                resource = resource.copy();
            } else {
                drainedSoFar.grow(drained.getAmount());
            }
            resource.shrink(drained.getAmount());
            if (!resource.isEmpty()) continue;
            return drainedSoFar;
        }
        return drainedSoFar;
    }

    @Nonnull
    public FluidStack drain(long maxDrain, boolean sim) {
        FluidStack drainedSoFar = FluidStack.EMPTY;
        FluidStack toDrain = FluidStack.EMPTY;
        IToolStackView tool = this.tool.get();
        for (ModifierEntry entry : tool.getModifierList()) {
            FluidStack drained;
            IFluidModifier fluidModifier = entry.getModifier().getModule(IFluidModifier.class);
            if (fluidModifier == null) continue;
            if (toDrain.isEmpty()) {
                drained = fluidModifier.drain(tool, entry.getLevel(), maxDrain, sim);
                if (drained.isEmpty()) continue;
                if ((maxDrain -= drained.getAmount()) > 0L) {
                    drainedSoFar = drained;
                    toDrain = new FluidStack(drained, maxDrain);
                    continue;
                }
                return drained;
            }
            drained = fluidModifier.drain(tool, entry.getLevel(), toDrain, sim);
            if (drained.isEmpty()) continue;
            drainedSoFar.grow(drained.getAmount());
            toDrain.shrink(drained.getAmount());
            if (!toDrain.isEmpty()) continue;
            return drainedSoFar;
        }
        return drainedSoFar;
    }

    public static void addTanks(ModDataNBT volatileData, IFluidModifier modifier) {
        volatileData.putInt(TOTAL_TANKS, modifier.getTanks(volatileData) + volatileData.getInt(TOTAL_TANKS));
    }

    public ToolFluidCapability(class_1799 container, Supplier<? extends IToolStackView> tool) {
        this.container = container;
        this.tool = tool;
    }

    public class_1799 getContainer() {
        return this.container;
    }

    public static interface IFluidModifier {
        default public int getTanks(IModDataView volatileData) {
            return 0;
        }

        default public FluidStack getFluidInTank(IToolStackView tool, int level, int tank) {
            return FluidStack.EMPTY;
        }

        default public long getTankCapacity(IToolStackView tool, int level, int tank) {
            return 0L;
        }

        default public boolean isFluidValid(IToolStackView tool, int level, int tank, FluidStack fluid) {
            return true;
        }

        public long fill(IToolStackView var1, int var2, FluidStack var3, boolean var4);

        public FluidStack drain(IToolStackView var1, int var2, FluidStack var3, boolean var4);

        public FluidStack drain(IToolStackView var1, int var2, long var3, boolean var5);
    }

    @FunctionalInterface
    private static interface ITankCallback<T> {
        public T run(IFluidModifier var1, IToolStackView var2, int var3, int var4);
    }

    public static class Provider
    implements ToolCapabilityProvider.IToolCapabilityProvider {
        private final LazyOptional<IFluidHandlerItem> fluidCap = LazyOptional.of(() -> new ToolFluidCapability(stack, toolStack));

        public Provider(class_1799 stack, Supplier<? extends IToolStackView> toolStack) {
        }

        @Override
        public <T> LazyOptional<T> getCapability(IToolStackView tool, Class<T> cap) {
            if (cap == IFluidHandlerItem.class && tool.getVolatileData().getInt(TOTAL_TANKS) > 0) {
                return this.fluidCap.cast();
            }
            return LazyOptional.empty();
        }
    }
}

