/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import io.github.fabricators_of_create.porting_lib.util.NetworkUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_747;
import slimeknights.mantle.transfer.item.IItemHandler;
import slimeknights.mantle.transfer.item.IItemHandlerModifiable;
import slimeknights.mantle.transfer.item.ItemHandlerHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.tools.menu.ToolContainerMenu;

public class ToolInventoryCapability
implements IItemHandlerModifiable {
    public static final class_2960 TOTAL_SLOTS = TConstruct.getResource("total_item_slots");
    public static final class_2960 INCLUDE_OFFHAND = TConstruct.getResource("inventory_show_offhand");
    private final Supplier<? extends IToolStackView> tool;
    private class_1799[] cachedStacks;
    private int slots = -1;
    private int startForSlot = 0;
    private int modifierLevel = 0;

    public int getSlots() {
        if (this.slots == -1) {
            this.slots = this.tool.get().getVolatileData().getInt(TOTAL_SLOTS);
        }
        return this.slots;
    }

    @Nullable
    private IInventoryModifier getInventory(int slot) {
        IToolStackView tool = this.tool.get();
        if (slot < this.getSlots()) {
            int start = 0;
            List<ModifierEntry> modifiers = tool.getModifierList();
            for (int i = modifiers.size() - 1; i >= 0; --i) {
                ModifierEntry entry = modifiers.get(i);
                IInventoryModifier inventory = entry.getModifier().getModule(IInventoryModifier.class);
                if (inventory == null) continue;
                int slots = inventory.getSlots(tool, entry.getLevel());
                if (slot < slots + start) {
                    this.startForSlot = start;
                    this.modifierLevel = entry.getLevel();
                    return inventory;
                }
                start += slots;
            }
        }
        return null;
    }

    public static boolean isBlacklisted(class_1799 stack) {
        return !stack.method_7909().method_31568() || stack.method_31573(TinkerTags.Items.TOOL_INVENTORY_BLACKLIST);
    }

    public boolean isItemValid(int slot, class_1799 stack) {
        if (!stack.method_7960() && ToolInventoryCapability.isBlacklisted(stack)) {
            return false;
        }
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory != null) {
            return inventory.isItemValid(this.tool.get(), slot - this.startForSlot, stack);
        }
        return false;
    }

    public int getSlotLimit(int slot) {
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory != null) {
            return inventory.getSlotLimit(this.tool.get(), slot - this.startForSlot);
        }
        return 0;
    }

    private void clearCache() {
        this.slots = -1;
        this.cachedStacks = null;
    }

    private void cacheStack(int slot, class_1799 stack) {
        int slots;
        if (slot >= 0 && slot < (slots = this.getSlots())) {
            if (this.cachedStacks == null) {
                this.cachedStacks = new class_1799[this.getSlots()];
            }
            this.cachedStacks[slot] = stack;
        }
    }

    @Nullable
    private class_1799 getCachedStack(int slot) {
        if (this.cachedStacks != null && slot >= 0 && slot < this.getSlots()) {
            return this.cachedStacks[slot];
        }
        return null;
    }

    private void setAndCache(IInventoryModifier inventory, int localSlot, int globalSlot, class_1799 stack) {
        inventory.setStack(this.tool.get(), this.modifierLevel, localSlot, stack);
        this.cacheStack(globalSlot, stack);
    }

    public void setStackInSlot(int slot, class_1799 stack) {
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory != null) {
            this.setAndCache(inventory, slot - this.startForSlot, slot, stack);
        }
    }

    private class_1799 getAndCache(IInventoryModifier inventory, int localSlot, int globalSlot) {
        class_1799 stack = inventory.getStack(this.tool.get(), this.modifierLevel, localSlot);
        this.cacheStack(globalSlot, stack);
        return stack;
    }

    private class_1799 getCached(IInventoryModifier inventory, int localSlot, int globalSlot) {
        class_1799 stack = this.getCachedStack(globalSlot);
        if (stack == null) {
            stack = this.getAndCache(inventory, localSlot, globalSlot);
        }
        return stack;
    }

    @Nonnull
    public class_1799 getStackInSlot(int slot) {
        class_1799 cached = this.getCachedStack(slot);
        if (cached != null) {
            return cached;
        }
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory != null) {
            return this.getAndCache(inventory, slot - this.startForSlot, slot);
        }
        return class_1799.field_8037;
    }

    @Nonnull
    public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
        int leftover;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (ToolInventoryCapability.isBlacklisted(stack)) {
            return stack;
        }
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory == null) {
            return stack;
        }
        int localSlot = slot - this.startForSlot;
        IToolStackView tool = this.tool.get();
        if (!inventory.isItemValid(tool, localSlot, stack)) {
            return stack;
        }
        class_1799 current = this.getCached(inventory, localSlot, slot);
        int slotLimit = inventory.getSlotLimit(tool, localSlot);
        if (current.method_7960()) {
            int canInsert = Math.min(stack.method_7947(), Math.min(stack.method_7914(), slotLimit));
            leftover = stack.method_7947() - canInsert;
            if (!simulate) {
                this.setAndCache(inventory, localSlot, slot, ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)canInsert));
            }
        } else {
            int limit = Math.min(current.method_7914(), slotLimit);
            if (current.method_7947() >= limit || !current.method_7962(stack)) {
                return stack;
            }
            int maxSize = current.method_7947() + stack.method_7947();
            int newSize = Math.min(maxSize, limit);
            leftover = maxSize - newSize;
            if (!simulate) {
                current.method_7939(newSize);
                inventory.setStack(tool, this.modifierLevel, localSlot, current);
            }
        }
        if (leftover == 0) {
            return class_1799.field_8037;
        }
        return ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)leftover);
    }

    @Nonnull
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return class_1799.field_8037;
        }
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory == null) {
            return class_1799.field_8037;
        }
        int localSlot = slot - this.startForSlot;
        class_1799 current = this.getCached(inventory, localSlot, slot);
        if (current.method_7960()) {
            return class_1799.field_8037;
        }
        if (amount > current.method_7947()) {
            amount = current.method_7947();
        }
        class_1799 result = ItemHandlerHelper.copyStackWithSize((class_1799)current, (int)amount);
        if (!simulate) {
            if (amount == current.method_7947()) {
                this.setAndCache(inventory, localSlot, slot, class_1799.field_8037);
            } else {
                current.method_7934(amount);
                inventory.setStack(this.tool.get(), this.modifierLevel, localSlot, current);
            }
        }
        return result;
    }

    public static void addSlots(ModDataNBT volatileData, int count) {
        volatileData.putInt(TOTAL_SLOTS, volatileData.getInt(TOTAL_SLOTS) + count);
    }

    public static class_1269 tryOpenContainer(class_1799 stack, IToolStackView tool, class_1657 player, class_1304 slotType) {
        return ToolInventoryCapability.tryOpenContainer(stack, tool, tool.getDefinition(), player, slotType);
    }

    public static class_1269 tryOpenContainer(class_1799 stack, @Nullable IToolStackView tool, ToolDefinition definition, class_1657 player, class_1304 slotType) {
        IItemHandler handler = null;
        if (handler != null) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                NetworkUtil.openGui((class_3222)serverPlayer, (class_3908)new class_747((id, inventory, p) -> new ToolContainerMenu(id, inventory, stack, (IItemHandlerModifiable)handler, slotType), TooltipUtil.getDisplayName(stack, tool, definition)), buf -> buf.method_10817((Enum)slotType));
            }
            return class_1269.method_29236((boolean)player.field_6002.field_9236);
        }
        return class_1269.field_5811;
    }

    public ToolInventoryCapability(Supplier<? extends IToolStackView> tool) {
        this.tool = tool;
    }

    public static interface IInventoryModifier {
        public int getSlots(IToolStackView var1, int var2);

        public class_1799 getStack(IToolStackView var1, int var2, int var3);

        public void setStack(IToolStackView var1, int var2, int var3, class_1799 var4);

        default public int getSlotLimit(IToolStackView tool, int slot) {
            return 64;
        }

        default public boolean isItemValid(IToolStackView tool, int slot, class_1799 stack) {
            return true;
        }

        @Nullable
        default public Pattern getPattern(IToolStackView tool, int level, int slot, boolean hasStack) {
            return null;
        }
    }

    public static class Provider
    implements ToolCapabilityProvider.IToolCapabilityProvider {
        private final LazyOptional<ToolInventoryCapability> handler = LazyOptional.of(() -> new ToolInventoryCapability(tool));

        public Provider(class_1799 stack, Supplier<? extends IToolStackView> tool) {
        }

        @Override
        public <T> LazyOptional<T> getCapability(IToolStackView tool, Class<T> cap) {
            if (cap == IItemHandler.class && tool.getVolatileData().getInt(TOTAL_SLOTS) > 0) {
                return this.handler.cast();
            }
            return LazyOptional.empty();
        }

        @Override
        public void clearCache() {
            this.handler.ifPresent(ToolInventoryCapability::clearCache);
        }
    }
}

