/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1304;
import net.minecraft.class_1741;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import slimeknights.tconstruct.library.tools.definition.IToolStatProvider;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class ModifiableArmorMaterial
implements class_1741 {
    public static final class_1304[] ARMOR_SLOTS = new class_1304[]{class_1304.field_6166, class_1304.field_6172, class_1304.field_6174, class_1304.field_6169};
    private final class_2960 name;
    private final ToolDefinition[] armorDefinitions;
    private final class_3414 equipSound;

    public ModifiableArmorMaterial(class_2960 name, class_3414 equipSound, ToolDefinition ... armorDefinitions) {
        this.name = name;
        this.equipSound = equipSound;
        if (armorDefinitions.length != 4) {
            throw new IllegalArgumentException("Must have an armor definition for each slot");
        }
        this.armorDefinitions = armorDefinitions;
    }

    @Nullable
    public ToolDefinition getArmorDefinition(ArmorSlotType slotType) {
        return this.armorDefinitions[slotType.getIndex()];
    }

    private float getStat(FloatToolStat toolStat, @Nullable ArmorSlotType slotType) {
        ToolDefinition toolDefinition = slotType == null ? null : this.getArmorDefinition(slotType);
        float defaultValue = toolStat.getDefaultValue().floatValue();
        if (toolDefinition == null) {
            return defaultValue;
        }
        ToolDefinitionData data = toolDefinition.getData();
        return data.getBaseStat(toolStat).floatValue() * data.getMultiplier(toolStat);
    }

    public String method_7694() {
        return this.name.toString();
    }

    public class_2960 getNameLocation() {
        return this.name;
    }

    public int method_7696(class_1304 slotIn) {
        return (int)this.getStat(ToolStats.DURABILITY, ArmorSlotType.fromEquipment(slotIn));
    }

    public int method_7697(class_1304 slotIn) {
        return (int)this.getStat(ToolStats.ARMOR, ArmorSlotType.fromEquipment(slotIn));
    }

    public float method_7700() {
        return this.getStat(ToolStats.ARMOR_TOUGHNESS, ArmorSlotType.CHESTPLATE);
    }

    public float method_24355() {
        return this.getStat(ToolStats.KNOCKBACK_RESISTANCE, ArmorSlotType.CHESTPLATE);
    }

    public int method_7699() {
        return 0;
    }

    public class_1856 method_7695() {
        return class_1856.field_9017;
    }

    public static Builder builder(class_2960 name, ArmorSlotType ... slotTypes) {
        return new Builder(name, slotTypes);
    }

    public static Builder builder(class_2960 name) {
        return ModifiableArmorMaterial.builder(name, ArmorSlotType.values());
    }

    public class_3414 method_7698() {
        return this.equipSound;
    }

    public static class Builder {
        private final class_2960 name;
        private final ToolDefinition.Builder[] builders;
        private final ArmorSlotType[] slotTypes;
        private class_3414 soundEvent = class_3417.field_14581;

        protected Builder(class_2960 baseName, ArmorSlotType[] slotTypes) {
            this.name = baseName;
            this.builders = new ToolDefinition.Builder[4];
            this.slotTypes = slotTypes;
            for (ArmorSlotType slot : slotTypes) {
                this.builders[slot.getIndex()] = ToolDefinition.builder(new class_2960(baseName.method_12836(), baseName.method_12832() + "_" + slot.method_15434()));
            }
        }

        private ToolDefinition.Builder getBuilder(ArmorSlotType slotType) {
            ToolDefinition.Builder builder = this.builders[slotType.getIndex()];
            if (builder == null) {
                throw new IllegalArgumentException("Unsupported slot type " + slotType + " for material " + this.name);
            }
            return builder;
        }

        public Builder set(ArmorSlotType slot, Consumer<ToolDefinition.Builder> builderConsumer) {
            builderConsumer.accept(this.getBuilder(slot));
            return this;
        }

        public Builder set(Consumer<ToolDefinition.Builder> builderConsumer) {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.set(slotType, builderConsumer);
            }
            return this;
        }

        public Builder setStatsProvider(ArmorSlotType slot, IToolStatProvider statProvider) {
            this.getBuilder(slot).setStatsProvider(statProvider);
            return this;
        }

        public Builder setStatsProvider(IToolStatProvider statProvider) {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.setStatsProvider(slotType, statProvider);
            }
            return this;
        }

        public Builder skipRegister() {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.getBuilder(slotType).skipRegister();
            }
            return this;
        }

        public ModifiableArmorMaterial build() {
            ToolDefinition[] toolDefinitions = new ToolDefinition[4];
            for (ArmorSlotType slotType : this.slotTypes) {
                toolDefinitions[slotType.getIndex()] = this.builders[slotType.getIndex()].build();
            }
            return new ModifiableArmorMaterial(this.name, this.soundEvent, toolDefinitions);
        }

        public Builder setSoundEvent(class_3414 soundEvent) {
            this.soundEvent = soundEvent;
            return this;
        }
    }
}

