/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.fabricators_of_create.porting_lib.event.common.OnDatapackSyncCallback;
import io.github.fabricators_of_create.porting_lib.util.ToolAction;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3324;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.definition.DefinitionModifierSlots;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.definition.UpdateToolDefinitionDataPacket;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.harvest.IHarvestLogic;
import slimeknights.tconstruct.library.tools.definition.weapon.IWeaponAttack;
import slimeknights.tconstruct.library.tools.nbt.MultiplierNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;

public class ToolDefinitionLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Logger log = LogManager.getLogger(ToolDefinitionLoader.class);
    public static final String FOLDER = "tinkering/tool_definitions";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(StatsNBT.class, (Object)StatsNBT.SERIALIZER).registerTypeAdapter(MultiplierNBT.class, (Object)MultiplierNBT.SERIALIZER).registerTypeAdapter(PartRequirement.class, (Object)PartRequirement.SERIALIZER).registerTypeAdapter(DefinitionModifierSlots.class, (Object)DefinitionModifierSlots.SERIALIZER).registerTypeAdapter(ModifierEntry.class, (Object)ModifierEntry.SERIALIZER).registerTypeAdapter(ToolAction.class, (Object)ToolActionSerializer.INSTANCE).registerTypeHierarchyAdapter(IAreaOfEffectIterator.class, IAreaOfEffectIterator.LOADER).registerTypeHierarchyAdapter(IHarvestLogic.class, IHarvestLogic.LOADER).registerTypeHierarchyAdapter(IWeaponAttack.class, IWeaponAttack.LOADER).setPrettyPrinting().disableHtmlEscaping().create();
    private static final ToolDefinitionLoader INSTANCE = new ToolDefinitionLoader();
    private Map<class_2960, ToolDefinitionData> dataMap = Collections.emptyMap();
    private final Map<class_2960, ToolDefinition> definitions = new HashMap<class_2960, ToolDefinition>();

    private ToolDefinitionLoader() {
        super(GSON, FOLDER);
    }

    public static ToolDefinitionLoader getInstance() {
        return INSTANCE;
    }

    public static void init() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)INSTANCE);
        OnDatapackSyncCallback.EVENT.register(INSTANCE::onDatapackSync);
    }

    protected void updateDataFromServer(Map<class_2960, ToolDefinitionData> dataMap) {
        this.dataMap = dataMap;
        for (Map.Entry<class_2960, ToolDefinition> entry : this.definitions.entrySet()) {
            ToolDefinitionData data = dataMap.get(entry.getKey());
            ToolDefinition definition = entry.getValue();
            if (data != null) {
                definition.setData(data);
                continue;
            }
            definition.setDefaultData();
        }
    }

    protected void apply(Map<class_2960, JsonElement> splashList, class_3300 resourceManagerIn, class_3695 profilerIn) {
        long time = System.nanoTime();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<class_2960, ToolDefinition> entry : this.definitions.entrySet()) {
            class_2960 key = entry.getKey();
            ToolDefinition definition = entry.getValue();
            JsonElement element = splashList.get(key);
            if (element == null) {
                log.error("Missing tool definition for tool {}", (Object)key);
                definition.setDefaultData();
                continue;
            }
            try {
                ToolDefinitionData data = (ToolDefinitionData)GSON.fromJson((JsonElement)class_3518.method_15295((JsonElement)element, (String)"tool_definition"), ToolDefinitionData.class);
                definition.validate(data);
                builder.put((Object)key, (Object)data);
                definition.setData(data);
            }
            catch (Exception e) {
                log.error("Failed to load tool definition for tool {}", (Object)key, (Object)e);
                definition.setDefaultData();
            }
        }
        this.dataMap = builder.build();
        log.info("Loaded {} tool definitions in {} ms", (Object)this.dataMap.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    public Collection<ToolDefinition> getRegisteredToolDefinitions() {
        return this.definitions.values();
    }

    private void onDatapackSync(class_3324 playerList, @Nullable class_3222 player) {
        UpdateToolDefinitionDataPacket packet = new UpdateToolDefinitionDataPacket(this.dataMap);
        TinkerNetwork.getInstance().sendToPlayerList(player, playerList, (S2CPacket)packet);
    }

    public void registerToolDefinition(ToolDefinition definition) {
        class_2960 name = definition.getId();
        if (this.definitions.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate tool definition " + name);
        }
        this.definitions.put(name, definition);
    }

    public class_2960 getFabricId() {
        return TConstruct.getResource("tool_definition_loader");
    }

    private static enum ToolActionSerializer implements JsonSerializer<ToolAction>,
    JsonDeserializer<ToolAction>
    {
        INSTANCE;


        public ToolAction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return ToolAction.get((String)class_3518.method_15287((JsonElement)json, (String)"action"));
        }

        public JsonElement serialize(ToolAction src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.name());
        }
    }
}

