/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class ToolDamageUtil {
    public static void breakTool(class_1799 stack) {
        stack.method_7948().method_10556("tic_broken", true);
    }

    public static boolean isBroken(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10577("tic_broken");
    }

    public static boolean directDamage(IToolStackView tool, int amount, @Nullable class_1309 entity, @Nullable class_1799 stack) {
        int damage;
        if (entity instanceof class_1657 && ((class_1657)entity).method_7337()) {
            return false;
        }
        int durability = tool.getStats().getInt(ToolStats.DURABILITY);
        int current = durability - (damage = tool.getDamage());
        if ((amount = Math.min(amount, current)) > 0) {
            int newDamage = damage + amount;
            if (entity instanceof class_3222) {
                if (stack == null) {
                    stack = entity.method_6047();
                }
                class_174.field_1185.method_8960((class_3222)entity, stack, newDamage);
            }
            tool.setDamage(newDamage);
            return newDamage >= durability;
        }
        return false;
    }

    public static boolean damage(IToolStackView tool, int amount, @Nullable class_1309 entity, @Nullable class_1799 stack) {
        if (amount <= 0 || tool.isBroken() || tool.isUnbreakable()) {
            return false;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            amount = entry.getModifier().onDamageTool(tool, entry.getLevel(), amount, entity);
            if (amount >= 0) continue;
            return false;
        }
        return ToolDamageUtil.directDamage(tool, amount, entity, stack);
    }

    public static boolean damageAnimated(IToolStackView tool, int amount, class_1309 entity, class_1304 slot) {
        if (ToolDamageUtil.damage(tool, amount, entity, entity.method_6118(slot))) {
            entity.method_20235(slot);
            return true;
        }
        return false;
    }

    public static boolean damageAnimated(IToolStackView tool, int amount, class_1309 entity, class_1268 hand) {
        if (ToolDamageUtil.damage(tool, amount, entity, entity.method_5998(hand))) {
            entity.method_20236(hand);
            return true;
        }
        return false;
    }

    public static boolean damageAnimated(IToolStackView tool, int amount, class_1309 entity) {
        return ToolDamageUtil.damageAnimated(tool, amount, entity, class_1268.field_5808);
    }

    public static void repair(IToolStackView tool, int amount) {
        if (amount <= 0) {
            return;
        }
        int damage = tool.getDamage();
        if (damage == 0) {
            return;
        }
        int newDamage = damage - Math.min(amount, damage);
        tool.setDamage(newDamage);
    }

    public static boolean showDurabilityBar(class_1799 stack) {
        if (!stack.method_7909().method_7846()) {
            return false;
        }
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            Boolean show = entry.getModifier().showDurabilityBar(tool, entry.getLevel());
            if (show == null) continue;
            return show;
        }
        return tool.getDamage() > 0;
    }

    private static double getDamagePercentage(ToolStack tool) {
        for (ModifierEntry entry : tool.getModifierList()) {
            double display = entry.getModifier().getDamagePercentage(tool, entry.getLevel());
            if (Double.isNaN(display)) continue;
            return display;
        }
        return (double)tool.getDamage() / (double)tool.getStats().get(ToolStats.DURABILITY).floatValue();
    }

    public static int getDamageForDisplay(class_1799 stack) {
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return 0;
        }
        return (int)(1.0 + 12.0 * (1.0 - ToolDamageUtil.getDamagePercentage(tool)));
    }

    public static int getRGBDurabilityForDisplay(class_1799 stack) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            int rgb = entry.getModifier().getDurabilityRGB(tool, entry.getLevel());
            if (rgb == -1) continue;
            return rgb;
        }
        return class_3532.method_15369((float)(Math.max(0.0f, (float)(1.0 - ToolDamageUtil.getDamagePercentage(tool))) / 3.0f), (float)1.0f, (float)1.0f);
    }
}

