/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import io.github.fabricators_of_create.porting_lib.util.PortingHooks;
import io.github.fabricators_of_create.porting_lib.util.ToolActions;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.BlockSideHitListener;

public class ToolHarvestLogic {
    private ToolHarvestLogic() {
    }

    public static int getDamage(ToolStack tool, class_1937 world, class_2338 pos, class_2680 state) {
        if (state.method_26214((class_1922)world, pos) == 0.0f) {
            return !state.method_26164(class_3481.field_21952) && ModifierUtil.canPerformAction(tool, ToolActions.SHEARS_DIG) ? 1 : 0;
        }
        return tool.hasTag(TinkerTags.Items.HARVEST_PRIMARY) ? 1 : 2;
    }

    public static boolean isEffective(IToolStackView tool, class_2680 state) {
        return !tool.isBroken() && tool.getDefinition().getData().getHarvestLogic().isEffective(tool, state);
    }

    public static float getDestroySpeed(class_1799 stack, class_2680 state) {
        if (!stack.method_7985()) {
            return 1.0f;
        }
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return 0.3f;
        }
        return tool.getDefinition().getData().getHarvestLogic().getDestroySpeed(tool, state);
    }

    private static boolean removeBlock(IToolStackView tool, ToolHarvestContext context) {
        Boolean removed = null;
        if (!tool.isBroken()) {
            ModifierEntry entry;
            Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
            while (iterator.hasNext() && (removed = (entry = iterator.next()).getModifier().removeBlock(tool, entry.getLevel(), context)) == null) {
            }
        }
        class_2680 state = context.getState();
        class_3218 world = context.getWorld();
        class_2338 pos = context.getPos();
        if (removed == null) {
            state.method_26204().method_9576((class_1937)world, pos, state, (class_1657)context.getPlayer());
            removed = world.method_8652(pos, world.method_8316(pos).method_15759(), world.field_9236 ? 11 : 3);
        }
        if (removed.booleanValue()) {
            state.method_26204().method_9585((class_1936)world, pos, state);
        }
        return removed;
    }

    protected static boolean breakBlock(ToolStack tool, class_1799 stack, ToolHarvestContext context) {
        class_3222 player = Objects.requireNonNull(context.getPlayer());
        class_3218 world = context.getWorld();
        class_2338 pos = context.getPos();
        class_1934 type = player.field_13974.method_14257();
        int exp = PortingHooks.onBlockBreakEvent((class_1937)world, (class_1934)type, (class_3222)player, (class_2338)pos);
        if (exp == -1) {
            return false;
        }
        if (player.method_21701((class_1937)world, pos, type)) {
            return false;
        }
        if (player.method_7337()) {
            ToolHarvestLogic.removeBlock(tool, context);
            return true;
        }
        class_2680 state = context.getState();
        int damage = ToolHarvestLogic.getDamage(tool, (class_1937)world, pos, state);
        boolean canHarvest = context.canHarvest();
        class_2586 te = canHarvest ? world.method_8321(pos) : null;
        boolean removed = ToolHarvestLogic.removeBlock(tool, context);
        class_2248 block = state.method_26204();
        if (removed && canHarvest) {
            block.method_9556((class_1937)world, (class_1657)player, pos, state, te, stack);
        }
        if (removed && exp > 0) {
            block.method_9583(world, pos, exp);
        }
        if (!tool.isBroken()) {
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().afterBlockBreak(tool, entry.getLevel(), context);
            }
            ToolDamageUtil.damageAnimated(tool, damage, (class_1309)player);
        }
        return true;
    }

    public static void breakExtraBlock(ToolStack tool, class_1799 stack, ToolHarvestContext context) {
        if (ToolHarvestLogic.breakBlock(tool, stack, context)) {
            class_3218 world = context.getWorld();
            class_2338 pos = context.getPos();
            world.method_8474(2001, pos, class_2248.method_9507((class_2680)context.getState()));
            TinkerNetwork.getInstance().sendVanillaPacket((class_1297)Objects.requireNonNull(context.getPlayer()), (class_2596<?>)new class_2626((class_1922)world, pos));
        }
    }

    public static boolean handleBlockBreak(class_1799 stack, class_2338 pos, class_1657 player) {
        if (player.field_6002.field_9236 || !(player instanceof class_3222)) {
            return false;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_3218 world = serverPlayer.method_14220();
        ToolStack tool = ToolStack.from(stack);
        class_2680 state = world.method_8320(pos);
        class_2350 sideHit = BlockSideHitListener.getSideHit(player);
        if (tool.isBroken()) {
            player.method_6122(class_1268.field_5808, class_1799.field_8037);
            ToolHarvestContext context = new ToolHarvestContext(world, serverPlayer, state, pos, sideHit, !player.method_7337() && player.method_7305(state), false);
            ToolHarvestLogic.breakBlock(tool, class_1799.field_8037, context);
            player.method_6122(class_1268.field_5808, stack);
        } else {
            List<class_2338> extraBlocks;
            ToolHarvestContext context = new ToolHarvestContext(world, serverPlayer, state, pos, sideHit, !player.method_7337() && player.method_7305(state), ToolHarvestLogic.isEffective(tool, state));
            class_2499 originalEnchants = ModifierUtil.applyHarvestEnchantments(tool, stack, context);
            Iterable<class_2338> iterable = extraBlocks = context.isEffective() ? tool.getDefinition().getData().getAOE().getBlocks(tool, stack, player, state, (class_1937)world, pos, sideHit, IAreaOfEffectIterator.AOEMatchType.BREAKING) : Collections.emptyList();
            if (ToolHarvestLogic.breakBlock(tool, stack, context)) {
                for (class_2338 extraPos : extraBlocks) {
                    class_2680 extraState = world.method_8320(extraPos);
                    if (extraState.method_26215()) continue;
                    ToolHarvestLogic.breakExtraBlock(tool, stack, context.forPosition(extraPos.method_10062(), extraState));
                }
                for (ModifierEntry entry : tool.getModifierList()) {
                    entry.getModifier().finishBreakingBlocks(tool, entry.getLevel(), context);
                }
            }
            if (originalEnchants != null) {
                ModifierUtil.restoreEnchantments(stack, originalEnchants);
            }
        }
        return true;
    }
}

