/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1832;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5251;
import net.minecraft.class_746;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

public class TooltipBuilder {
    private static final class_5251 MAX = TooltipBuilder.valueToColor(1.0f, 1.0f);
    private static final UnaryOperator<class_2583> APPLY_MAX = style -> style.method_27703(MAX);
    private static final class_2561 TOOLTIP_BROKEN = TConstruct.makeTranslation("tooltip", "tool.broken").method_27695(new class_124[]{class_124.field_1067, class_124.field_1079});
    private static final class_2561 TOOLTIP_BROKEN_PREFIXED = ToolStats.DURABILITY.getPrefix().method_10852(TOOLTIP_BROKEN);
    private final IToolStackView tool;
    private final List<class_2561> tooltips;

    public TooltipBuilder(ToolStack tool) {
        this.tool = tool;
        this.tooltips = new ArrayList<class_2561>();
    }

    public TooltipBuilder add(class_2561 textComponent) {
        this.tooltips.add(textComponent);
        return this;
    }

    private <T> class_2561 formatValue(IToolStat<T> stat) {
        return stat.formatValue(this.tool.getStats().get(stat));
    }

    public TooltipBuilder add(IToolStat<?> stat) {
        this.tooltips.add(this.formatValue(stat));
        return this;
    }

    public TooltipBuilder addTier() {
        class_1832 tier = this.tool.getDefinition().getData().getHarvestLogic().getTier(this.tool);
        this.tooltips.add(ToolStats.HARVEST_TIER.formatValue(tier));
        return this;
    }

    public TooltipBuilder addOptional(INumericToolStat<?> stat) {
        return this.addOptional(stat, 1.0f);
    }

    public TooltipBuilder addOptional(INumericToolStat<?> stat, float scale) {
        float value = ((Number)this.tool.getStats().get(stat)).floatValue();
        if (value > 0.0f) {
            this.tooltips.add(stat.formatValue(value * scale));
        }
        return this;
    }

    public static class_2561 formatDurability(int durability, int ref, boolean textIfBroken) {
        if (textIfBroken && durability == 0) {
            return TOOLTIP_BROKEN_PREFIXED;
        }
        return ToolStats.DURABILITY.getPrefix().method_10852(TooltipBuilder.formatPartialAmount(durability, ref));
    }

    public static class_5251 valueToColor(float value, float max) {
        float hue = class_3532.method_15363((float)(value / max / 3.0f), (float)0.01f, (float)0.5f);
        return class_5251.method_27717((int)Color.HSBtoRGB(hue, 0.65f, 0.8f));
    }

    public static class_2561 formatPartialAmount(int value, int max) {
        return new class_2585(Util.COMMA_FORMAT.format(value)).method_27694(style -> style.method_27703(TooltipBuilder.valueToColor(value, max))).method_10852((class_2561)new class_2585(" / ").method_27692(class_124.field_1080)).method_10852((class_2561)new class_2585(Util.COMMA_FORMAT.format(max)).method_27694(APPLY_MAX));
    }

    public TooltipBuilder addDurability() {
        this.tooltips.add(TooltipBuilder.formatDurability(this.tool.getCurrentDurability(), this.tool.getStats().getInt(ToolStats.DURABILITY), false));
        return this;
    }

    public TooltipBuilder addWithAttribute(INumericToolStat<?> stat, class_1320 attribute) {
        class_1324 instance;
        float damage = (float)attribute.method_6169();
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && (instance = player.method_5996(attribute)) != null) {
            damage = (float)instance.method_6201();
        }
        this.tooltips.add(stat.formatValue(damage + ((Number)this.tool.getStats().get(stat)).floatValue()));
        return this;
    }

    public TooltipBuilder addFreeSlots(SlotType slotType) {
        int slots = this.tool.getFreeSlots(slotType);
        if (slots > 0) {
            this.tooltips.add(IToolStat.formatNumber(slotType.getPrefix(), slotType.getColor(), slots));
        }
        return this;
    }

    public TooltipBuilder addAllFreeSlots() {
        for (SlotType slotType : SlotType.getAllSlotTypes()) {
            this.addFreeSlots(slotType);
        }
        return this;
    }

    public TooltipBuilder addModifierInfo(boolean advanced) {
        for (ModifierEntry entry : this.tool.getModifierList()) {
            if (!entry.getModifier().shouldDisplay(advanced)) continue;
            this.tooltips.add(entry.getModifier().getDisplayName(this.tool, entry.getLevel()));
        }
        return this;
    }

    public TooltipBuilder(IToolStackView tool, List<class_2561> tooltips) {
        this.tool = tool;
        this.tooltips = tooltips;
    }

    public List<class_2561> getTooltips() {
        return this.tooltips;
    }
}

