/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.fabricators_of_create.porting_lib.enchant.CustomEnchantingBehaviorItem;
import io.github.fabricators_of_create.porting_lib.extensions.ItemExtensions;
import io.github.fabricators_of_create.porting_lib.item.CustomMaxCountItem;
import io.github.fabricators_of_create.porting_lib.item.ReequipAnimationItem;
import io.github.fabricators_of_create.porting_lib.item.UseFirstBehaviorItem;
import io.github.fabricators_of_create.porting_lib.util.DamageableItem;
import io.github.fabricators_of_create.porting_lib.util.ShieldBlockItem;
import io.github.fabricators_of_create.porting_lib.util.ToolAction;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerToolActions;

public class ModifiableItem
extends class_1792
implements IModifiableDisplay,
UseFirstBehaviorItem,
ItemExtensions,
DamageableItem,
ShieldBlockItem,
CustomMaxCountItem,
ReequipAnimationItem,
CustomEnchantingBehaviorItem {
    private final ToolDefinition toolDefinition;
    private class_1799 toolForRendering;

    public ModifiableItem(class_1792.class_1793 properties, ToolDefinition toolDefinition) {
        super(properties);
        this.toolDefinition = toolDefinition;
        ((FabricItemSettings)properties).customDamage(this::damageItem);
    }

    public int getItemStackLimit(class_1799 stack) {
        return 1;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public boolean isBookEnchantable(class_1799 stack, class_1799 book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(class_1799 stack, class_1887 enchantment) {
        return enchantment.method_8195() && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public void method_7860(class_2487 nbt) {
        ToolStack.verifyTag(this, nbt, this.getToolDefinition());
    }

    public void method_7843(class_1799 stack, class_1937 worldIn, class_1657 playerIn) {
        ToolStack.ensureInitialized(stack, this.getToolDefinition());
    }

    public boolean method_7886(class_1799 stack) {
        return ModifierUtil.checkVolatileFlag(stack, SHINY);
    }

    public class_1814 method_7862(class_1799 stack) {
        int rarity = ModifierUtil.getVolatileInt(stack, RARITY);
        return class_1814.values()[class_3532.method_15340((int)rarity, (int)0, (int)3)];
    }

    public boolean hasCustomEntity(class_1799 stack) {
        return IndestructibleItemEntity.hasCustomEntity(stack);
    }

    public class_1297 createEntity(class_1937 world, class_1297 original, class_1799 stack) {
        return IndestructibleItemEntity.createFrom(world, original, stack);
    }

    public boolean isRepairable(class_1799 stack) {
        return false;
    }

    public boolean method_7846() {
        return true;
    }

    public int getMaxDamage(class_1799 stack) {
        if (!this.method_7846()) {
            return 0;
        }
        ToolStack tool = ToolStack.from(stack);
        int durability = tool.getStats().getInt(ToolStats.DURABILITY);
        return tool.isBroken() ? durability + 1 : durability;
    }

    public int getDamage(class_1799 stack) {
        if (!this.method_7846()) {
            return 0;
        }
        return ToolStack.from(stack).getDamage();
    }

    public void setDamage(class_1799 stack, int damage) {
        if (this.method_7846()) {
            ToolStack.from(stack).setDamage(damage);
        }
    }

    public <T extends class_1309> int damageItem(class_1799 stack, int amount, T damager, Consumer<T> onBroken) {
        if (this.method_7846() && ToolDamageUtil.damage(ToolStack.from(stack), amount, damager, stack)) {
            onBroken.accept(damager);
        }
        return 0;
    }

    public boolean method_31567(class_1799 pStack) {
        return ToolDamageUtil.showDurabilityBar(pStack);
    }

    public int method_31571(class_1799 pStack) {
        return ToolDamageUtil.getRGBDurabilityForDisplay(pStack);
    }

    public int method_31569(class_1799 pStack) {
        return ToolDamageUtil.getDamageForDisplay(pStack);
    }

    public boolean onLeftClickEntity(class_1799 stack, class_1657 player, class_1297 entity) {
        return ToolAttackUtil.attackEntity(stack, player, entity);
    }

    @Override
    public Multimap<class_1320, class_1322> getAttributeModifiers(IToolStackView tool, class_1304 slot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (!tool.isBroken()) {
            if (slot == class_1304.field_6173) {
                StatsNBT statsNBT = tool.getStats();
                builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "tconstruct.tool.attack_damage", (double)statsNBT.get(ToolStats.ATTACK_DAMAGE).floatValue(), class_1322.class_1323.field_6328));
                builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "tconstruct.tool.attack_speed", (double)statsNBT.get(ToolStats.ATTACK_SPEED).floatValue() - 4.0, class_1322.class_1323.field_6328));
            }
            if (slot.method_5925() == class_1304.class_1305.field_6177) {
                BiConsumer<class_1320, class_1322> attributeConsumer = (arg_0, arg_1) -> ((ImmutableMultimap.Builder)builder).put(arg_0, arg_1);
                for (ModifierEntry entry : tool.getModifierList()) {
                    entry.getModifier().addAttributes(tool, entry.getLevel(), slot, attributeConsumer);
                }
            }
        }
        return builder.build();
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || slot.method_5925() != class_1304.class_1305.field_6177) {
            return ImmutableMultimap.of();
        }
        return this.getAttributeModifiers(ToolStack.from(stack), slot);
    }

    public boolean canDisableShield(class_1799 stack, class_1799 shield, class_1309 entity, class_1309 attacker) {
        return !ToolDamageUtil.isBroken(stack) && this.toolDefinition.getData().canPerformAction(TinkerToolActions.SHIELD_DISABLE);
    }

    public boolean isSuitableFor(class_1799 stack, class_2680 state) {
        return ToolHarvestLogic.isEffective(ToolStack.from(stack), state);
    }

    public boolean method_7879(class_1799 stack, class_1937 worldIn, class_2680 state, class_2338 pos, class_1309 entityLiving) {
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return false;
        }
        if (!worldIn.field_9236 && worldIn instanceof class_3218) {
            boolean isEffective = ToolHarvestLogic.isEffective(tool, state);
            ToolHarvestContext context = new ToolHarvestContext((class_3218)worldIn, entityLiving, state, pos, class_2350.field_11036, true, isEffective);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().afterBlockBreak(tool, entry.getLevel(), context);
            }
            ToolDamageUtil.damageAnimated(tool, ToolHarvestLogic.getDamage(tool, worldIn, pos, state), entityLiving);
        }
        return true;
    }

    public final float method_7865(class_1799 stack, class_2680 state) {
        return ToolHarvestLogic.getDestroySpeed(stack, state);
    }

    public boolean onBlockStartBreak(class_1799 stack, class_2338 pos, class_1657 player) {
        return ToolHarvestLogic.handleBlockBreak(stack, pos, player);
    }

    public void method_7888(class_1799 stack, class_1937 worldIn, class_1297 entityIn, int itemSlot, boolean isSelected) {
        super.method_7888(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn instanceof class_1309) {
            List<ModifierEntry> modifiers;
            ToolStack tool = ToolStack.from(stack);
            if (!worldIn.field_9236) {
                tool.ensureHasData();
            }
            if (!(modifiers = tool.getModifierList()).isEmpty()) {
                class_1309 living = (class_1309)entityIn;
                boolean isHeld = isSelected || living.method_6079() == stack;
                for (ModifierEntry entry : modifiers) {
                    entry.getModifier().onInventoryTick(tool, entry.getLevel(), worldIn, living, itemSlot, isSelected, isHeld, stack);
                }
            }
        }
    }

    protected static boolean shouldInteract(@Nullable class_1309 player, ToolStack toolStack, class_1268 hand) {
        IModDataView volatileData = toolStack.getVolatileData();
        if (volatileData.getBoolean(NO_INTERACTION)) {
            return false;
        }
        boolean deferOffhand = volatileData.getBoolean(DEFER_OFFHAND);
        if (hand == class_1268.field_5810) {
            return deferOffhand || !toolStack.hasTag(TinkerTags.Items.TWO_HANDED);
        }
        return player == null || !deferOffhand || player.method_6079().method_7960();
    }

    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        ToolStack tool = ToolStack.from(stack);
        class_1268 hand = context.method_20287();
        if (ModifiableItem.shouldInteract((class_1309)context.method_8036(), tool, hand)) {
            class_1304 slot = Util.getSlotType(hand);
            for (ModifierEntry entry : tool.getModifierList()) {
                class_1269 result = entry.getModifier().beforeBlockUse(tool, entry.getLevel(), context, slot);
                if (!result.method_23665()) continue;
                return result;
            }
        }
        return class_1269.field_5811;
    }

    public class_1269 method_7884(class_1838 context) {
        ToolStack tool = ToolStack.from(context.method_8041());
        class_1268 hand = context.method_20287();
        if (ModifiableItem.shouldInteract((class_1309)context.method_8036(), tool, hand)) {
            class_1304 slot = Util.getSlotType(hand);
            for (ModifierEntry entry : tool.getModifierList()) {
                class_1269 result = entry.getModifier().afterBlockUse(tool, entry.getLevel(), context, slot);
                if (!result.method_23665()) continue;
                return result;
            }
        }
        return class_1269.field_5811;
    }

    public class_1269 method_7847(class_1799 stack, class_1657 playerIn, class_1309 target, class_1268 hand) {
        ToolStack tool = ToolStack.from(stack);
        if (ModifiableItem.shouldInteract((class_1309)playerIn, tool, hand)) {
            class_1304 slot = Util.getSlotType(hand);
            for (ModifierEntry entry : tool.getModifierList()) {
                class_1269 result = entry.getModifier().afterEntityUse(tool, entry.getLevel(), playerIn, target, hand, slot);
                if (!result.method_23665()) continue;
                return result;
            }
        }
        return class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 hand) {
        class_1799 stack = playerIn.method_5998(hand);
        ToolStack tool = ToolStack.from(stack);
        if (ModifiableItem.shouldInteract((class_1309)playerIn, tool, hand)) {
            class_1304 slot = Util.getSlotType(hand);
            for (ModifierEntry entry : tool.getModifierList()) {
                class_1269 result = entry.getModifier().onToolUse(tool, entry.getLevel(), worldIn, playerIn, hand, slot);
                if (!result.method_23665()) continue;
                return new class_1271(result, (Object)stack);
            }
            if (hand == class_1268.field_5808 && stack.method_31573(TinkerTags.Items.TWO_HANDED) && !tool.getVolatileData().getBoolean(DEFER_OFFHAND)) {
                return class_1271.method_22428((Object)stack);
            }
        }
        class_1269 result = ToolInventoryCapability.tryOpenContainer(stack, tool, playerIn, Util.getSlotType(hand));
        return new class_1271(result, (Object)stack);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 worldIn, class_1309 entityLiving) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            if (!entry.getModifier().onFinishUsing(tool, entry.getLevel(), worldIn, entityLiving)) continue;
            return stack;
        }
        return stack;
    }

    public void method_7840(class_1799 stack, class_1937 worldIn, class_1309 entityLiving, int timeLeft) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            boolean result = entry.getModifier().onStoppedUsing(tool, entry.getLevel(), worldIn, entityLiving, timeLeft);
            if (!result) continue;
            return;
        }
    }

    public int method_7881(class_1799 stack) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            int result = entry.getModifier().getUseDuration(tool, entry.getLevel());
            if (result <= 0) continue;
            return result;
        }
        return 0;
    }

    public class_1839 method_7853(class_1799 stack) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            class_1839 result = entry.getModifier().getUseAction(tool, entry.getLevel());
            if (result == class_1839.field_8952) continue;
            return result;
        }
        return class_1839.field_8952;
    }

    public boolean canPerformAction(class_1799 stack, ToolAction toolAction) {
        return ModifierUtil.canPerformAction(ToolStack.from(stack), toolAction);
    }

    public class_2561 method_7864(class_1799 stack) {
        return TooltipUtil.getDisplayName(stack, this.getToolDefinition());
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        TooltipUtil.addInformation((IModifiableDisplay)this, stack, level, tooltip, SafeClientAccess.getTooltipKey(), flag);
    }

    public int getDefaultTooltipHideFlags(class_1799 stack) {
        return TooltipUtil.getModifierHideFlags(this.getToolDefinition());
    }

    public void method_7850(class_1761 group, class_2371<class_1799> items) {
        if (this.method_7877(group)) {
            ToolBuildHandler.addDefaultSubItems(this, items, new MaterialVariantId[0]);
        }
    }

    @Override
    public class_1799 getRenderTool() {
        if (this.toolForRendering == null) {
            this.toolForRendering = ToolBuildHandler.buildToolForRendering(this, this.getToolDefinition());
        }
        return this.toolForRendering;
    }

    public boolean allowContinuingBlockBreaking(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        return this.shouldCauseReequipAnimation(oldStack, newStack, false);
    }

    public boolean shouldCauseReequipAnimation(class_1799 oldStack, class_1799 newStack, boolean slotChanged) {
        if (oldStack == newStack) {
            return false;
        }
        if (slotChanged || oldStack.method_7909() != newStack.method_7909()) {
            return true;
        }
        ToolStack oldTool = ToolStack.from(oldStack);
        ToolStack newTool = ToolStack.from(newStack);
        if (!oldTool.getMaterials().equals(newTool.getMaterials())) {
            return true;
        }
        if (!oldTool.getModifierList().equals(newTool.getModifierList())) {
            return true;
        }
        Multimap attributesNew = newStack.method_7926(class_1304.field_6173);
        Multimap attributesOld = oldStack.method_7926(class_1304.field_6173);
        if (attributesNew.size() != attributesOld.size()) {
            return true;
        }
        for (class_1320 attribute : attributesOld.keySet()) {
            if (!attributesNew.containsKey((Object)attribute)) {
                return true;
            }
            Iterator iter1 = attributesNew.get((Object)attribute).iterator();
            Iterator iter2 = attributesOld.get((Object)attribute).iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                if (((class_1322)iter1.next()).equals(iter2.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static class_3965 blockRayTrace(class_1937 worldIn, class_1657 player, class_3959.class_242 fluidMode) {
        return class_1792.method_7872((class_1937)worldIn, (class_1657)player, (class_3959.class_242)fluidMode);
    }

    @Override
    public ToolDefinition getToolDefinition() {
        return this.toolDefinition;
    }
}

