/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.layout;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.crafting.CraftingHelper;
import io.netty.handler.codec.DecoderException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;

public abstract class LayoutIcon {
    public static final Serializer SERIALIZER = new Serializer();
    public static final LayoutIcon EMPTY = new LayoutIcon(){

        @Override
        @Nullable
        public <T> T getValue(Class<T> clazz) {
            return null;
        }

        @Override
        public void write(class_2540 buffer) {
            buffer.method_10817((Enum)Type.EMPTY);
        }

        @Override
        public JsonObject toJson() {
            return new JsonObject();
        }
    };

    public static LayoutIcon ofItem(class_1799 stack) {
        return new ItemStackIcon(stack);
    }

    public static LayoutIcon ofPattern(Pattern pattern) {
        return new PatternIcon(pattern);
    }

    @Nullable
    public abstract <T> T getValue(Class<T> var1);

    public static LayoutIcon read(class_2540 buffer) {
        Type type = (Type)buffer.method_10818(Type.class);
        switch (type) {
            case EMPTY: {
                return EMPTY;
            }
            case ITEM: {
                class_1799 stack = buffer.method_10819();
                return new ItemStackIcon(stack);
            }
            case PATTERN: {
                Pattern pattern = new Pattern(buffer.method_10810());
                return new PatternIcon(pattern);
            }
        }
        throw new DecoderException("Invalid LayoutButtonIcon " + type);
    }

    public abstract void write(class_2540 var1);

    public abstract JsonObject toJson();

    @VisibleForTesting
    protected static class ItemStackIcon
    extends LayoutIcon {
        private final class_1799 stack;

        @Override
        public <T> T getValue(Class<T> clazz) {
            if (clazz == class_1799.class) {
                return (T)this.stack;
            }
            return null;
        }

        @Override
        public void write(class_2540 buffer) {
            buffer.method_10817((Enum)Type.ITEM);
            buffer.method_10793(this.stack);
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("item", Objects.requireNonNull(class_2378.field_11142.method_10221((Object)this.stack.method_7909())).toString());
            class_2487 tag = this.stack.method_7969();
            if (tag != null) {
                json.addProperty("nbt", tag.toString());
            }
            return json;
        }

        public ItemStackIcon(class_1799 stack) {
            this.stack = stack;
        }
    }

    @VisibleForTesting
    protected static class PatternIcon
    extends LayoutIcon {
        private final Pattern pattern;

        @Override
        public <T> T getValue(Class<T> clazz) {
            if (clazz == Pattern.class) {
                return (T)((Object)this.pattern);
            }
            return null;
        }

        @Override
        public void write(class_2540 buffer) {
            buffer.method_10817((Enum)Type.PATTERN);
            buffer.method_10812((class_2960)this.pattern);
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("pattern", this.pattern.toString());
            return json;
        }

        public PatternIcon(Pattern pattern) {
            this.pattern = pattern;
        }
    }

    private static enum Type {
        EMPTY,
        ITEM,
        PATTERN;

    }

    protected static class Serializer
    implements JsonSerializer<LayoutIcon>,
    JsonDeserializer<LayoutIcon> {
        protected Serializer() {
        }

        public LayoutIcon deserialize(JsonElement json, java.lang.reflect.Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = class_3518.method_15295((JsonElement)json, (String)"button_icon");
            if (object.has("pattern")) {
                Pattern pattern = new Pattern(JsonHelper.getResourceLocation((JsonObject)object, (String)"pattern"));
                return new PatternIcon(pattern);
            }
            if (object.has("item")) {
                class_1799 stack = CraftingHelper.getItemStack((JsonObject)object, (boolean)true);
                return new ItemStackIcon(stack);
            }
            if (object.entrySet().isEmpty()) {
                return EMPTY;
            }
            throw new JsonSyntaxException("LayoutButtonIcon must have either pattern or item");
        }

        public JsonElement serialize(LayoutIcon icon, java.lang.reflect.Type typeOfSrc, JsonSerializationContext context) {
            return icon.toJson();
        }
    }
}

