/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.layout;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.layout.LayoutIcon;
import slimeknights.tconstruct.library.tools.layout.LayoutSlot;

public class StationSlotLayout {
    private static final class_2960 EMPTY_NAME = TConstruct.getResource("empty");
    public static final StationSlotLayout EMPTY = new StationSlotLayout("", LayoutIcon.EMPTY, null, LayoutSlot.EMPTY, Collections.emptyList());
    private transient class_2960 name = EMPTY_NAME;
    private final String translation_key;
    private final LayoutIcon icon;
    @Nullable
    private final Integer sortIndex;
    private final LayoutSlot tool_slot;
    private final List<LayoutSlot> input_slots;
    private transient class_2561 displayName = null;
    private transient class_2561 description = null;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isMain() {
        return this.sortIndex == null;
    }

    public int getSortIndex() {
        return Objects.requireNonNullElse(this.sortIndex, 255);
    }

    public LayoutIcon getIcon() {
        return Objects.requireNonNullElse(this.icon, LayoutIcon.EMPTY);
    }

    public LayoutSlot getToolSlot() {
        return Objects.requireNonNullElse(this.tool_slot, LayoutSlot.EMPTY);
    }

    public List<LayoutSlot> getInputSlots() {
        return Objects.requireNonNullElse(this.input_slots, Collections.emptyList());
    }

    public int getInputCount() {
        return this.getInputSlots().size();
    }

    public LayoutSlot getSlot(int index) {
        if (index == 0) {
            return this.getToolSlot();
        }
        List<LayoutSlot> inputs = this.getInputSlots();
        if (index < 0 || index > inputs.size()) {
            return LayoutSlot.EMPTY;
        }
        return inputs.get(index - 1);
    }

    public static StationSlotLayout read(class_2540 buffer) {
        class_2960 name = buffer.method_10810();
        String translationKey = buffer.method_10800(Short.MAX_VALUE);
        LayoutIcon icon = LayoutIcon.read(buffer);
        Integer sortIndex = null;
        if (buffer.readBoolean()) {
            sortIndex = buffer.method_10816();
        }
        LayoutSlot toolSlot = LayoutSlot.read(buffer);
        int max = buffer.method_10816();
        ImmutableList.Builder inputs = ImmutableList.builder();
        for (int i = 0; i < max; ++i) {
            inputs.add((Object)LayoutSlot.read(buffer));
        }
        StationSlotLayout layout = new StationSlotLayout(translationKey, icon, sortIndex, toolSlot, (List<LayoutSlot>)inputs.build());
        layout.setName(name);
        return layout;
    }

    public void write(class_2540 buffer) {
        buffer.method_10812(this.name);
        buffer.method_10814(this.getTranslationKey());
        this.icon.write(buffer);
        if (this.sortIndex != null) {
            buffer.writeBoolean(true);
            buffer.method_10804(this.sortIndex.intValue());
        } else {
            buffer.writeBoolean(false);
        }
        this.getToolSlot().write(buffer);
        List<LayoutSlot> inputs = this.getInputSlots();
        buffer.method_10804(inputs.size());
        for (LayoutSlot slot : inputs) {
            slot.write(buffer);
        }
    }

    public String getTranslationKey() {
        return Objects.requireNonNullElse(this.translation_key, "");
    }

    public class_2561 getDisplayName() {
        if (this.displayName == null) {
            this.displayName = new class_2588(this.getTranslationKey());
        }
        return this.displayName;
    }

    public class_2561 getDescription() {
        if (this.description == null) {
            this.description = new class_2588(this.getTranslationKey() + ".description");
        }
        return this.description;
    }

    protected StationSlotLayout(String translation_key, LayoutIcon icon, @Nullable Integer sortIndex, LayoutSlot tool_slot, List<LayoutSlot> input_slots) {
        this.translation_key = translation_key;
        this.icon = icon;
        this.sortIndex = sortIndex;
        this.tool_slot = tool_slot;
        this.input_slots = input_slots;
    }

    public class_2960 getName() {
        return this.name;
    }

    protected void setName(class_2960 name) {
        this.name = name;
    }

    public static class Builder {
        private static final Pattern PICKAXE = new Pattern("tconstruct", "pickaxe");
        private String translationKey = null;
        private LayoutIcon icon = LayoutIcon.EMPTY;
        private Integer sortIndex = null;
        private LayoutSlot toolSlot = null;
        private final ImmutableList.Builder<LayoutSlot> inputSlots = ImmutableList.builder();

        private Builder() {
        }

        public Builder sortIndex(int index) {
            this.sortIndex = index;
            return this;
        }

        public Builder item(class_1799 stack) {
            this.icon(stack);
            this.translationKey = stack.method_7922();
            return this;
        }

        public Builder icon(class_1799 stack) {
            this.icon = LayoutIcon.ofItem(stack);
            return this;
        }

        public Builder icon(Pattern pattern) {
            this.icon = LayoutIcon.ofPattern(pattern);
            return this;
        }

        public Builder toolSlot(Pattern icon, @Nullable String name, int x, int y, @Nullable class_1856 filter) {
            this.toolSlot = new LayoutSlot(icon, name, x, y, filter);
            return this;
        }

        public Builder toolSlot(int x, int y, @Nullable class_1856 filter) {
            return this.toolSlot(PICKAXE, null, x, y, filter);
        }

        public Builder toolSlot(int x, int y) {
            return this.toolSlot(x, y, null);
        }

        public Builder addInputSlot(@Nullable Pattern icon, @Nullable String name, int x, int y, @Nullable class_1856 filter) {
            this.inputSlots.add((Object)new LayoutSlot(icon, name, x, y, filter));
            return this;
        }

        public Builder addInputSlot(@Nullable Pattern icon, @Nullable String name, int x, int y) {
            return this.addInputSlot(icon, name, x, y, null);
        }

        public Builder addInputSlot(@Nullable Pattern icon, int x, int y) {
            return this.addInputSlot(icon, null, x, y);
        }

        public Builder addInputItem(Pattern icon, class_1935 item, int x, int y) {
            return this.addInputSlot(icon, item.method_8389().method_7876(), x, y, class_1856.method_8091((class_1935[])new class_1935[]{item}));
        }

        public Builder addInputItem(class_1935 item, int x, int y) {
            return this.addInputItem(new Pattern(Objects.requireNonNull(class_2378.field_11142.method_10221((Object)item.method_8389()))), item, x, y);
        }

        public StationSlotLayout build() {
            return new StationSlotLayout(this.translationKey, this.icon, this.sortIndex, this.toolSlot, (List<LayoutSlot>)this.inputSlots.build());
        }

        public Builder translationKey(String translationKey) {
            this.translationKey = translationKey;
            return this;
        }
    }
}

