/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;

public class ModifierNBT {
    public static final String TAG_MODIFIER = "name";
    public static final String TAG_LEVEL = "level";
    static final ModifierNBT EMPTY = new ModifierNBT(Collections.emptyList());
    private final List<ModifierEntry> modifiers;

    public boolean isEmpty() {
        return this.modifiers.isEmpty();
    }

    public int getLevel(ModifierId modifier) {
        for (ModifierEntry entry : this.modifiers) {
            if (!entry.matches(modifier)) continue;
            return entry.getLevel();
        }
        return 0;
    }

    public ModifierNBT withModifier(ModifierId modifier, int level) {
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level, must be above zero");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean found = false;
        for (ModifierEntry entry : this.modifiers) {
            if (!found && entry.matches(modifier)) {
                builder.add((Object)entry.withLevel(entry.getLevel() + level));
                found = true;
                continue;
            }
            builder.add((Object)entry);
        }
        if (!found) {
            builder.add((Object)new ModifierEntry(modifier, level));
        }
        return new ModifierNBT((List<ModifierEntry>)builder.build());
    }

    public ModifierNBT withoutModifier(ModifierId modifier, int level) {
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level, must be above zero");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ModifierEntry entry : this.modifiers) {
            if (entry.matches(modifier) && level > 0) {
                if (entry.getLevel() > level) {
                    builder.add((Object)entry.withLevel(entry.getLevel() - level));
                    level = 0;
                    continue;
                }
                level -= entry.getLevel();
                continue;
            }
            builder.add((Object)entry);
        }
        return new ModifierNBT((List<ModifierEntry>)builder.build());
    }

    public static ModifierNBT readFromNBT(@Nullable class_2520 inbt) {
        if (inbt == null || inbt.method_10711() != 9) {
            return EMPTY;
        }
        class_2499 listNBT = (class_2499)inbt;
        if (listNBT.method_10601() != 10) {
            return EMPTY;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < listNBT.size(); ++i) {
            class_2487 tag = listNBT.method_10602(i);
            if (!tag.method_10545(TAG_MODIFIER) || !tag.method_10545(TAG_LEVEL)) continue;
            ModifierId id = ModifierId.tryParse(tag.method_10558(TAG_MODIFIER));
            int level = tag.method_10550(TAG_LEVEL);
            if (id == null || level <= 0) continue;
            builder.add((Object)new ModifierEntry(id, level));
        }
        return new ModifierNBT((List<ModifierEntry>)builder.build());
    }

    public class_2499 serializeToNBT() {
        class_2499 list = new class_2499();
        for (ModifierEntry entry : this.modifiers) {
            class_2487 tag = new class_2487();
            tag.method_10582(TAG_MODIFIER, entry.getId().toString());
            tag.method_10575(TAG_LEVEL, (short)entry.getLevel());
            list.add((Object)tag);
        }
        return list;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifierNBT)) {
            return false;
        }
        ModifierNBT other = (ModifierNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ModifierEntry> this$modifiers = this.getModifiers();
        List<ModifierEntry> other$modifiers = other.getModifiers();
        return !(this$modifiers == null ? other$modifiers != null : !((Object)this$modifiers).equals(other$modifiers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModifierNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ModifierEntry> $modifiers = this.getModifiers();
        result = result * 59 + ($modifiers == null ? 43 : ((Object)$modifiers).hashCode());
        return result;
    }

    protected ModifierNBT(List<ModifierEntry> modifiers) {
        this.modifiers = modifiers;
    }

    public List<ModifierEntry> getModifiers() {
        return this.modifiers;
    }

    public static class Builder {
        private final Map<Modifier, Integer> modifiers = new LinkedHashMap<Modifier, Integer>();

        public Builder add(Modifier modifier, int level) {
            if (level <= 0) {
                throw new IllegalArgumentException("Level must be above 0");
            }
            if (modifier != ModifierManager.INSTANCE.getDefaultValue()) {
                Integer value = this.modifiers.get(modifier);
                if (value != null) {
                    level += value.intValue();
                }
                this.modifiers.put(modifier, level);
            }
            return this;
        }

        public Builder add(ModifierEntry entry) {
            this.add(entry.getModifier(), entry.getLevel());
            return this;
        }

        public Builder add(List<ModifierEntry> entries) {
            for (ModifierEntry entry : entries) {
                this.add(entry);
            }
            return this;
        }

        public Builder add(ModifierNBT nbt) {
            this.add(nbt.getModifiers());
            return this;
        }

        public ModifierNBT build() {
            List list = this.modifiers.entrySet().stream().map(entry -> new ModifierEntry((Modifier)entry.getKey(), (int)((Integer)entry.getValue()))).sorted().collect(Collectors.toList());
            return new ModifierNBT((List<ModifierEntry>)ImmutableList.copyOf(list));
        }

        private Builder() {
        }
    }
}

