/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.MultiplierNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;

public class ToolStack
implements IToolStackView {
    private static final String KEY_VALIDATE_SLOTS = TConstruct.makeTranslationKey("recipe", "modifier.validate_slots");
    public static final class_2960 NEEDS_SLOTS_BUILT = TConstruct.getResource("needs_slots_built");
    public static final String TAG_MATERIALS = "tic_materials";
    public static final String TAG_PERSISTENT_MOD_DATA = "tic_persistent_data";
    public static final String TAG_UPGRADES = "tic_upgrades";
    public static final String TAG_BROKEN = "tic_broken";
    protected static final String TAG_STATS = "tic_stats";
    protected static final String TAG_MULTIPLIERS = "tic_multipliers";
    public static final String TAG_VOLATILE_MOD_DATA = "tic_volatile_data";
    public static final String TAG_MODIFIERS = "tic_modifiers";
    protected static final String TAG_DAMAGE = "Damage";
    public static final String TAG_UNBREAKABLE = "Unbreakable";
    public static final String TAG_HIDE_FLAGS = "HideFlags";
    private static final Set<String> RESTRICTED_TAGS = ImmutableSet.of((Object)"tic_materials", (Object)"tic_stats", (Object)"tic_multipliers", (Object)"tic_persistent_data", (Object)"tic_volatile_data", (Object)"tic_upgrades", (Object[])new String[]{"tic_modifiers", "tic_broken", "Damage", "Enchantments", "HideFlags"});
    private final class_1792 item;
    private final ToolDefinition definition;
    private final class_2487 nbt;
    private RestrictedCompoundTag restrictedNBT;
    private int damage = -1;
    @Nullable
    private Boolean broken;
    @Nullable
    private MaterialNBT materials;
    @Nullable
    private ModifierNBT upgrades;
    @Nullable
    private ModDataNBT persistentModData;
    @Nullable
    private ModifierNBT modifiers;
    @Nullable
    private StatsNBT stats;
    @Nullable
    private MultiplierNBT multipliers;
    @Nullable
    private IModDataView volatileModData;

    private static ToolStack from(class_1799 stack, boolean copyNbt) {
        class_1792 item = stack.method_7909();
        ToolDefinition definition = item instanceof IModifiable ? ((IModifiable)item).getToolDefinition() : ToolDefinition.EMPTY;
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            nbt = new class_2487();
            if (!copyNbt) {
                stack.field_8040 = nbt;
            }
        } else if (copyNbt) {
            nbt = nbt.method_10553();
        }
        return ToolStack.from(item, definition, nbt);
    }

    public static ToolStack from(class_1799 stack) {
        return ToolStack.from(stack, false);
    }

    public static ToolStack copyFrom(class_1799 stack) {
        return ToolStack.from(stack, true);
    }

    public static ToolStack createTool(class_1792 item, ToolDefinition definition, MaterialNBT materials) {
        ToolStack tool = ToolStack.from(item, definition, new class_2487());
        tool.damage = 0;
        tool.broken = false;
        tool.upgrades = ModifierNBT.EMPTY;
        definition.getData().buildSlots(tool.getPersistentData());
        tool.setMaterials(materials);
        return tool;
    }

    public ToolStack copy() {
        ToolStack tool = ToolStack.from(this.item, this.definition, this.nbt.method_10553());
        tool.damage = this.damage;
        tool.broken = this.broken;
        tool.materials = this.materials;
        tool.upgrades = this.upgrades;
        tool.modifiers = this.modifiers;
        tool.stats = this.stats;
        return tool;
    }

    public void clearCache() {
        this.damage = -1;
        this.broken = null;
        this.materials = null;
        this.upgrades = null;
        this.modifiers = null;
        this.stats = null;
        this.multipliers = null;
        this.volatileModData = null;
        this.persistentModData = null;
    }

    public class_1799 createStack(int size) {
        class_1799 stack = new class_1799((class_1935)this.item, size);
        stack.method_7980(this.nbt);
        return stack;
    }

    public class_1799 createStack() {
        return this.createStack(1);
    }

    public class_1799 updateStack(class_1799 stack) {
        if (stack.method_7909() != this.item) {
            throw new IllegalArgumentException("Wrong item in stack");
        }
        stack.method_7980(this.nbt.method_10553());
        return stack;
    }

    public RestrictedCompoundTag getRestrictedNBT() {
        if (this.restrictedNBT == null) {
            this.restrictedNBT = new RestrictedCompoundTag(this.nbt, RESTRICTED_TAGS);
        }
        return this.restrictedNBT;
    }

    @Override
    public boolean isBroken() {
        if (this.broken == null) {
            this.broken = this.nbt.method_10577(TAG_BROKEN);
        }
        return this.broken;
    }

    @Override
    public boolean isUnbreakable() {
        return this.nbt.method_10577(TAG_UNBREAKABLE);
    }

    protected void setBrokenRaw(boolean broken) {
        this.broken = broken;
        this.nbt.method_10556(TAG_BROKEN, broken);
    }

    protected void breakTool() {
        this.setDamage(this.getStats().getInt(ToolStats.DURABILITY));
    }

    protected int getDamageRaw() {
        if (this.damage == -1) {
            this.damage = this.nbt.method_10550(TAG_DAMAGE);
        }
        return this.damage;
    }

    @Override
    public int getDamage() {
        int durability = this.getStats().getInt(ToolStats.DURABILITY);
        if (this.isBroken()) {
            return durability;
        }
        return Math.min(this.getDamageRaw(), durability - 1);
    }

    @Override
    public int getCurrentDurability() {
        if (this.isBroken()) {
            return 0;
        }
        return Math.max(0, this.getStats().getInt(ToolStats.DURABILITY) - this.getDamageRaw());
    }

    @Override
    public void setDamage(int damage) {
        int durability = this.getStats().getInt(ToolStats.DURABILITY);
        if (damage >= durability) {
            damage = Math.max(0, durability);
            this.setBrokenRaw(true);
        } else {
            this.setBrokenRaw(false);
        }
        this.damage = damage;
        this.nbt.method_10569(TAG_DAMAGE, damage);
    }

    @Override
    public StatsNBT getStats() {
        if (this.stats == null) {
            this.stats = StatsNBT.readFromNBT(this.nbt.method_10580(TAG_STATS));
        }
        return this.stats;
    }

    protected void setStats(StatsNBT stats) {
        this.stats = stats;
        this.nbt.method_10566(TAG_STATS, (class_2520)stats.serializeToNBT());
        int newMax = this.getStats().getInt(ToolStats.DURABILITY);
        if (this.getDamageRaw() >= newMax) {
            this.setDamage(newMax);
        }
    }

    protected MultiplierNBT getMultipliers() {
        if (this.multipliers == null) {
            this.multipliers = MultiplierNBT.readFromNBT(this.nbt.method_10580(TAG_MULTIPLIERS));
        }
        return this.multipliers;
    }

    protected void setMultipliers(MultiplierNBT multipliers) {
        this.multipliers = multipliers;
        this.nbt.method_10566(TAG_MULTIPLIERS, (class_2520)multipliers.serializeToNBT());
    }

    @Override
    public float getMultiplier(INumericToolStat<?> stat) {
        MultiplierNBT multipliers = this.getMultipliers();
        if (multipliers.hasStat(stat)) {
            return multipliers.get(stat);
        }
        return 1.0f;
    }

    @Override
    public MaterialNBT getMaterials() {
        if (!this.getDefinition().isMultipart()) {
            return MaterialNBT.EMPTY;
        }
        if (this.materials == null) {
            this.materials = MaterialNBT.readFromNBT(this.nbt.method_10580(TAG_MATERIALS));
        }
        return this.materials;
    }

    protected void setMaterialsRaw(MaterialNBT materials) {
        this.materials = materials;
        if (materials == MaterialNBT.EMPTY) {
            this.nbt.method_10551(TAG_MATERIALS);
        } else {
            this.nbt.method_10566(TAG_MATERIALS, (class_2520)materials.serializeToNBT());
        }
    }

    public void setMaterials(MaterialNBT materials) {
        this.setMaterialsRaw(materials);
        this.rebuildStats();
    }

    public void replaceMaterial(int index, MaterialVariantId replacement) {
        this.setMaterials(this.getMaterials().replaceMaterial(index, replacement));
    }

    @Override
    public ModifierNBT getUpgrades() {
        if (this.upgrades == null) {
            this.upgrades = ModifierNBT.readFromNBT(this.nbt.method_10580(TAG_UPGRADES));
        }
        return this.upgrades;
    }

    public void setUpgrades(ModifierNBT modifiers) {
        this.upgrades = modifiers;
        this.nbt.method_10566(TAG_UPGRADES, (class_2520)modifiers.serializeToNBT());
        this.rebuildStats();
    }

    public void addModifier(ModifierId modifier, int level) {
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level, must be above 0");
        }
        this.setUpgrades(this.getUpgrades().withModifier(modifier, level));
    }

    public void removeModifier(ModifierId modifier, int level) {
        ModifierNBT newModifiers;
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level, must be above 0");
        }
        this.upgrades = newModifiers = this.getUpgrades().withoutModifier(modifier, level);
        this.nbt.method_10566(TAG_UPGRADES, (class_2520)newModifiers.serializeToNBT());
        this.rebuildStats();
    }

    @Override
    public ModifierNBT getModifiers() {
        if (this.modifiers == null) {
            this.modifiers = ModifierNBT.readFromNBT(this.nbt.method_10580(TAG_MODIFIERS));
        }
        return this.modifiers;
    }

    protected void setModifiers(ModifierNBT modifiers) {
        this.modifiers = modifiers;
        this.nbt.method_10566(TAG_MODIFIERS, (class_2520)this.modifiers.serializeToNBT());
    }

    @Override
    public ModDataNBT getPersistentData() {
        if (this.persistentModData == null) {
            if (this.nbt.method_10573(TAG_PERSISTENT_MOD_DATA, 10)) {
                this.persistentModData = ModDataNBT.readFromNBT(this.nbt.method_10562(TAG_PERSISTENT_MOD_DATA));
            } else {
                class_2487 tag = new class_2487();
                this.nbt.method_10566(TAG_PERSISTENT_MOD_DATA, (class_2520)tag);
                this.persistentModData = ModDataNBT.readFromNBT(tag);
            }
        }
        return this.persistentModData;
    }

    @Override
    public IModDataView getVolatileData() {
        if (this.volatileModData == null) {
            this.volatileModData = this.nbt.method_10573(TAG_VOLATILE_MOD_DATA, 10) ? ModDataNBT.readFromNBT(this.nbt.method_10562(TAG_VOLATILE_MOD_DATA)) : IModDataView.EMPTY;
        }
        return this.volatileModData;
    }

    protected void setVolatileModData(ModDataNBT modData) {
        class_2487 data = modData.getData();
        if (data.method_33133()) {
            this.volatileModData = IModDataView.EMPTY;
            this.nbt.method_10551(TAG_VOLATILE_MOD_DATA);
        } else {
            this.volatileModData = modData;
            this.nbt.method_10566(TAG_VOLATILE_MOD_DATA, (class_2520)data);
        }
    }

    public ValidatedResult validate() {
        for (SlotType slotType : SlotType.getAllSlotTypes()) {
            if (this.getFreeSlots(slotType) >= 0) continue;
            return ValidatedResult.failure(KEY_VALIDATE_SLOTS, slotType.getDisplayName());
        }
        for (ModifierEntry entry : this.getModifierList()) {
            ValidatedResult result = entry.getModifier().validate(this, entry.getLevel());
            if (!result.hasError()) continue;
            return result;
        }
        return ValidatedResult.PASS;
    }

    public void ensureSlotsBuilt() {
        if (!this.nbt.method_10573(TAG_PERSISTENT_MOD_DATA, 10) || this.getPersistentData().getBoolean(NEEDS_SLOTS_BUILT)) {
            ModDataNBT persistentData = this.getPersistentData();
            persistentData.remove(NEEDS_SLOTS_BUILT);
            this.definition.getData().buildSlots(persistentData);
        }
    }

    public void ensureHasData() {
        if (!this.definition.isDataLoaded()) {
            return;
        }
        this.ensureSlotsBuilt();
        if (ToolStack.isInitialized(this.nbt)) {
            return;
        }
        if (this.definition.isMultipart() && !this.nbt.method_10573(TAG_MATERIALS, 9)) {
            this.setMaterialsRaw(ToolBuildHandler.randomMaterials(this.definition.getData(), this.definition.getDefaultMaxTier(), false));
        }
        this.rebuildStats();
    }

    public void rebuildStats() {
        this.nbt.method_10551(TAG_HIDE_FLAGS);
        ModifierNBT.Builder modBuilder = ModifierNBT.builder();
        modBuilder.add(this.getUpgrades());
        modBuilder.add(this.getDefinition().getData().getTraits());
        List<PartRequirement> parts = this.getDefinition().getData().getParts();
        MaterialNBT materials = this.getMaterials();
        int max = Math.min(materials.size(), parts.size());
        for (int i = 0; i < max; ++i) {
            modBuilder.add(MaterialRegistry.getInstance().getTraits(materials.get(i).getId(), parts.get(i).getStatType()));
        }
        ModifierNBT allMods = modBuilder.build();
        this.setModifiers(allMods);
        StatsNBT stats = this.definition.buildStats(materials);
        ModifierStatsBuilder statBuilder = ModifierStatsBuilder.builder();
        this.definition.getData().buildStatMultipliers(statBuilder);
        List<ModifierEntry> modifierList = allMods.getModifiers();
        if (modifierList.isEmpty()) {
            this.nbt.method_10551(TAG_VOLATILE_MOD_DATA);
            this.volatileModData = IModDataView.EMPTY;
        } else {
            ModDataNBT volatileData = new ModDataNBT();
            ToolRebuildContext context = new ToolRebuildContext(this.item, this.getDefinition(), this.getMaterials(), this.getUpgrades(), allMods, stats, this.getPersistentData(), volatileData);
            for (ModifierEntry entry : modifierList) {
                entry.getModifier().addVolatileData(context, entry.getLevel(), volatileData);
            }
            for (ModifierEntry entry : modifierList) {
                entry.getModifier().addToolStats(context, entry.getLevel(), statBuilder);
            }
            this.setVolatileModData(volatileData);
        }
        this.setStats(statBuilder.build(stats, this.item));
        this.setMultipliers(statBuilder.buildMultipliers(this.item));
        for (ModifierEntry entry : modifierList) {
            entry.getModifier().addRawData(this, entry.getLevel(), this.getRestrictedNBT());
        }
    }

    public static boolean isInitialized(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && ToolStack.isInitialized(tag);
    }

    public static boolean isInitialized(class_2487 tag) {
        return tag.method_10573(TAG_STATS, 10);
    }

    public static boolean hasMaterials(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10573(TAG_MATERIALS, 9);
    }

    public static void ensureInitialized(class_1799 stack) {
        if (stack.method_7909() instanceof IModifiable) {
            ToolStack.ensureInitialized(stack, ((IModifiable)stack.method_7909()).getToolDefinition());
        }
    }

    public static void ensureInitialized(class_1799 stack, ToolDefinition toolDefinition) {
        if (!toolDefinition.isDataLoaded()) {
            return;
        }
        class_2487 tag = stack.method_7969();
        if (tag != null && ToolStack.isInitialized(tag)) {
            return;
        }
        ToolStack.from(stack).ensureHasData();
    }

    public static void verifyTag(class_1792 item, class_2487 tag, ToolDefinition definition) {
        MaterialIdNBT stored;
        MaterialIdNBT resolved;
        if (!definition.isDataLoaded() || tag.method_10577("tic_display")) {
            return;
        }
        boolean hasMaterials = tag.method_10573(TAG_MATERIALS, 9);
        if (hasMaterials && (resolved = (stored = MaterialIdNBT.readFromNBT((class_2520)tag.method_10554(TAG_MATERIALS, 8))).resolveRedirects()) != stored) {
            resolved.updateNBT(tag);
        }
        ToolStack tool = ToolStack.from(item, definition, tag);
        tool.ensureSlotsBuilt();
        if (hasMaterials || !definition.isMultipart()) {
            tool.rebuildStats();
        }
    }

    private ToolStack(class_1792 item, ToolDefinition definition, class_2487 nbt) {
        this.item = item;
        this.definition = definition;
        this.nbt = nbt;
    }

    public static ToolStack from(class_1792 item, ToolDefinition definition, class_2487 nbt) {
        return new ToolStack(item, definition, nbt);
    }

    @Override
    public class_1792 getItem() {
        return this.item;
    }

    @Override
    public ToolDefinition getDefinition() {
        return this.definition;
    }

    protected class_2487 getNbt() {
        return this.nbt;
    }
}

