/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.part;

import io.github.fabricators_of_create.porting_lib.extensions.ItemExtensions;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.utils.DomainDisplayName;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialItem
extends class_1792
implements IMaterialItem,
ItemExtensions {
    private static final String ADDED_BY = TConstruct.makeTranslationKey("tooltip", "part.added_by");

    public MaterialItem(class_1792.class_1793 properties) {
        super(properties);
    }

    private static MaterialVariantId getMaterialId(@Nullable class_2487 nbt) {
        MaterialVariantId id;
        String str;
        if (nbt != null && !(str = nbt.method_10558("Material")).isEmpty() && (id = MaterialVariantId.tryParse(str)) != null) {
            return id;
        }
        return IMaterial.UNKNOWN_ID;
    }

    @Override
    public MaterialVariantId getMaterial(class_1799 stack) {
        return MaterialItem.getMaterialId(stack.method_7969());
    }

    public void method_7850(class_1761 group, class_2371<class_1799> items) {
        if (this.method_7877(group) && MaterialRegistry.isFullyLoaded()) {
            MaterialVariantId materialId;
            String showOnlyId = (String)Config.COMMON.showOnlyPartMaterial.get();
            boolean added = false;
            if (!showOnlyId.isEmpty() && (materialId = MaterialVariantId.tryParse(showOnlyId)) != null && this.canUseMaterial(materialId.getId())) {
                items.add((Object)this.withMaterialForDisplay(materialId));
                added = true;
            }
            if (!added) {
                for (IMaterial material : MaterialRegistry.getInstance().getVisibleMaterials()) {
                    MaterialId id = material.getIdentifier();
                    if (!this.canUseMaterial(id)) continue;
                    items.add((Object)this.withMaterial(id));
                    if (showOnlyId.isEmpty()) continue;
                    break;
                }
            }
        }
    }

    @Nullable
    private static class_2561 getName(String baseKey, MaterialVariantId material) {
        class_2960 location = material.getLocation('.');
        String fullKey = String.format("%s.%s.%s", baseKey, location.method_12836(), location.method_12832());
        if (Util.canTranslate(fullKey)) {
            return new class_2588(fullKey);
        }
        String materialKey = MaterialTooltipCache.getKey(material);
        String materialPrefix = materialKey + ".format";
        if (Util.canTranslate(materialPrefix)) {
            return new class_2588(materialPrefix, new Object[]{new class_2588(baseKey)});
        }
        if (Util.canTranslate(materialKey)) {
            return new class_2588(materialKey).method_27693(" ").method_10852((class_2561)new class_2588(baseKey));
        }
        return null;
    }

    public class_2561 method_7864(class_1799 stack) {
        class_2561 component;
        MaterialVariantId material = this.getMaterial(stack);
        if (material.equals(IMaterial.UNKNOWN_ID)) {
            return super.method_7864(stack);
        }
        String key = this.method_7866(stack);
        if (material.hasVariant() && (component = MaterialItem.getName(key, material)) != null) {
            return component;
        }
        component = MaterialItem.getName(key, material.getId());
        if (component != null) {
            return component;
        }
        return new class_2588(key);
    }

    @Nullable
    public String getCreatorModId(class_1799 stack) {
        MaterialVariantId material = this.getMaterial(stack);
        if (!IMaterial.UNKNOWN_ID.equals(material)) {
            return material.getId().method_12836();
        }
        class_2960 id = this.getRegistryName();
        return id == null ? null : id.method_12836();
    }

    protected static void addModTooltip(IMaterial material, List<class_2561> tooltip) {
        if (material != IMaterial.UNKNOWN) {
            tooltip.add(class_2585.field_24366);
            tooltip.add((class_2561)new class_2588(ADDED_BY, new Object[]{DomainDisplayName.nameFor(material.getIdentifier().method_12836())}));
        }
    }

    public void method_7860(class_2487 nbt) {
        MaterialId resolved;
        MaterialId original;
        MaterialVariantId id = MaterialItem.getMaterialId(nbt);
        if (!id.equals(IMaterial.UNKNOWN_ID) && (original = id.getId()) != (resolved = MaterialRegistry.getInstance().resolve(original))) {
            nbt.method_10582("Material", MaterialVariantId.create(resolved, id.getVariant()).toString());
        }
    }
}

