/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.part;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.library.tools.part.MaterialItem;

public class ToolPartItem
extends MaterialItem
implements IToolPart {
    private static final class_2561 MISSING_INFO = TConstruct.makeTranslation("tooltip", "part.missing_info");
    private static final String MISSING_MATERIAL_KEY = TConstruct.makeTranslationKey("tooltip", "part.missing_material");
    private static final String MISSING_STATS_KEY = TConstruct.makeTranslationKey("tooltip", "part.missing_stats");
    public final MaterialStatsId materialStatId;

    public ToolPartItem(class_1792.class_1793 properties, MaterialStatsId id) {
        super(properties);
        this.materialStatId = id;
    }

    @Override
    public MaterialStatsId getStatType() {
        return this.materialStatId;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        if (TooltipUtil.isDisplay(stack)) {
            return;
        }
        MaterialVariantId materialVariant = this.getMaterial(stack);
        MaterialId id = materialVariant.getId();
        if (!materialVariant.equals(IMaterial.UNKNOWN_ID)) {
            if (this.canUseMaterial(id)) {
                for (ModifierEntry entry : MaterialRegistry.getInstance().getTraits(id, this.getStatType())) {
                    tooltip.add(entry.getModifier().getDisplayName(entry.getLevel()));
                }
                if (((Boolean)Config.CLIENT.extraToolTips.get()).booleanValue()) {
                    TooltipKey key = SafeClientAccess.getTooltipKey();
                    if (key == TooltipKey.SHIFT || key == TooltipKey.UNKNOWN) {
                        this.addStatInfoTooltip(id, tooltip);
                    } else {
                        tooltip.add(class_2585.field_24366);
                        tooltip.add(TooltipUtil.TOOLTIP_HOLD_SHIFT);
                    }
                }
            } else {
                IMaterial material = MaterialRegistry.getMaterial(id);
                if (material == IMaterial.UNKNOWN) {
                    tooltip.add((class_2561)new class_2588(MISSING_MATERIAL_KEY, new Object[]{id}));
                } else {
                    tooltip.add((class_2561)new class_2588(MISSING_STATS_KEY, new Object[]{this.materialStatId}).method_27692(class_124.field_1080));
                }
            }
        }
    }

    protected void addStatInfoTooltip(MaterialId material, List<class_2561> tooltip) {
        MaterialRegistry.getInstance().getMaterialStats(material, this.materialStatId).ifPresent(stat -> {
            List<class_2561> text = stat.getLocalizedInfo();
            if (!text.isEmpty()) {
                tooltip.add(class_2585.field_24366);
                tooltip.add((class_2561)stat.getLocalizedName().method_27695(new class_124[]{class_124.field_1068, class_124.field_1073}));
                tooltip.addAll(stat.getLocalizedInfo());
            }
        });
    }
}

