/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import io.github.fabricators_of_create.porting_lib.event.common.LivingEntityEvents;
import java.util.IdentityHashMap;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;
import slimeknights.tconstruct.common.Sounds;

public class SlimeBounceHandler {
    private static final IdentityHashMap<class_1297, BounceInfo> BOUNCING_ENTITIES = new IdentityHashMap();

    private SlimeBounceHandler() {
    }

    public static void init() {
        LivingEntityEvents.TICK.register(SlimeBounceHandler::onLivingTick);
        ServerLifecycleEvents.SERVER_STOPPING.register(SlimeBounceHandler::serverStopping);
    }

    public static void addBounceHandler(class_1309 entity) {
        SlimeBounceHandler.addBounceHandler(entity, null);
    }

    public static void addBounceHandler(class_1309 entity, @Nullable class_243 bounce) {
        BounceInfo info = BOUNCING_ENTITIES.get(entity);
        if (info == null) {
            BOUNCING_ENTITIES.put((class_1297)entity, new BounceInfo(entity, bounce));
        } else if (bounce != null) {
            info.bounce = bounce;
            info.bounceTick = entity.field_6012 + 1;
            class_243 motion = entity.method_18798();
            info.lastMagSq = motion.field_1352 * motion.field_1352 + motion.field_1350 * motion.field_1350;
            info.lastAngle = class_3532.method_15349((double)motion.field_1350, (double)motion.field_1352);
        }
    }

    private static void onLivingTick(class_1309 entity) {
        BounceInfo info = BOUNCING_ENTITIES.get(entity);
        if (info != null) {
            boolean isInAir;
            if (entity.method_6128() || entity.method_7325()) {
                BOUNCING_ENTITIES.remove(entity);
                return;
            }
            if (entity.field_6012 == info.bounceTick) {
                if (info.bounce != null) {
                    entity.method_18799(info.bounce);
                    info.bounce = null;
                }
                info.bounceTick = 0;
            }
            boolean bl = isInAir = !entity.method_24828() && !entity.method_5799() && !entity.method_6101();
            if (isInAir && info.lastMagSq > 0.0) {
                class_243 motion = entity.method_18798();
                double motionSq = motion.field_1352 * motion.field_1352 + motion.field_1350 * motion.field_1350;
                if (motionSq == 0.0) {
                    if (info.stopMagTick == 0) {
                        info.stopMagTick = entity.field_6012 + 5;
                    } else if (entity.field_6012 > info.stopMagTick) {
                        info.lastMagSq = 0.0;
                    }
                } else if (motionSq < info.lastMagSq) {
                    info.stopMagTick = 0;
                    double boost = Math.sqrt(info.lastMagSq / motionSq) * (double)0.975f;
                    if (boost > 1.0) {
                        entity.method_18800(motion.field_1352 * boost, motion.field_1351, motion.field_1350 * boost);
                        entity.field_6007 = true;
                        info.lastMagSq = info.lastMagSq * (double)0.975f * (double)0.975f;
                        double newAngle = class_3532.method_15349((double)motion.field_1350, (double)motion.field_1352);
                        if (Math.abs(newAngle - info.lastAngle) > 1.0) {
                            entity.method_5783(Sounds.SLIMY_BOUNCE.getSound(), 1.0f, 1.0f);
                        }
                        info.lastAngle = newAngle;
                    } else {
                        info.lastMagSq = motionSq;
                        info.lastAngle = class_3532.method_15349((double)motion.field_1350, (double)motion.field_1352);
                    }
                }
            }
            if (info.wasInAir && !isInAir) {
                if (info.endHandler == 0) {
                    info.endHandler = entity.field_6012 + 5;
                } else if (entity.field_6012 > info.endHandler) {
                    BOUNCING_ENTITIES.remove(entity);
                }
            } else {
                info.endHandler = 0;
                info.wasInAir = true;
            }
        }
    }

    private static void serverStopping(MinecraftServer server) {
        BOUNCING_ENTITIES.clear();
    }

    private static class BounceInfo {
        @Nullable
        private class_243 bounce;
        private int bounceTick;
        private int stopMagTick;
        private double lastMagSq;
        private boolean wasInAir = false;
        private int endHandler = 0;
        private double lastAngle;

        public BounceInfo(class_1309 entity, @Nullable class_243 bounce) {
            this.bounce = bounce;
            this.bounceTick = bounce != null ? entity.field_6012 + 1 : 0;
            class_243 motion = entity.method_18798();
            this.lastMagSq = motion.field_1352 * motion.field_1352 + motion.field_1350 * motion.field_1350;
        }
    }
}

