/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.fabric;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_1723;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.plugin.jei.fabric.JEITypes;

public class FluidStackRenderer
implements IIngredientRenderer<FluidStack> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final NumberFormat nf = NumberFormat.getIntegerInstance();
    private static final int TEXTURE_SIZE = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    private final long capacity;
    private final TooltipMode tooltipMode;
    private final int width;
    private final int height;

    public FluidStackRenderer() {
        this(1000L, TooltipMode.ITEM_LIST, 16, 16);
    }

    public FluidStackRenderer(long capacity, boolean showCapacity, int width, int height) {
        this(capacity, showCapacity ? TooltipMode.SHOW_AMOUNT_AND_CAPACITY : TooltipMode.SHOW_AMOUNT, width, height);
    }

    private FluidStackRenderer(long capacity, TooltipMode tooltipMode, int width, int height) {
        Preconditions.checkArgument((capacity > 0L ? 1 : 0) != 0, (Object)"capacity must be > 0");
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"width must be > 0");
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"height must be > 0");
        this.capacity = capacity;
        this.tooltipMode = tooltipMode;
        this.width = width;
        this.height = height;
    }

    public void render(class_4587 poseStack, FluidStack fluidStack) {
        RenderSystem.enableBlend();
        this.drawFluid(poseStack, this.width, this.height, fluidStack);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void drawFluid(class_4587 poseStack, int width, int height, FluidStack fluidStack) {
        IIngredientTypeWithSubtypes<class_3611, FluidStack> type = JEITypes.FLUID_STACK;
        class_3611 fluid = (class_3611)type.getBase((Object)fluidStack);
        if (fluid.method_15780(class_3612.field_15906)) {
            return;
        }
        class_1058 fluidStillSprite = FluidVariantRendering.getSprite((FluidVariant)fluidStack.getType());
        int fluidColor = FluidVariantRendering.getColor((FluidVariant)fluidStack.getType());
        long amount = fluidStack.getAmount();
        long scaledAmount = amount * (long)height / this.capacity;
        if (amount > 0L && scaledAmount < 1L) {
            scaledAmount = 1L;
        }
        if (scaledAmount > (long)height) {
            scaledAmount = height;
        }
        FluidStackRenderer.drawTiledSprite(poseStack, width, height, fluidColor, scaledAmount, fluidStillSprite);
    }

    private static void drawTiledSprite(class_4587 poseStack, int tiledWidth, int tiledHeight, int color, long scaledAmount, class_1058 sprite) {
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        class_1159 matrix = poseStack.method_23760().method_23761();
        FluidStackRenderer.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        long yTileCount = scaledAmount / 16L;
        long yRemainder = scaledAmount - yTileCount * 16L;
        int yStart = tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int yTile = 0;
            while ((long)yTile <= yTileCount) {
                int width = xTile == xTileCount ? xRemainder : 16;
                long height = (long)yTile == yTileCount ? yRemainder : 16L;
                int x = xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width > 0 && height > 0L) {
                    long maskTop = 16L - height;
                    int maskRight = 16 - width;
                    FluidStackRenderer.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
                }
                ++yTile;
            }
        }
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(class_1159 matrix, float xCoord, float yCoord, class_1058 textureSprite, long maskTop, long maskRight, float zLevel) {
        float uMin = textureSprite.method_4594();
        float uMax = textureSprite.method_4577();
        float vMin = textureSprite.method_4593();
        float vMax = textureSprite.method_4575();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        RenderSystem.setShader(class_757::method_34542);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, xCoord, yCoord + 16.0f, zLevel).method_22913(uMin, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).method_22913(uMax, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).method_22913(uMax, vMin).method_1344();
        bufferBuilder.method_22918(matrix, xCoord, yCoord + (float)maskTop, zLevel).method_22913(uMin, vMin).method_1344();
        tessellator.method_1350();
    }

    public List<class_2561> getTooltip(FluidStack fluidStack, class_1836 tooltipFlag) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        IIngredientTypeWithSubtypes<class_3611, FluidStack> type = JEITypes.FLUID_STACK;
        class_3611 fluidType = (class_3611)type.getBase((Object)fluidStack);
        try {
            if (fluidType.method_15780(class_3612.field_15906)) {
                return tooltip;
            }
            class_2561 displayName = fluidStack.getDisplayName();
            tooltip.add(displayName);
            long amount = fluidStack.getAmount();
            long milliBuckets = amount * 1000L / 1000L;
            if (this.tooltipMode == TooltipMode.SHOW_AMOUNT_AND_CAPACITY) {
                class_2588 amountString = new class_2588("jei.tooltip.liquid.amount.with.capacity", new Object[]{nf.format(milliBuckets), nf.format(this.capacity)});
                tooltip.add((class_2561)amountString.method_27692(class_124.field_1080));
            } else if (this.tooltipMode == TooltipMode.SHOW_AMOUNT) {
                class_2588 amountString = new class_2588("jei.tooltip.liquid.amount", new Object[]{nf.format(milliBuckets)});
                tooltip.add((class_2561)amountString.method_27692(class_124.field_1080));
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to get tooltip for fluid: " + fluidStack, (Throwable)e);
        }
        return tooltip;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    static enum TooltipMode {
        SHOW_AMOUNT,
        SHOW_AMOUNT_AND_CAPACITY,
        ITEM_LIST;

    }
}

