/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.melting;

import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.fabric.JEITypes;
import slimeknights.tconstruct.plugin.jei.melting.AbstractMeltingCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class FoundryCategory
extends AbstractMeltingCategory {
    private static final class_2561 TITLE = TConstruct.makeTranslation("jei", "foundry.title");
    private static final IRecipeSlotTooltipCallback METAL_ORE_TOOLTIP = new MeltingFluidCallback(IMeltingContainer.OreRateType.METAL);
    private static final IRecipeSlotTooltipCallback GEM_ORE_TOOLTIP = new MeltingFluidCallback(IMeltingContainer.OreRateType.GEM);
    private final IDrawable icon;

    public FoundryCategory(IGuiHelper helper) {
        super(helper);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799(TinkerSmeltery.foundryController));
    }

    public class_2960 getUid() {
        return TConstructJEIConstants.FOUNDRY.getUid();
    }

    public RecipeType<MeltingRecipe> getRecipeType() {
        return TConstructJEIConstants.FOUNDRY;
    }

    public class_2561 getTitle() {
        return TITLE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MeltingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 18).addIngredients(recipe.getInput());
        IMeltingContainer.OreRateType oreType = recipe.getOreType();
        Object tooltip = oreType == IMeltingContainer.OreRateType.METAL ? METAL_ORE_TOOLTIP : (oreType == IMeltingContainer.OreRateType.GEM ? GEM_ORE_TOOLTIP : MeltingFluidCallback.INSTANCE);
        AlloyRecipeCategory.drawVariableFluids(builder, RecipeIngredientRole.OUTPUT, 96, 4, 32, 32, recipe.getOutputWithByproducts(), 81000L, tooltip);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 4, 4).addTooltipCallback((IRecipeSlotTooltipCallback)FUEL_TOOLTIP).setFluidRenderer(1L, false, 12, 32).addIngredients(JEITypes.FLUID_STACK, MeltingFuelHandler.getUsableFuels(recipe.getTemperature()));
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    private static class MeltingFluidCallback
    extends AbstractMeltingCategory.MeltingFluidCallback {
        private final IMeltingContainer.OreRateType oreRate;

        @Override
        protected boolean appendMaterial(FluidStack stack, List<class_2561> list) {
            return FluidTooltipHandler.appendMaterialNoShift((class_3611)stack.getFluid(), (long)Config.COMMON.foundryOreRate.applyOreBoost(this.oreRate, stack.getAmount()), list);
        }

        public MeltingFluidCallback(IMeltingContainer.OreRateType oreRate) {
            this.oreRate = oreRate;
        }

        public IMeltingContainer.OreRateType getOreRate() {
            return this.oreRate;
        }
    }
}

