/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.rei;

import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import slimeknights.tconstruct.plugin.rei.IRecipeTooltipReplacement;
import slimeknights.tconstruct.plugin.rei.widgets.TooltipWidget;
import slimeknights.tconstruct.plugin.rei.widgets.WidgetHolder;

public interface TinkersCategory<T extends Display>
extends DisplayCategory<T> {
    default public void draw(T display, class_4587 matrixStack, double mouseX, double mouseY) {
    }

    public void addWidgets(T var1, List<Widget> var2, Point var3, Rectangle var4);

    public WidgetHolder getBackground();

    default public List<class_2561> getTooltipStrings(T display, List<Widget> widgets, double mouseX, double mouseY) {
        return Collections.emptyList();
    }

    default public int getDisplayHeight() {
        return this.getBackground().height() + 8;
    }

    default public int getDisplayWidth(T display) {
        return this.getBackground().width() + 8;
    }

    default public List<Widget> setupDisplay(T display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        Point origin = new Point(bounds.getX() + 5, bounds.getY() + 5);
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(this.getBackground().build(0, 0, origin));
        widgets.add(Widgets.createDrawableWidget((helper, poseStack, mouseX, mouseY, partialTick) -> {
            poseStack.method_22903();
            poseStack.method_22904((double)(bounds.getX() + 5), (double)(bounds.getY() + 5), 0.0);
            this.draw(display, poseStack, mouseX, mouseY);
            poseStack.method_22909();
        }));
        this.addWidgets(display, widgets, origin, bounds);
        TinkersCategory tinkersCategory = this;
        if (tinkersCategory instanceof IRecipeTooltipReplacement) {
            IRecipeTooltipReplacement replacement = (IRecipeTooltipReplacement)((Object)tinkersCategory);
            widgets.forEach(widget -> {
                if (widget instanceof Slot) {
                    Slot slot = (Slot)widget;
                    for (EntryStack entry : slot.getEntries()) {
                        ClientEntryStacks.setTooltipProcessor((EntryStack)entry, (stack, tooltip) -> {
                            List components = CollectionUtils.filterAndMap((Iterable)tooltip.entries(), Tooltip.Entry::isText, Tooltip.Entry::getAsText);
                            List tooltipComponents = CollectionUtils.filterAndMap((Iterable)tooltip.entries(), ((Predicate<Tooltip.Entry>)Tooltip.Entry::isText).negate(), Tooltip.Entry::getAsComponent);
                            replacement.onTooltip(slot, components);
                            tooltip.entries().clear();
                            tooltip.addAllTexts((Iterable)components);
                            tooltip.addAllComponents((Iterable)tooltipComponents);
                            return tooltip;
                        });
                    }
                }
            });
        }
        widgets.add((Widget)new TooltipWidget<T>(this, widgets, display, bounds));
        return widgets;
    }

    default public Slot slot(int x, int y, Point origin) {
        return Widgets.createSlot((Point)new Point(origin.x + x, origin.y + y)).disableBackground();
    }

    default public Point point(int x, int y, Point origin) {
        return new Point(origin.getX() + x, origin.getY() + y);
    }

    public static List<FluidStack> toREIFluids(List<io.github.fabricators_of_create.porting_lib.util.FluidStack> fluids) {
        ArrayList<FluidStack> newFluids = new ArrayList<FluidStack>();
        fluids.forEach(stack -> newFluids.add(TinkersCategory.toREIFluid(stack)));
        return newFluids;
    }

    public static FluidStack toREIFluid(io.github.fabricators_of_create.porting_lib.util.FluidStack stack) {
        return FluidStack.create((class_3611)stack.getFluid(), (long)stack.getAmount(), (class_2487)stack.getTag());
    }

    public static io.github.fabricators_of_create.porting_lib.util.FluidStack fromREIFluid(FluidStack stack) {
        return new io.github.fabricators_of_create.porting_lib.util.FluidStack(stack.getFluid(), stack.getAmount(), stack.getTag());
    }

    public static Slot slot(int x, int y, Point origin, boolean isInput) {
        Slot slot = Widgets.createSlot((Point)new Point(origin.x + x, origin.y + y));
        return isInput ? slot.markInput() : slot.markOutput();
    }

    public static void setEntryTooltip(Slot slot, IRecipeTooltipReplacement replacement) {
        slot.getEntries().forEach(stack -> ClientEntryStacks.setTooltipProcessor((EntryStack)stack, (entryStack, tooltip) -> {
            List components = CollectionUtils.filterAndMap((Iterable)tooltip.entries(), Tooltip.Entry::isText, Tooltip.Entry::getAsText);
            List tooltipComponents = CollectionUtils.filterAndMap((Iterable)tooltip.entries(), ((Predicate<Tooltip.Entry>)Tooltip.Entry::isText).negate(), Tooltip.Entry::getAsComponent);
            replacement.onTooltip(slot, components);
            tooltip.entries().clear();
            tooltip.addAllTexts((Iterable)components);
            tooltip.addAllComponents((Iterable)tooltipComponents);
            return tooltip;
        }));
    }
}

