/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.rei.casting;

import dev.architectury.fluid.FluidStack;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.plugin.rei.IRecipeTooltipReplacement;
import slimeknights.tconstruct.plugin.rei.TinkersCategory;
import slimeknights.tconstruct.plugin.rei.casting.CastingDisplay;
import slimeknights.tconstruct.plugin.rei.widgets.ArrowWidget;
import slimeknights.tconstruct.plugin.rei.widgets.WidgetHolder;

public abstract class AbstractCastingCategory
implements TinkersCategory<CastingDisplay>,
IRecipeTooltipReplacement {
    private static final String KEY_COOLING_TIME = TConstruct.makeTranslationKey("jei", "time");
    private static final String KEY_CAST_KEPT = TConstruct.makeTranslationKey("jei", "casting.cast_kept");
    private static final String KEY_CAST_CONSUMED = TConstruct.makeTranslationKey("jei", "casting.cast_consumed");
    public static final class_2960 BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/casting.png");
    private final WidgetHolder background = new WidgetHolder(BACKGROUND_LOC, 0, 0, 117, 54);
    private final Renderer icon;
    private final WidgetHolder tankOverlay;
    private final WidgetHolder castConsumed;
    private final WidgetHolder castKept;
    private final WidgetHolder block;

    protected AbstractCastingCategory(class_2248 icon, WidgetHolder block) {
        this.icon = EntryStacks.of((class_1935)icon);
        this.tankOverlay = new WidgetHolder(BACKGROUND_LOC, 133, 0, 32, 32);
        this.castConsumed = new WidgetHolder(BACKGROUND_LOC, 141, 32, 13, 11);
        this.castKept = new WidgetHolder(BACKGROUND_LOC, 141, 43, 13, 11);
        this.block = block;
    }

    @Override
    public void draw(CastingDisplay display, class_4587 matrixStack, double mouseX, double mouseY) {
        IDisplayableCastingRecipe recipe = display.getRecipe();
        int coolingTime = recipe.getCoolingTime() / 20;
        String coolingString = class_1074.method_4662((String)KEY_COOLING_TIME, (Object[])new Object[]{coolingTime});
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int x = 72 - fontRenderer.method_1727(coolingString) / 2;
        fontRenderer.method_1729(matrixStack, coolingString, (float)x, 2.0f, Color.GRAY.getRGB());
    }

    @Override
    public List<class_2561> getTooltipStrings(CastingDisplay display, List<Widget> widgets, double mouseX, double mouseY) {
        if (display.hasCast() && GuiUtil.isHovered((int)mouseX, (int)mouseY, 63, 39, 13, 11)) {
            return Collections.singletonList(new class_2588(display.isConsumed() ? KEY_CAST_CONSUMED : KEY_CAST_KEPT));
        }
        return Collections.emptyList();
    }

    @Override
    public void addWidgets(CastingDisplay display, List<Widget> ingredients, Point origin, Rectangle bounds) {
        IDisplayableCastingRecipe recipe = display.getRecipe();
        List<class_1799> casts = recipe.getCastItems();
        if (!casts.isEmpty()) {
            ingredients.add((Widget)this.slot(38, 19, origin).markInput().entries((Collection)EntryIngredients.ofItemStacks(casts)).disableBackground());
        }
        ingredients.add((Widget)this.slot(93, 18, origin).markOutput().entry(EntryStacks.of((class_1799)recipe.getOutput())).disableBackground());
        long capacity = 81000L;
        Slot input = this.slot(3, 3, origin).markInput().disableBackground().entries((Collection)EntryIngredients.of((EntryType)VanillaEntryTypes.FLUID, TinkersCategory.toREIFluids(recipe.getFluids())));
        input.getEntries().forEach(entryStack -> ClientEntryStacks.setFluidRenderRatio((EntryStack)entryStack.cast(), (float)((float)((FluidStack)entryStack.castValue()).getAmount() / (float)capacity)));
        input.getBounds().setSize(34, 34);
        ingredients.add((Widget)input);
        ingredients.add(this.tankOverlay.build(3, 3, origin));
        int h = 11;
        if (!display.hasCast()) {
            h += 16;
        }
        Slot renderInput = this.slot(43, 8, origin).disableBackground().entries((Collection)EntryIngredients.of((EntryType)VanillaEntryTypes.FLUID, TinkersCategory.toREIFluids(recipe.getFluids())));
        renderInput.getBounds().setSize(8, h + 2);
        ingredients.add((Widget)renderInput);
        ingredients.add((Widget)new ArrowWidget(this.point(58, 18, origin), BACKGROUND_LOC, 117, 32).animationDurationTicks(Math.max(1, recipe.getCoolingTime())));
        ingredients.add(this.block.build(38, 35, origin));
        if (display.hasCast()) {
            ingredients.add((display.isConsumed() ? this.castConsumed : this.castKept).build(63, 39, origin));
        }
    }

    @Override
    public void addMiddleLines(Slot slot, List<class_2561> list) {
        if (slot.getCurrentEntry().getType() == VanillaEntryTypes.FLUID) {
            FluidTooltipHandler.appendMaterial((io.github.fabricators_of_create.porting_lib.util.FluidStack)TinkersCategory.fromREIFluid((FluidStack)slot.getCurrentEntry().castValue()), list);
        }
    }

    @Override
    public WidgetHolder getBackground() {
        return this.background;
    }

    public Renderer getIcon() {
        return this.icon;
    }
}

