/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.rei.melting;

import dev.architectury.fluid.FluidStack;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3611;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.plugin.rei.IRecipeTooltipReplacement;
import slimeknights.tconstruct.plugin.rei.TConstructREIConstants;
import slimeknights.tconstruct.plugin.rei.TinkersCategory;
import slimeknights.tconstruct.plugin.rei.melting.AbstractMeltingCategory;
import slimeknights.tconstruct.plugin.rei.melting.MeltingDisplay;
import slimeknights.tconstruct.plugin.rei.widgets.WidgetHolder;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MeltingCategory
extends AbstractMeltingCategory {
    private static final class_2561 TITLE = TConstruct.makeTranslation("jei", "melting.title");
    private static final String KEY_TEMPERATURE = TConstruct.makeTranslationKey("jei", "temperature");
    private static final String KEY_MULTIPLIER = TConstruct.makeTranslationKey("jei", "melting.multiplier");
    private static final class_2561 SOLID_TEMPERATURE = new class_2588(KEY_TEMPERATURE, new Object[]{800}).method_27692(class_124.field_1080);
    private static final class_2561 SOLID_MULTIPLIER = new class_2588(KEY_MULTIPLIER, new Object[]{Float.valueOf(0.8f)}).method_27692(class_124.field_1080);
    private static final class_2561 TOOLTIP_SMELTERY = TConstruct.makeTranslation("jei", "melting.smeltery").method_27695(new class_124[]{class_124.field_1080, class_124.field_1073});
    private static final class_2561 TOOLTIP_MELTER = TConstruct.makeTranslation("jei", "melting.melter").method_27695(new class_124[]{class_124.field_1080, class_124.field_1073});
    private static final IRecipeTooltipReplacement ITEM_FUEL_TOOLTIP = (slot, list) -> {
        list.add(1, SOLID_TEMPERATURE);
        list.add(2, SOLID_MULTIPLIER);
    };
    private static final IRecipeTooltipReplacement METAL_ORE_TOOLTIP = new MeltingFluidCallback(IMeltingContainer.OreRateType.METAL);
    private static final IRecipeTooltipReplacement GEM_ORE_TOOLTIP = new MeltingFluidCallback(IMeltingContainer.OreRateType.GEM);
    private final Renderer icon = EntryStacks.of(TinkerSmeltery.searedMelter);
    private final WidgetHolder solidFuel = new WidgetHolder(BACKGROUND_LOC, 164, 0, 18, 20);

    public CategoryIdentifier<MeltingDisplay> getCategoryIdentifier() {
        return TConstructREIConstants.MELTING;
    }

    public class_2561 getTitle() {
        return TITLE;
    }

    @Override
    public void addWidgets(MeltingDisplay display, List<Widget> ingredients, Point origin, Rectangle bounds) {
        Slot renderSlot;
        super.addWidgets(display, ingredients, origin, bounds);
        int temperature = display.getTemperature();
        if (temperature <= 800) {
            ingredients.add(this.solidFuel.build(1, 19, origin));
        }
        ingredients.add((Widget)this.slot(24, 18, origin).markInput().disableBackground().entries((Collection)display.getInputEntries().get(0)));
        IMeltingContainer.OreRateType oreType = display.getOreType();
        IRecipeTooltipReplacement tooltip = oreType == IMeltingContainer.OreRateType.METAL ? METAL_ORE_TOOLTIP : (oreType == IMeltingContainer.OreRateType.GEM ? GEM_ORE_TOOLTIP : MeltingFluidCallback.INSTANCE);
        Slot output = this.slot(96, 4, origin).markOutput().disableBackground().entries((Collection)display.getOutputEntries().get(0));
        EntryStack stack = output.getCurrentEntry().cast();
        ClientEntryStacks.setFluidRenderRatio((EntryStack)stack, (float)((float)((FluidStack)stack.getValue()).getAmount() / 81000.0f));
        TinkersCategory.setEntryTooltip(output, tooltip);
        output.getBounds().setSize(34, 34);
        ingredients.add((Widget)output);
        ingredients.add(this.tankOverlay.build(96, 4, origin));
        int fuelHeight = 32;
        if (display.getTemperature() <= 800) {
            fuelHeight = 15;
            renderSlot = this.slot(2, 22, origin).disableBackground().entries((Collection)EntryIngredients.ofItemStacks((Collection)((Collection)MeltingFuelHandler.SOLID_FUELS.get())));
            TinkersCategory.setEntryTooltip(renderSlot, ITEM_FUEL_TOOLTIP);
            ingredients.add((Widget)renderSlot);
        }
        renderSlot = this.slot(4, 4, origin).disableBackground().entries((Collection)EntryIngredients.of((EntryType)VanillaEntryTypes.FLUID, TinkersCategory.toREIFluids(MeltingFuelHandler.getUsableFuels(display.getTemperature()))));
        TinkersCategory.setEntryTooltip(renderSlot, FUEL_TOOLTIP);
        renderSlot.getBounds().setSize(14, fuelHeight + 2);
        ingredients.add((Widget)renderSlot);
    }

    public Renderer getIcon() {
        return this.icon;
    }

    private static class MeltingFluidCallback
    extends AbstractMeltingCategory.MeltingFluidCallback {
        private final IMeltingContainer.OreRateType oreType;

        @Override
        protected boolean appendMaterial(FluidStack stack, List<class_2561> list) {
            long melterAmount;
            class_3611 fluid = stack.getFluid();
            long amount = stack.getAmount();
            long smelteryAmount = Config.COMMON.smelteryOreRate.applyOreBoost(this.oreType, amount);
            if (smelteryAmount != (melterAmount = Config.COMMON.melterOreRate.applyOreBoost(this.oreType, amount))) {
                list.add(TOOLTIP_MELTER);
                boolean shift = FluidTooltipHandler.appendMaterialNoShift((class_3611)fluid, (long)melterAmount, list);
                list.add(class_2585.field_24366);
                list.add(TOOLTIP_SMELTERY);
                shift = FluidTooltipHandler.appendMaterialNoShift((class_3611)fluid, (long)smelteryAmount, list) || shift;
                return shift;
            }
            return FluidTooltipHandler.appendMaterialNoShift((class_3611)fluid, (long)smelteryAmount, list);
        }

        public MeltingFluidCallback(IMeltingContainer.OreRateType oreType) {
            this.oreType = oreType;
        }

        public IMeltingContainer.OreRateType getOreType() {
            return this.oreType;
        }
    }
}

