/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.rei.modifiers;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.fabricators_of_create.porting_lib.util.ForgeI18n;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4730;
import net.minecraft.class_757;
import slimeknights.mantle.client.model.NBTKeyModel;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.plugin.rei.TConstructREIConstants;
import slimeknights.tconstruct.plugin.rei.TinkersCategory;
import slimeknights.tconstruct.plugin.rei.modifiers.ModifierEntryRenderer;
import slimeknights.tconstruct.plugin.rei.modifiers.ModifierRecipeDisplay;
import slimeknights.tconstruct.plugin.rei.widgets.WidgetHolder;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.CreativeSlotItem;

public class ModifierRecipeCategory
implements TinkersCategory<ModifierRecipeDisplay> {
    protected static final class_2960 BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/tinker_station.png");
    private static final class_2561 TITLE = TConstruct.makeTranslation("jei", "modifiers.title");
    private static final List<class_2561> TEXT_FREE = Collections.singletonList(TConstruct.makeTranslation("jei", "modifiers.free"));
    private static final List<class_2561> TEXT_INCREMENTAL = Collections.singletonList(TConstruct.makeTranslation("jei", "modifiers.incremental"));
    private static final String KEY_SLOT = TConstruct.makeTranslationKey("jei", "modifiers.slot");
    private static final String KEY_SLOTS = TConstruct.makeTranslationKey("jei", "modifiers.slots");
    private static final String KEY_MAX = TConstruct.makeTranslationKey("jei", "modifiers.max");
    private final ModifierEntryRenderer modifierRenderer = new ModifierEntryRenderer(124, 10);
    private final WidgetHolder background;
    private final Renderer icon;
    private final String maxPrefix;
    private final WidgetHolder requirements;
    private final WidgetHolder incremental;
    private final WidgetHolder[] slotIcons;
    private final Map<SlotType, class_1058> slotTypeSprites = new HashMap<SlotType, class_1058>();

    public ModifierRecipeCategory() {
        this.maxPrefix = ForgeI18n.getPattern((String)KEY_MAX);
        this.background = new WidgetHolder(BACKGROUND_LOC, 0, 0, 128, 77);
        this.icon = EntryStacks.of((class_1799)CreativeSlotItem.withSlot(new class_1799(TinkerModifiers.creativeSlotItem), SlotType.UPGRADE));
        this.slotIcons = new WidgetHolder[6];
        for (int i = 0; i < 6; ++i) {
            this.slotIcons[i] = new WidgetHolder(BACKGROUND_LOC, 128 + i * 16, 0, 16, 16);
        }
        this.requirements = new WidgetHolder(BACKGROUND_LOC, 128, 17, 16, 16);
        this.incremental = new WidgetHolder(BACKGROUND_LOC, 128, 33, 16, 16);
    }

    public CategoryIdentifier<ModifierRecipeDisplay> getCategoryIdentifier() {
        return TConstructREIConstants.MODIFIERS;
    }

    public class_2561 getTitle() {
        return TITLE;
    }

    private void drawSlot(Point origin, List<Widget> ingredients, IDisplayModifierRecipe recipe, int slot, int x, int y) {
        List<class_1799> stacks = recipe.getDisplayItems(slot);
        if (stacks.isEmpty()) {
            ingredients.add(this.slotIcons[slot].build(x + 1, y + 1, origin));
        }
    }

    private void drawSlotType(class_4587 matrices, @Nullable SlotType slotType, int x, int y) {
        class_1058 sprite;
        class_310 minecraft = class_310.method_1551();
        if (this.slotTypeSprites.containsKey(slotType)) {
            sprite = this.slotTypeSprites.get(slotType);
        } else {
            class_1092 modelManager = minecraft.method_1554();
            class_1087 model = minecraft.method_1480().method_4012().method_3304((class_1792)TinkerModifiers.creativeSlotItem.get());
            if (model != null && model.method_4710() instanceof NBTKeyModel.Overrides) {
                class_4730 material = ((NBTKeyModel.Overrides)model.method_4710()).getTexture(slotType == null ? "slotless" : slotType.getName());
                sprite = modelManager.method_24153(material.method_24144()).method_4608(material.method_24147());
            } else {
                sprite = modelManager.method_24153(class_1723.field_21668).method_4608(class_1047.method_4539());
            }
            this.slotTypeSprites.put(slotType, sprite);
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        class_437.method_25298((class_4587)matrices, (int)x, (int)y, (int)0, (int)16, (int)16, (class_1058)sprite);
    }

    @Override
    public void draw(ModifierRecipeDisplay display, class_4587 matrices, double mouseX, double mouseY) {
        SlotType.SlotCount slots;
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int max = display.getMaxLevel();
        if (max > 0) {
            fontRenderer.method_1729(matrices, this.maxPrefix + max, 66.0f, 16.0f, Color.GRAY.getRGB());
        }
        if ((slots = display.getSlots()) == null) {
            this.drawSlotType(matrices, null, 110, 58);
        } else {
            this.drawSlotType(matrices, slots.getType(), 110, 58);
            String text = Integer.toString(slots.getCount());
            int x = 111 - fontRenderer.method_1727(text);
            fontRenderer.method_1729(matrices, text, (float)x, 63.0f, Color.GRAY.getRGB());
        }
    }

    @Override
    public List<class_2561> getTooltipStrings(ModifierRecipeDisplay display, List<Widget> widgets, double mouseX, double mouseY) {
        int checkX = (int)mouseX;
        int checkY = (int)mouseY;
        if (display.hasRequirements() && GuiUtil.isHovered(checkX, checkY, 66, 58, 16, 16)) {
            return Collections.singletonList(new class_2588(display.getRequirementsError()));
        }
        if (display.isIncremental() && GuiUtil.isHovered(checkX, checkY, 83, 59, 16, 16)) {
            return TEXT_INCREMENTAL;
        }
        if (GuiUtil.isHovered(checkX, checkY, 98, 58, 24, 16)) {
            SlotType.SlotCount slots = display.getSlots();
            if (slots != null) {
                int count = slots.getCount();
                if (count == 1) {
                    return Collections.singletonList(new class_2588(KEY_SLOT, new Object[]{slots.getType().getDisplayName()}));
                }
                if (count > 1) {
                    return Collections.singletonList(new class_2588(KEY_SLOTS, new Object[]{slots, slots.getType().getDisplayName()}));
                }
            } else {
                return TEXT_FREE;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void addWidgets(ModifierRecipeDisplay display, List<Widget> ingredients, Point origin, Rectangle bounds) {
        IDisplayModifierRecipe recipe = display.getRecipe();
        ingredients.add((Widget)this.slot(3, 33, origin).markInput().entries((Collection)EntryIngredients.ofItemStacks(recipe.getDisplayItems(0))));
        ingredients.add((Widget)this.slot(25, 15, origin).markInput().entries((Collection)EntryIngredients.ofItemStacks(recipe.getDisplayItems(1))));
        ingredients.add((Widget)this.slot(47, 33, origin).markInput().entries((Collection)EntryIngredients.ofItemStacks(recipe.getDisplayItems(2))));
        ingredients.add((Widget)this.slot(43, 58, origin).markInput().entries((Collection)EntryIngredients.ofItemStacks(recipe.getDisplayItems(3))));
        ingredients.add((Widget)this.slot(7, 58, origin).markInput().entries((Collection)EntryIngredients.ofItemStacks(recipe.getDisplayItems(4))));
        Slot output = this.slot(3, 3, origin).markOutput().entry(EntryStack.of(TConstructREIConstants.MODIFIER_TYPE, (Object)recipe.getDisplayResult()));
        ClientEntryStacks.setRenderer((EntryStack)output.getCurrentEntry(), (EntryRenderer)this.modifierRenderer);
        output.getBounds().setSize(this.modifierRenderer.width(), this.modifierRenderer.height());
        ingredients.add((Widget)output);
        ingredients.add((Widget)this.slot(25, 38, origin).entries((Collection)EntryIngredients.ofItemStacks(recipe.getToolWithoutModifier())));
        ingredients.add((Widget)this.slot(105, 34, origin).entries((Collection)EntryIngredients.ofItemStacks(recipe.getToolWithModifier())));
        this.drawSlot(origin, ingredients, display.getRecipe(), 0, 2, 32);
        this.drawSlot(origin, ingredients, display.getRecipe(), 1, 24, 14);
        this.drawSlot(origin, ingredients, display.getRecipe(), 2, 46, 32);
        this.drawSlot(origin, ingredients, display.getRecipe(), 3, 42, 57);
        this.drawSlot(origin, ingredients, display.getRecipe(), 4, 6, 57);
        if (display.hasRequirements()) {
            ingredients.add(this.requirements.build(66, 58, origin));
        }
        if (display.isIncremental()) {
            ingredients.add(this.incremental.build(83, 59, origin));
        }
    }

    @Override
    public WidgetHolder getBackground() {
        return this.background;
    }

    public Renderer getIcon() {
        return this.icon;
    }
}

