/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.fabricators_of_create.porting_lib.mixin.common.accessor.RecipeManagerAccessor;
import io.github.fabricators_of_create.porting_lib.util.TablePrinter;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3956;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.shared.command.argument.SlotTypeArgument;

public class ModifierUsageCommand {
    private static final class_2561 SUCCESS = new class_2588("command.tconstruct.modifier_usage");

    public static void register(LiteralArgumentBuilder<class_2168> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(sender -> sender.method_9259(1))).executes(context -> ModifierUsageCommand.runForType((CommandContext<class_2168>)context, ModifierUsages.ALL, null))).then(class_2170.method_9247((String)"all").executes(context -> ModifierUsageCommand.runForType((CommandContext<class_2168>)context, ModifierUsages.ALL, null)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"recipe").then(class_2170.method_9244((String)"slot_type", (ArgumentType)SlotTypeArgument.slotType()).executes(ModifierUsageCommand::runRecipeWithFilter))).executes(context -> ModifierUsageCommand.runForType((CommandContext<class_2168>)context, ModifierUsages.RECIPE, null)))).then(class_2170.method_9247((String)"material_trait").executes(context -> ModifierUsageCommand.runForType((CommandContext<class_2168>)context, ModifierUsages.MATERIAL_TRAIT, null)))).then(class_2170.method_9247((String)"tool_trait").executes(context -> ModifierUsageCommand.runForType((CommandContext<class_2168>)context, ModifierUsages.TOOL_TRAIT, null)))).then(class_2170.method_9247((String)"unused").executes(context -> ModifierUsageCommand.runForType((CommandContext<class_2168>)context, ModifierUsages.UNUSED, null)));
    }

    private static int runRecipeWithFilter(CommandContext<class_2168> context) {
        return ModifierUsageCommand.runForType(context, ModifierUsages.RECIPE, SlotTypeArgument.getOptional(context, "slot_type"));
    }

    private static int runForType(CommandContext<class_2168> context, ModifierUsages filter, @Nullable SlotTypeArgument.OptionalSlotType slotFilter) {
        HashMultimap recipeModifiers = ((RecipeManagerAccessor)((class_2168)context.getSource()).method_9225().method_8433()).port_lib$byType((class_3956)TinkerRecipeTypes.TINKER_STATION.get()).values().stream().filter(r -> r instanceof IModifierRecipe).map(r -> (IModifierRecipe)r).collect(Collector.of(HashMultimap::create, (map, r) -> map.put((Object)r.getSlotType(), (Object)r.getModifier()), (m1, m2) -> {
            m1.putAll((Multimap)m2);
            return m1;
        }, new Collector.Characteristics[0]));
        IMaterialRegistry matReg = MaterialRegistry.getInstance();
        Set materialTraits = matReg.getAllMaterials().stream().flatMap(mat -> {
            MaterialId matId = mat.getIdentifier();
            return Stream.concat(matReg.getDefaultTraits(matId).stream(), matReg.getAllStats(matId).stream().filter(stat -> matReg.hasUniqueTraits(matId, stat.getIdentifier())).flatMap(stat -> matReg.getTraits(matId, stat.getIdentifier()).stream()));
        }).map(ModifierEntry::getModifier).collect(Collectors.toSet());
        Set toolTraits = RegistryHelper.getTagValueStream((class_2378)class_2378.field_11142, TinkerTags.Items.MODIFIABLE).filter(item -> item instanceof IModifiable).flatMap(item -> ((IModifiable)item).getToolDefinition().getData().getTraits().stream()).map(ModifierEntry::getModifier).collect(Collectors.toSet());
        Stream<Object> modifierStream = switch (filter) {
            case ModifierUsages.RECIPE -> {
                if (slotFilter != null) {
                    yield recipeModifiers.get((Object)slotFilter.slotType()).stream();
                }
                yield recipeModifiers.values().stream();
            }
            case ModifierUsages.MATERIAL_TRAIT -> materialTraits.stream();
            case ModifierUsages.TOOL_TRAIT -> toolTraits.stream();
            default -> ModifierManager.INSTANCE.getAllValues();
        };
        if (filter == ModifierUsages.UNUSED) {
            modifierStream = modifierStream.filter(modifier -> !recipeModifiers.containsValue(modifier) && !materialTraits.contains(modifier) && !toolTraits.contains(modifier));
        }
        TablePrinter table = new TablePrinter();
        table.header("ID", r -> r.modifierId().toString());
        if (filter != ModifierUsages.UNUSED) {
            if (filter != ModifierUsages.RECIPE || slotFilter == null) {
                table.header("Recipe", ModifierUsageRow::recipe);
            }
            if (filter != ModifierUsages.MATERIAL_TRAIT) {
                table.header("material Trait", r -> r.materialTrait() ? "Material trait" : "");
            }
            if (filter != ModifierUsages.TOOL_TRAIT) {
                table.header("tool Trait", r -> r.toolTrait() ? "Tool trait" : "");
            }
        }
        StringBuilder logOutput = new StringBuilder();
        logOutput.append(filter.logPrefix);
        if (slotFilter != null) {
            if (slotFilter.slotType() == null) {
                logOutput.append(" (slotless)");
            } else {
                logOutput.append(" (").append(slotFilter.slotType().getName()).append(")");
            }
        }
        logOutput.append(System.lineSeparator());
        List<Modifier> finalList = modifierStream.sorted(Comparator.comparing(Modifier::getId)).toList();
        finalList.forEach(modifier -> {
            List recipeUsages = SlotType.getAllSlotTypes().stream().filter(type -> recipeModifiers.containsEntry(type, modifier)).map(SlotType::getName).collect(Collectors.toList());
            String recipes = recipeUsages.isEmpty() ? (recipeModifiers.containsEntry(null, modifier) ? "slotless" : "") : String.join((CharSequence)", ", recipeUsages);
            table.add((Object)new ModifierUsageRow(modifier.getId(), recipes, toolTraits.contains(modifier), materialTraits.contains(modifier)));
        });
        table.build(logOutput);
        TConstruct.LOG.info(logOutput.toString());
        ((class_2168)context.getSource()).method_9226(SUCCESS, true);
        return finalList.size();
    }

    private static enum ModifierUsages {
        UNUSED("Unused modifiers:"),
        RECIPE("Recipe modifiers:"),
        MATERIAL_TRAIT("Material trait modifiers:"),
        TOOL_TRAIT("Tool trait modifiers:"),
        ALL("All modifiers:");

        private final String logPrefix;

        private ModifierUsages(String logPrefix) {
            this.logPrefix = logPrefix;
        }
    }

    private record ModifierUsageRow(ModifierId modifierId, String recipe, boolean toolTrait, boolean materialTrait) {
    }
}

