/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import org.apache.commons.lang3.mutable.MutableInt;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRequirements;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.command.HeldModifiableItemIterator;
import slimeknights.tconstruct.shared.command.argument.ModifierArgument;

public class ModifiersCommand {
    private static final String ADD_SUCCESS = TConstruct.makeTranslationKey("command", "modifiers.success.add.single");
    private static final String ADD_SUCCESS_MULTIPLE = TConstruct.makeTranslationKey("command", "modifiers.success.add.multiple");
    private static final String REMOVE_SUCCESS = TConstruct.makeTranslationKey("command", "modifiers.success.remove.single");
    private static final String REMOVE_SUCCESS_MULTIPLE = TConstruct.makeTranslationKey("command", "modifiers.success.remove.multiple");
    private static final DynamicCommandExceptionType MODIFIER_ERROR = new DynamicCommandExceptionType(error -> (class_2561)error);
    private static final Dynamic2CommandExceptionType CANNOT_REMOVE = new Dynamic2CommandExceptionType((name, entity) -> TConstruct.makeTranslation("command", "modifiers.failure.too_few_levels", name, entity));

    public static void register(LiteralArgumentBuilder<class_2168> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9247((String)"add").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"modifier", (ArgumentType)ModifierArgument.modifier()).executes(context -> ModifiersCommand.add((CommandContext<class_2168>)context, 1))).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ModifiersCommand.add((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))))).then(class_2170.method_9247((String)"remove").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"modifier", (ArgumentType)ModifierArgument.modifier()).executes(context -> ModifiersCommand.remove((CommandContext<class_2168>)context, -1))).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ModifiersCommand.remove((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))));
    }

    private static int add(CommandContext<class_2168> context, int level) throws CommandSyntaxException {
        Modifier modifier = ModifierArgument.getModifier(context, "modifier");
        List<class_1309> successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            ToolStack tool = ToolStack.from(stack);
            int currentLevel = tool.getModifierLevel(modifier);
            List<ModifierEntry> modifiers = tool.getModifierList();
            for (ModifierRequirements requirements : ModifierRecipeLookup.getRequirements(modifier.getId())) {
                ValidatedResult result = requirements.check(stack, level + currentLevel, modifiers);
                if (!result.hasError()) continue;
                throw MODIFIER_ERROR.create((Object)result.getMessage());
            }
            tool = tool.copy();
            tool.addModifier(modifier.getId(), level);
            ValidatedResult toolValidation = tool.validate();
            if (toolValidation.hasError()) {
                throw MODIFIER_ERROR.create((Object)toolValidation.getMessage());
            }
            living.method_6122(class_1268.field_5808, tool.createStack(stack.method_7947()));
            return true;
        });
        class_2168 source = (class_2168)context.getSource();
        int size = successes.size();
        if (size == 1) {
            source.method_9226((class_2561)new class_2588(ADD_SUCCESS, new Object[]{modifier.getDisplayName(level), successes.get(0).method_5476()}), true);
        } else {
            source.method_9226((class_2561)new class_2588(ADD_SUCCESS_MULTIPLE, new Object[]{modifier.getDisplayName(level), size}), true);
        }
        return size;
    }

    private static int remove(CommandContext<class_2168> context, int level) throws CommandSyntaxException {
        Modifier modifier = ModifierArgument.getModifier(context, "modifier");
        MutableInt maxRemove = new MutableInt(1);
        List<class_1309> successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            int removeLevel;
            ToolStack tool = ToolStack.from(stack);
            int currentLevel = tool.getUpgrades().getLevel(modifier.getId());
            if (currentLevel == 0) {
                throw CANNOT_REMOVE.create((Object)modifier.getDisplayName(level), (Object)living.method_5477());
            }
            int n = removeLevel = level == -1 ? currentLevel : level;
            if (removeLevel > maxRemove.intValue()) {
                maxRemove.setValue(removeLevel);
            }
            tool = tool.copy();
            int newLevel = currentLevel - removeLevel;
            if (newLevel <= 0) {
                modifier.beforeRemoved(tool, tool.getRestrictedNBT());
            }
            tool.removeModifier(modifier.getId(), removeLevel);
            ValidatedResult validated = tool.validate();
            if (validated.hasError()) {
                throw MODIFIER_ERROR.create((Object)validated.getMessage());
            }
            if (newLevel <= 0) {
                modifier.onRemoved(tool);
            }
            if (newLevel <= 0 && (validated = modifier.validate(tool, 0)).hasError()) {
                throw MODIFIER_ERROR.create((Object)validated.getMessage());
            }
            class_1799 resultStack = tool.createStack(stack.method_7947());
            validated = ModifierRecipeLookup.checkRequirements(resultStack, tool);
            if (validated.hasError()) {
                throw MODIFIER_ERROR.create((Object)validated.getMessage());
            }
            living.method_6122(class_1268.field_5808, tool.createStack(stack.method_7947()));
            return true;
        });
        class_2168 source = (class_2168)context.getSource();
        int size = successes.size();
        if (size == 1) {
            source.method_9226((class_2561)new class_2588(REMOVE_SUCCESS, new Object[]{modifier.getDisplayName(maxRemove.intValue()), successes.get(0).method_5476()}), true);
        } else {
            source.method_9226((class_2561)new class_2588(REMOVE_SUCCESS_MULTIPLE, new Object[]{modifier.getDisplayName(maxRemove.intValue()), size}), true);
        }
        return size;
    }
}

