/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.command.HeldModifiableItemIterator;
import slimeknights.tconstruct.shared.command.argument.SlotTypeArgument;

public class SlotsCommand {
    private static final String ADD_SUCCESS = TConstruct.makeTranslationKey("command", "slots.success.add.single");
    private static final String ADD_SUCCESS_MULTIPLE = TConstruct.makeTranslationKey("command", "slots.success.add.multiple");
    private static final String SET_SUCCESS = TConstruct.makeTranslationKey("command", "slots.success.set.single");
    private static final String SET_SUCCESS_MULTIPLE = TConstruct.makeTranslationKey("command", "slots.success.set.multiple");
    private static final SimpleCommandExceptionType INVALID_SLOT_COUNT = new SimpleCommandExceptionType((Message)TConstruct.makeTranslation("command", "slots.failure.invalid_count"));
    private static final DynamicCommandExceptionType VALIDATION_ERROR = new DynamicCommandExceptionType(error -> (class_2561)error);

    public static void register(LiteralArgumentBuilder<class_2168> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9247((String)"add").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"slot_type", (ArgumentType)SlotTypeArgument.slotType(false)).executes(context -> SlotsCommand.run((CommandContext<class_2168>)context, Operation.ADD, 1))).then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(context -> SlotsCommand.run((CommandContext<class_2168>)context, Operation.ADD)))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"slot_type", (ArgumentType)SlotTypeArgument.slotType(false)).then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> SlotsCommand.run((CommandContext<class_2168>)context, Operation.SET))))));
    }

    private static int run(CommandContext<class_2168> context, Operation op) throws CommandSyntaxException {
        return SlotsCommand.run(context, op, IntegerArgumentType.getInteger(context, (String)"count"));
    }

    private static int run(CommandContext<class_2168> context, Operation op, int count) throws CommandSyntaxException {
        if (count == 0 && op != Operation.SET) {
            throw INVALID_SLOT_COUNT.create();
        }
        SlotType slotType = SlotTypeArgument.getSlotType(context, "slot_type");
        List<class_1309> successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            ToolStack tool = ToolStack.copyFrom(stack);
            ModDataNBT slots = tool.getPersistentData();
            if (op == Operation.ADD) {
                slots.addSlots(slotType, count);
            } else {
                slots.addSlots(slotType, count - tool.getFreeSlots(slotType));
            }
            tool.rebuildStats();
            ValidatedResult toolValidation = tool.validate();
            if (toolValidation.hasError()) {
                throw VALIDATION_ERROR.create((Object)toolValidation.getMessage());
            }
            living.method_6122(class_1268.field_5808, tool.createStack(stack.method_7947()));
            return true;
        });
        class_2168 source = (class_2168)context.getSource();
        int size = successes.size();
        if (op == Operation.ADD) {
            if (size == 1) {
                source.method_9226((class_2561)new class_2588(ADD_SUCCESS, new Object[]{count, slotType.getDisplayName(), successes.get(0).method_5476()}), true);
            } else {
                source.method_9226((class_2561)new class_2588(ADD_SUCCESS_MULTIPLE, new Object[]{count, slotType.getDisplayName(), size}), true);
            }
        } else if (size == 1) {
            source.method_9226((class_2561)new class_2588(SET_SUCCESS, new Object[]{slotType.getDisplayName(), count, successes.get(0).method_5476()}), true);
        } else {
            source.method_9226((class_2561)new class_2588(SET_SUCCESS_MULTIPLE, new Object[]{slotType.getDisplayName(), count, size}), true);
        }
        return size;
    }

    private static enum Operation {
        ADD,
        SET;

    }
}

