/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import slimeknights.mantle.transfer.TransferUtil;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.entity.ChannelBlockEntity;

public class ChannelBlock
extends class_2248
implements class_2343 {
    private static final class_2561 SIDE_IN;
    private static final class_2561 SIDE_OUT;
    private static final class_2561 SIDE_NONE;
    private static final class_2561 DOWN_OUT;
    private static final class_2561 DOWN_NONE;
    private static final Map<ChannelConnection, class_2561> SIDE_CONNECTION;
    public static final class_2746 DOWN;
    public static final class_2746 POWERED;
    public static final class_2754<ChannelConnection> NORTH;
    public static final class_2754<ChannelConnection> SOUTH;
    public static final class_2754<ChannelConnection> WEST;
    public static final class_2754<ChannelConnection> EAST;
    public static final Map<class_2350, class_2754<ChannelConnection>> DIRECTION_MAP;
    private static final Map<class_2350, class_265> SIDE_BOUNDS;
    private static final class_265[] BOUNDS;

    private static int makeKey(boolean down, boolean north, boolean south, boolean west, boolean east) {
        return (down ? 1 : 0) | (north ? 2 : 0) | (south ? 4 : 0) | (west ? 8 : 0) | (east ? 16 : 0);
    }

    public ChannelBlock(class_4970.class_2251 props) {
        super(props);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false))).method_11657(NORTH, (Comparable)((Object)ChannelConnection.NONE))).method_11657(SOUTH, (Comparable)((Object)ChannelConnection.NONE))).method_11657(WEST, (Comparable)((Object)ChannelConnection.NONE))).method_11657(EAST, (Comparable)((Object)ChannelConnection.NONE)));
    }

    @Deprecated
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return BOUNDS[ChannelBlock.makeKey((Boolean)state.method_11654((class_2769)DOWN), ((ChannelConnection)((Object)state.method_11654(NORTH))).canFlow(), ((ChannelConnection)((Object)state.method_11654(SOUTH))).canFlow(), ((ChannelConnection)((Object)state.method_11654(WEST))).canFlow(), ((ChannelConnection)((Object)state.method_11654(EAST))).canFlow())];
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{DOWN, POWERED});
        DIRECTION_MAP.values().forEach(xva$0 -> builder.method_11667(new class_2769[]{xva$0}));
    }

    public boolean method_9516(class_2680 state, class_1922 worldIn, class_2338 pos, class_10 type) {
        return false;
    }

    private static boolean isFluidHandler(class_1936 world, class_2350 side, class_2338 pos) {
        class_2586 te = world.method_8321(pos);
        return te != null && TransferUtil.getFluidHandler((class_2586)te, (class_2350)side).isPresent();
    }

    private boolean canConnect(class_1936 world, class_2350 side, class_2680 facingState, class_2338 facingPos) {
        if (facingState.method_26204() == this) {
            return true;
        }
        return ChannelBlock.isFluidHandler(world, side.method_10153(), facingPos);
    }

    private boolean canConnect(class_1936 world, class_2338 pos, class_2350 side) {
        class_2338 facingPos = pos.method_10093(side);
        return this.canConnect(world, side, world.method_8320(facingPos), facingPos);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(world.method_8479(pos)));
        class_2350 side = context.method_8038();
        if (side == class_2350.field_11033) {
            return state;
        }
        if (side == class_2350.field_11036) {
            return (class_2680)state.method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(this.canConnect((class_1936)world, pos, class_2350.field_11033)));
        }
        ChannelConnection connection = ChannelConnection.NONE;
        class_2338 placedOn = pos.method_10093(side.method_10153());
        if (world.method_8320(placedOn).method_27852((class_2248)this)) {
            class_1657 player = context.method_8036();
            connection = player != null && player.method_5715() ? ChannelConnection.IN : ChannelConnection.OUT;
        } else if (ChannelBlock.isFluidHandler((class_1936)world, side, placedOn)) {
            connection = ChannelConnection.OUT;
        }
        return (class_2680)state.method_11657((class_2769)DIRECTION_MAP.get(side.method_10153()), (Comparable)((Object)connection));
    }

    @Deprecated
    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 world, class_2338 currentPos, class_2338 facingPos) {
        if (facing == class_2350.field_11033) {
            if (((Boolean)state.method_11654((class_2769)DOWN)).booleanValue() && facingState.method_26215()) {
                state = (class_2680)state.method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false));
            }
            return state;
        }
        if (facing != class_2350.field_11036) {
            class_2754<ChannelConnection> prop = DIRECTION_MAP.get(facing);
            if (facingState.method_27852((class_2248)this)) {
                state = (class_2680)state.method_11657(prop, (Comparable)((Object)((ChannelConnection)((Object)facingState.method_11654((class_2769)DIRECTION_MAP.get(facing.method_10153())))).getOpposite()));
            } else {
                ChannelConnection connection = (ChannelConnection)((Object)state.method_11654(prop));
                if (connection != ChannelConnection.NONE && facingState.method_26215()) {
                    state = (class_2680)state.method_11657(prop, (Comparable)((Object)ChannelConnection.NONE));
                }
            }
        }
        return state;
    }

    @Nullable
    private class_2680 interactWithSide(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_2350 side) {
        if (side == class_2350.field_11033) {
            if (!((Boolean)state.method_11654((class_2769)DOWN)).booleanValue() && this.canConnect((class_1936)world, pos, side)) {
                player.method_7353(DOWN_OUT, true);
                return (class_2680)state.method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(true));
            }
            if (((Boolean)state.method_11654((class_2769)DOWN)).booleanValue()) {
                player.method_7353(DOWN_NONE, true);
                return (class_2680)state.method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false));
            }
        } else {
            class_2754<ChannelConnection> prop = DIRECTION_MAP.get(side);
            ChannelConnection connection = (ChannelConnection)((Object)state.method_11654(prop));
            class_2338 facingPos = pos.method_10093(side);
            class_2680 facingState = world.method_8320(facingPos);
            ChannelConnection newConnect = connection.getNext(player.method_5715());
            if (newConnect == ChannelConnection.OUT && facingState.method_26204() != this && !ChannelBlock.isFluidHandler((class_1936)world, side.method_10153(), facingPos)) {
                newConnect = newConnect.getNext(player.method_5715());
            }
            player.method_7353(SIDE_CONNECTION.get((Object)newConnect), true);
            return (class_2680)state.method_11657(prop, (Comparable)((Object)newConnect));
        }
        return null;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_243 hitVec;
        class_2350 side;
        class_2350 hitFace = hit.method_17780();
        if (player.method_5998(hand).method_7909() == this.method_8389() && world.method_22347(pos.method_10093(hitFace))) {
            return class_1269.field_5811;
        }
        class_2350 class_23502 = side = hitFace == class_2350.field_11036 ? class_2350.field_11033 : hitFace;
        if (player.method_5715() && side != class_2350.field_11033) {
            side = side.method_10153();
        }
        if ((hitVec = hit.method_17784().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260())).method_10215() < 0.25) {
            side = class_2350.field_11043;
        } else if (hitVec.method_10215() > 0.75) {
            side = class_2350.field_11035;
        } else if (hitVec.method_10216() < 0.25) {
            side = class_2350.field_11039;
        } else if (hitVec.method_10216() > 0.75) {
            side = class_2350.field_11034;
        }
        class_2680 newState = this.interactWithSide(state, world, pos, player, side);
        if (newState != null) {
            class_2350 finalSide = side;
            if (!world.field_9236) {
                BlockEntityHelper.get(ChannelBlockEntity.class, (class_1922)world, (class_2338)pos).ifPresent(te -> te.refreshNeighbor(newState, finalSide));
            }
            world.method_8501(pos, newState);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Deprecated
    public void method_9612(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        super.method_9612(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (!worldIn.field_9236) {
            boolean isPowered = worldIn.method_8479(pos);
            if (isPowered != (Boolean)state.method_11654((class_2769)POWERED)) {
                state = (class_2680)((class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(isPowered))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(isPowered && this.canConnect((class_1936)worldIn, pos, class_2350.field_11033)));
                worldIn.method_8652(pos, state, 2);
            }
            BlockEntityHelper.get(ChannelBlockEntity.class, (class_1922)worldIn, (class_2338)pos).ifPresent(te -> te.removeCachedNeighbor(Util.directionFromOffset(pos, fromPos)));
        }
    }

    @Deprecated
    public boolean method_9522(class_2680 state, class_2680 adjacentBlockState, class_2350 side) {
        return side.method_10166().method_10179() && adjacentBlockState.method_27852((class_2248)this) && ((ChannelConnection)((Object)state.method_11654((class_2769)DIRECTION_MAP.get(side)))).canFlow() && ((ChannelConnection)((Object)adjacentBlockState.method_11654((class_2769)DIRECTION_MAP.get(side.method_10153())))).canFlow();
    }

    @Nullable
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return new ChannelBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 pLevel, class_2680 pState, class_2591<T> givenType) {
        return pLevel.field_9236 ? null : BlockEntityHelper.castTicker(givenType, (class_2591)((class_2591)TinkerSmeltery.channel.get()), ChannelBlockEntity.SERVER_TICKER);
    }

    static {
        boolean[] bools;
        SIDE_IN = TConstruct.makeTranslation("block", "channel.side.in");
        SIDE_OUT = TConstruct.makeTranslation("block", "channel.side.out");
        SIDE_NONE = TConstruct.makeTranslation("block", "channel.side.none");
        DOWN_OUT = TConstruct.makeTranslation("block", "channel.down.out");
        DOWN_NONE = TConstruct.makeTranslation("block", "channel.down.none");
        SIDE_CONNECTION = Util.make(new EnumMap(ChannelConnection.class), map -> {
            map.put(ChannelConnection.IN, SIDE_IN);
            map.put(ChannelConnection.OUT, SIDE_OUT);
            map.put(ChannelConnection.NONE, SIDE_NONE);
        });
        DOWN = class_2741.field_12546;
        POWERED = class_2741.field_12484;
        NORTH = class_2754.method_11850((String)"north", ChannelConnection.class);
        SOUTH = class_2754.method_11850((String)"south", ChannelConnection.class);
        WEST = class_2754.method_11850((String)"west", ChannelConnection.class);
        EAST = class_2754.method_11850((String)"east", ChannelConnection.class);
        DIRECTION_MAP = Util.make(new EnumMap(class_2350.class), map -> {
            map.put(class_2350.field_11043, NORTH);
            map.put(class_2350.field_11035, SOUTH);
            map.put(class_2350.field_11039, WEST);
            map.put(class_2350.field_11034, EAST);
        });
        SIDE_BOUNDS = Util.make(new EnumMap(class_2350.class), map -> {
            map.put(class_2350.field_11043, class_259.method_1072((class_265)ChannelBlock.method_9541((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)9.0, (double)4.0), (class_265)ChannelBlock.method_9541((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)9.0, (double)4.0), (class_247)class_247.field_16886));
            map.put(class_2350.field_11035, class_259.method_1072((class_265)ChannelBlock.method_9541((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)9.0, (double)16.0), (class_265)ChannelBlock.method_9541((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)9.0, (double)16.0), (class_247)class_247.field_16886));
            map.put(class_2350.field_11039, class_259.method_1072((class_265)ChannelBlock.method_9541((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)9.0, (double)12.0), (class_265)ChannelBlock.method_9541((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)9.0, (double)10.0), (class_247)class_247.field_16886));
            map.put(class_2350.field_11034, class_259.method_1072((class_265)ChannelBlock.method_9541((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)9.0, (double)12.0), (class_265)ChannelBlock.method_9541((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)9.0, (double)10.0), (class_247)class_247.field_16886));
        });
        class_265 centerUnconnected = class_259.method_1082((class_265)ChannelBlock.method_9541((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (class_265)class_259.method_1084((class_265)ChannelBlock.method_9541((double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)9.0, (double)12.0), (class_265)ChannelBlock.method_9541((double)4.0, (double)6.0, (double)6.0, (double)12.0, (double)9.0, (double)10.0)), (class_247)class_247.field_16886);
        class_265 centerConnected = class_259.method_1082((class_265)ChannelBlock.method_9541((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (class_265)class_259.method_17786((class_265)ChannelBlock.method_9541((double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)9.0, (double)12.0), (class_265[])new class_265[]{ChannelBlock.method_9541((double)4.0, (double)6.0, (double)6.0, (double)12.0, (double)9.0, (double)10.0), ChannelBlock.method_9541((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0)}), (class_247)class_247.field_16886);
        class_265 northWall = ChannelBlock.method_9541((double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)9.0, (double)6.0);
        class_265 southWall = ChannelBlock.method_9541((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)9.0, (double)12.0);
        class_265 westWall = ChannelBlock.method_9541((double)4.0, (double)6.0, (double)6.0, (double)6.0, (double)9.0, (double)10.0);
        class_265 eastWall = ChannelBlock.method_9541((double)10.0, (double)6.0, (double)6.0, (double)12.0, (double)9.0, (double)10.0);
        BOUNDS = new class_265[32];
        for (boolean down : bools = new boolean[]{false, true}) {
            class_265 center = down ? centerConnected : centerUnconnected;
            for (boolean north : bools) {
                class_265 northBounds = north ? SIDE_BOUNDS.get(class_2350.field_11043) : northWall;
                for (boolean south : bools) {
                    class_265 southBounds = south ? SIDE_BOUNDS.get(class_2350.field_11035) : southWall;
                    for (boolean west : bools) {
                        class_265 westBounds = west ? SIDE_BOUNDS.get(class_2350.field_11039) : westWall;
                        for (boolean east : bools) {
                            class_265 eastBounds = east ? SIDE_BOUNDS.get(class_2350.field_11034) : eastWall;
                            ChannelBlock.BOUNDS[ChannelBlock.makeKey((boolean)down, (boolean)north, (boolean)south, (boolean)west, (boolean)east)] = class_259.method_17786((class_265)center, (class_265[])new class_265[]{northBounds, southBounds, westBounds, eastBounds});
                        }
                    }
                }
            }
        }
    }

    public static enum ChannelConnection implements class_3542
    {
        NONE,
        IN,
        OUT;


        public String method_15434() {
            return this.toString().toLowerCase(Locale.US);
        }

        public boolean canFlow() {
            return this == IN || this == OUT;
        }

        public ChannelConnection getOpposite() {
            return switch (this) {
                case IN -> OUT;
                case OUT -> IN;
                default -> NONE;
            };
        }

        public ChannelConnection getNext(boolean reverse) {
            if (reverse) {
                return switch (this) {
                    default -> throw new IncompatibleClassChangeError();
                    case NONE -> OUT;
                    case OUT -> IN;
                    case IN -> NONE;
                };
            }
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NONE -> IN;
                case IN -> OUT;
                case OUT -> NONE;
            };
        }
    }
}

