/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity;

import io.github.fabricators_of_create.porting_lib.block.CustomRenderBoundingBoxBlockEntity;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import io.github.fabricators_of_create.porting_lib.util.NonNullConsumer;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_156;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_5558;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.transfer.TransferUtil;
import slimeknights.mantle.transfer.fluid.EmptyFluidHandler;
import slimeknights.mantle.transfer.fluid.FluidTransferable;
import slimeknights.mantle.transfer.fluid.IFluidHandler;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.fluid.FillOnlyFluidHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.ChannelBlock;
import slimeknights.tconstruct.smeltery.block.entity.tank.ChannelSideTank;
import slimeknights.tconstruct.smeltery.block.entity.tank.ChannelTank;
import slimeknights.tconstruct.smeltery.network.ChannelFlowPacket;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;

public class ChannelBlockEntity
extends MantleBlockEntity
implements FluidUpdatePacket.IFluidPacketReceiver,
FluidTransferable,
CustomRenderBoundingBoxBlockEntity {
    private final ChannelTank tank = new ChannelTank(2430, this);
    private final LazyOptional<IFluidHandler> topHandler = LazyOptional.of(() -> new FillOnlyFluidHandler((IFluidHandler)this.tank));
    private final Map<class_2350, IFluidHandler> sideTanks = (Map)class_156.method_654(new EnumMap(class_2350.class), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            map.put(direction, new ChannelSideTank(this, this.tank, direction));
        }
    });
    private final Map<class_2350, LazyOptional<IFluidHandler>> sideHandlers = new EnumMap<class_2350, LazyOptional<IFluidHandler>>(class_2350.class);
    private final Map<class_2350, LazyOptional<IFluidHandler>> emptySideHandler = new EnumMap<class_2350, LazyOptional<IFluidHandler>>(class_2350.class);
    private final Map<class_2350, LazyOptional<IFluidHandler>> neighborTanks = new EnumMap<class_2350, LazyOptional<IFluidHandler>>(class_2350.class);
    private final Map<class_2350, NonNullConsumer<LazyOptional<IFluidHandler>>> neighborConsumers = new EnumMap<class_2350, NonNullConsumer<LazyOptional<IFluidHandler>>>(class_2350.class);
    public static final class_5558<ChannelBlockEntity> SERVER_TICKER = (level, pos, state, self) -> self.tick(state);
    private final byte[] isFlowing = new byte[5];
    private static final String TAG_IS_FLOWING = "is_flowing";
    private static final String TAG_TANK = "tank";

    public ChannelBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)TinkerSmeltery.channel.get(), pos, state);
    }

    protected ChannelBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public class_238 getRenderBoundingBox() {
        return new class_238((double)this.field_11867.method_10263(), (double)(this.field_11867.method_10264() - 1), (double)this.field_11867.method_10260(), (double)(this.field_11867.method_10263() + 1), (double)(this.field_11867.method_10264() + 1), (double)(this.field_11867.method_10260() + 1));
    }

    private void invalidateSide(class_2350 side, LazyOptional<IFluidHandler> capability) {
        if (!this.method_11015() && this.neighborTanks.get(side) == capability) {
            this.neighborTanks.remove(side);
        }
    }

    public LazyOptional<IFluidHandler> getFluidHandler(@Nullable class_2350 side) {
        if (side == null || side == class_2350.field_11036) {
            return this.topHandler.cast();
        }
        if (side != class_2350.field_11033) {
            ChannelBlock.ChannelConnection connection = (ChannelBlock.ChannelConnection)((Object)this.method_11010().method_11654((class_2769)ChannelBlock.DIRECTION_MAP.get(side)));
            if (connection == ChannelBlock.ChannelConnection.IN) {
                return this.sideHandlers.computeIfAbsent(side, s -> LazyOptional.of(() -> this.sideTanks.get(s))).cast();
            }
            if (connection == ChannelBlock.ChannelConnection.OUT) {
                return this.emptySideHandler.computeIfAbsent(side, s -> LazyOptional.of(() -> EmptyFluidHandler.INSTANCE)).cast();
            }
        }
        return null;
    }

    private LazyOptional<IFluidHandler> getNeighborHandlerUncached(class_2350 side) {
        LazyOptional handler;
        assert (this.field_11863 != null);
        class_2586 te = this.field_11863.method_8321(this.field_11867.method_10093(side));
        if (te != null && (handler = TransferUtil.getFluidHandler((class_2586)te, (class_2350)side.method_10153())).isPresent()) {
            handler.addListener(this.neighborConsumers.computeIfAbsent(side, s -> new WeakConsumerWrapper((Object)this, (self, lazy) -> self.invalidateSide((class_2350)s, (LazyOptional<IFluidHandler>)lazy))));
            return handler;
        }
        return LazyOptional.empty();
    }

    protected LazyOptional<IFluidHandler> getNeighborHandler(class_2350 side) {
        return this.neighborTanks.computeIfAbsent(side, this::getNeighborHandlerUncached);
    }

    public void removeCachedNeighbor(class_2350 side) {
        this.neighborTanks.remove(side);
    }

    public void refreshNeighbor(class_2680 state, class_2350 side) {
        if (side == class_2350.field_11033) {
            if (!((Boolean)state.method_11654((class_2769)ChannelBlock.DOWN)).booleanValue()) {
                this.neighborTanks.remove(class_2350.field_11033);
            }
        } else if (side != class_2350.field_11036) {
            LazyOptional<IFluidHandler> handler;
            ChannelBlock.ChannelConnection connection = (ChannelBlock.ChannelConnection)((Object)state.method_11654((class_2769)ChannelBlock.DIRECTION_MAP.get(side)));
            if (connection != ChannelBlock.ChannelConnection.OUT) {
                this.neighborTanks.remove(class_2350.field_11033);
                handler = this.emptySideHandler.remove(side);
                if (handler != null) {
                    handler.invalidate();
                }
            }
            if (connection != ChannelBlock.ChannelConnection.IN && (handler = this.sideHandlers.remove(side)) != null) {
                handler.invalidate();
            }
        }
    }

    public void invalidateCaps() {
        this.topHandler.invalidate();
        for (LazyOptional<IFluidHandler> handler : this.sideHandlers.values()) {
            if (handler == null) continue;
            handler.invalidate();
        }
        for (LazyOptional<IFluidHandler> handler : this.emptySideHandler.values()) {
            if (handler == null) continue;
            handler.invalidate();
        }
    }

    private int getFlowIndex(class_2350 side) {
        if (side.method_10166().method_10178()) {
            return 0;
        }
        return side.method_10146() - 1;
    }

    public void setFlow(class_2350 side, boolean flowing) {
        if (side == class_2350.field_11036) {
            return;
        }
        int index = this.getFlowIndex(side);
        boolean wasFlowing = this.isFlowing[index] > 0;
        this.isFlowing[index] = (byte)(flowing ? 2 : 0);
        if (wasFlowing != flowing && this.field_11863 != null && !this.field_11863.field_9236) {
            this.syncFlowToClient(side, flowing);
        }
    }

    public boolean isFlowing(class_2350 side) {
        if (side == class_2350.field_11036) {
            return false;
        }
        return this.isFlowing[this.getFlowIndex(side)] > 0;
    }

    protected boolean isOutput(class_2350 side) {
        if (side == class_2350.field_11036) {
            return false;
        }
        if (side == class_2350.field_11033) {
            return (Boolean)this.method_11010().method_11654((class_2769)ChannelBlock.DOWN);
        }
        return this.method_11010().method_11654((class_2769)ChannelBlock.DIRECTION_MAP.get(side)) == ChannelBlock.ChannelConnection.OUT;
    }

    private static int countOutputs(class_2680 state) {
        int count = 0;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            if (state.method_11654((class_2769)ChannelBlock.DIRECTION_MAP.get(direction)) != ChannelBlock.ChannelConnection.OUT) continue;
            ++count;
        }
        return count;
    }

    private void syncFlowToClient(class_2350 side, boolean flowing) {
        TinkerNetwork.getInstance().sendToClientsAround((S2CPacket)new ChannelFlowPacket(this.field_11867, side, flowing), (class_1936)this.field_11863, this.field_11867);
    }

    private void tick(class_2680 state) {
        FluidStack fluid = this.tank.getFluid();
        if (!fluid.isEmpty()) {
            boolean hasFlown = false;
            if (((Boolean)state.method_11654((class_2769)ChannelBlock.DOWN)).booleanValue()) {
                hasFlown = this.trySide(class_2350.field_11033, 810L);
            }
            int outputs = ChannelBlockEntity.countOutputs(state);
            if (!hasFlown && outputs > 0) {
                long flowRate = class_3532.method_24156((long)(this.tank.getMaxUsable() / (long)outputs), (long)1L, (long)810L);
                for (class_2350 side : class_2350.class_2353.field_11062) {
                    this.trySide(side, flowRate);
                }
            }
        }
        for (int i = 0; i < 5; ++i) {
            if (this.isFlowing[i] <= 0) continue;
            int n = i;
            this.isFlowing[n] = (byte)(this.isFlowing[n] - 1);
            if (this.isFlowing[i] != 0) continue;
            class_2350 direction = i == 0 ? class_2350.field_11033 : class_2350.method_10143((int)(i + 1));
            this.syncFlowToClient(direction, false);
        }
        this.tank.freeFluid();
    }

    protected boolean trySide(class_2350 side, long flowRate) {
        if (this.tank.isEmpty() || !this.isOutput(side)) {
            return false;
        }
        return this.getNeighborHandler(side).filter(handler -> this.fill(side, (IFluidHandler)handler, flowRate)).isPresent();
    }

    protected boolean fill(class_2350 side, IFluidHandler handler, long amount) {
        FluidStack fluid;
        long filled;
        long usable = Math.min(this.tank.getMaxUsable(), amount);
        if (usable > 0L && (filled = handler.fill(fluid = this.tank.drain(usable, true), true)) > 0L) {
            fluid = this.tank.drain(filled, false);
            handler.fill(fluid, false);
            this.setFlow(side, true);
            return true;
        }
        this.setFlow(side, false);
        return false;
    }

    public void sendFluidUpdate() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            TinkerNetwork.getInstance().sendToClientsAround((S2CPacket)new FluidUpdatePacket(this.field_11867, this.getFluid()), (class_1936)this.field_11863, this.field_11867);
        }
    }

    @Override
    public void updateFluidTo(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    protected void saveSynced(class_2487 nbt) {
        super.saveSynced(nbt);
        nbt.method_10570(TAG_IS_FLOWING, this.isFlowing);
        nbt.method_10566(TAG_TANK, (class_2520)this.tank.writeToNBT(new class_2487()));
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545(TAG_IS_FLOWING)) {
            byte[] nbtFlowing = nbt.method_10547(TAG_IS_FLOWING);
            int max = Math.min(5, nbtFlowing.length);
            for (int i = 0; i < max; ++i) {
                int b = nbtFlowing[i];
                this.isFlowing[i] = b > 2 ? 2 : (b < 0 ? 0 : b);
            }
        }
        class_2487 tankTag = nbt.method_10562(TAG_TANK);
        this.tank.readFromNBT(tankTag);
    }
}

