/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity;

import io.github.fabricators_of_create.porting_lib.block.CustomRenderBoundingBoxBlockEntity;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import io.github.fabricators_of_create.porting_lib.util.NonNullConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5558;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.transfer.TransferUtil;
import slimeknights.mantle.transfer.fluid.EmptyFluidHandler;
import slimeknights.mantle.transfer.fluid.IFluidHandler;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.FaucetBlock;
import slimeknights.tconstruct.smeltery.network.FaucetActivationPacket;

public class FaucetBlockEntity
extends MantleBlockEntity
implements CustomRenderBoundingBoxBlockEntity {
    public static final long PACKET_SIZE = 9000L;
    public static final int DROPLETS_PER_TICK = 810;
    public static final class_5558<FaucetBlockEntity> SERVER_TICKER = (level, pos, world, self) -> self.tick();
    private static final String TAG_DRAINED = "drained";
    private static final String TAG_RENDER_FLUID = "render_fluid";
    private static final String TAG_STOP = "stop";
    private static final String TAG_STATE = "state";
    private static final String TAG_LAST_REDSTONE = "lastRedstone";
    private FaucetState faucetState = FaucetState.OFF;
    private boolean stopPouring = false;
    private FluidStack drained = FluidStack.EMPTY;
    private FluidStack renderFluid = FluidStack.EMPTY;
    private boolean lastRedstoneState = false;
    private LazyOptional<IFluidHandler> inputHandler;
    private LazyOptional<IFluidHandler> outputHandler;
    private final NonNullConsumer<LazyOptional<IFluidHandler>> inputListener = new WeakConsumerWrapper((Object)this, (self, handler) -> {
        self.inputHandler = null;
    });
    private final NonNullConsumer<LazyOptional<IFluidHandler>> outputListener = new WeakConsumerWrapper((Object)this, (self, handler) -> {
        self.outputHandler = null;
    });

    public FaucetBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)TinkerSmeltery.faucet.get(), pos, state);
    }

    protected FaucetBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    private LazyOptional<IFluidHandler> findFluidHandler(class_2350 side) {
        LazyOptional handler;
        assert (this.field_11863 != null);
        class_2586 te = this.field_11863.method_8321(this.field_11867.method_10093(side));
        if (te != null && (handler = TransferUtil.getFluidHandler((class_2586)te, (class_2350)side.method_10153())).isPresent()) {
            return handler;
        }
        return LazyOptional.empty();
    }

    private LazyOptional<IFluidHandler> getInputHandler() {
        if (this.inputHandler == null) {
            this.inputHandler = this.findFluidHandler(((class_2350)this.method_11010().method_11654((class_2769)FaucetBlock.FACING)).method_10153());
            if (this.inputHandler.isPresent()) {
                this.inputHandler.addListener(this.inputListener);
            }
        }
        return this.inputHandler;
    }

    private LazyOptional<IFluidHandler> getOutputHandler() {
        if (this.outputHandler == null) {
            this.outputHandler = this.findFluidHandler(class_2350.field_11033);
            if (this.outputHandler.isPresent()) {
                this.outputHandler.addListener(this.outputListener);
            }
        }
        return this.outputHandler;
    }

    public void neighborChanged(class_2338 neighbor) {
        if (this.field_11867.equals((Object)neighbor.method_10084())) {
            this.outputHandler = null;
        } else if (this.field_11867.equals((Object)neighbor.method_10093((class_2350)this.method_11010().method_11654((class_2769)FaucetBlock.FACING)))) {
            this.inputHandler = null;
        }
    }

    public boolean isPouring() {
        return this.faucetState != FaucetState.OFF;
    }

    public void activate() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        switch (this.faucetState) {
            case OFF: {
                this.stopPouring = false;
                this.doTransfer(true);
                break;
            }
            case POWERED: {
                this.faucetState = FaucetState.OFF;
                this.syncToClient(FluidStack.EMPTY, false);
                break;
            }
            case POURING: {
                this.stopPouring = true;
            }
        }
    }

    public void handleRedstone(boolean hasSignal) {
        if (hasSignal != this.lastRedstoneState) {
            this.lastRedstoneState = hasSignal;
            if (hasSignal) {
                if (this.field_11863 != null) {
                    this.field_11863.method_39279(this.field_11867, this.method_11010().method_26204(), 2);
                }
            } else if (this.faucetState == FaucetState.POWERED) {
                this.faucetState = FaucetState.OFF;
                this.syncToClient(FluidStack.EMPTY, false);
            }
        }
    }

    private void tick() {
        if (this.faucetState == FaucetState.OFF) {
            return;
        }
        if (this.faucetState == FaucetState.POWERED && this.doTransfer(false)) {
            this.faucetState = FaucetState.POURING;
            return;
        }
        if (!this.drained.isEmpty()) {
            this.pour();
        } else if (this.stopPouring) {
            this.reset();
        } else {
            this.doTransfer(true);
        }
    }

    private boolean doTransfer(boolean execute) {
        LazyOptional<IFluidHandler> inputOptional = this.getInputHandler();
        LazyOptional<IFluidHandler> outputOptional = this.getOutputHandler();
        if (inputOptional.isPresent() && outputOptional.isPresent()) {
            IFluidHandler output;
            long filled;
            IFluidHandler input = (IFluidHandler)inputOptional.orElse((Object)EmptyFluidHandler.INSTANCE);
            FluidStack drained = input.drain(9000L, true);
            if (!drained.isEmpty() && !drained.getFluid().getAttributes().isGaseous(drained) && (filled = (output = (IFluidHandler)outputOptional.orElse((Object)EmptyFluidHandler.INSTANCE)).fill(drained, true)) > 0L) {
                if (execute) {
                    this.drained = input.drain(filled, false);
                    if (this.faucetState == FaucetState.OFF || !this.renderFluid.isFluidEqual(drained)) {
                        this.syncToClient(this.drained, true);
                    }
                    this.faucetState = FaucetState.POURING;
                    this.pour();
                }
                return true;
            }
            if (this.lastRedstoneState) {
                if (execute && (this.faucetState == FaucetState.OFF || !this.renderFluid.isFluidEqual(FluidStack.EMPTY))) {
                    this.syncToClient(FluidStack.EMPTY, true);
                }
                this.faucetState = FaucetState.POWERED;
                return false;
            }
        }
        if (execute) {
            this.reset();
        }
        return false;
    }

    private void pour() {
        if (this.drained.isEmpty()) {
            return;
        }
        LazyOptional<IFluidHandler> outputOptional = this.getOutputHandler();
        if (outputOptional.isPresent()) {
            FluidStack fillStack = this.drained.copy();
            fillStack.setAmount(Math.min(this.drained.getAmount(), 810L));
            IFluidHandler output = (IFluidHandler)outputOptional.orElse((Object)EmptyFluidHandler.INSTANCE);
            long filled = output.fill(fillStack, true);
            if (filled > 0L) {
                if (!this.renderFluid.isFluidEqual(this.drained)) {
                    this.syncToClient(this.drained, true);
                }
                this.drained.shrink(filled);
                fillStack.setAmount(filled);
                output.fill(fillStack, false);
            }
        } else {
            this.reset();
        }
    }

    private void reset() {
        this.stopPouring = false;
        this.drained = FluidStack.EMPTY;
        if (this.faucetState != FaucetState.OFF || !this.renderFluid.isFluidEqual(this.drained)) {
            this.faucetState = FaucetState.OFF;
            this.syncToClient(FluidStack.EMPTY, false);
        }
    }

    public class_238 getRenderBoundingBox() {
        return new class_238((double)this.field_11867.method_10263(), (double)(this.field_11867.method_10264() - 1), (double)this.field_11867.method_10260(), (double)(this.field_11867.method_10263() + 1), (double)(this.field_11867.method_10264() + 1), (double)(this.field_11867.method_10260() + 1));
    }

    private void syncToClient(FluidStack fluid, boolean isPouring) {
        this.renderFluid = fluid.copy();
        if (this.field_11863 instanceof class_3218) {
            TinkerNetwork.getInstance().sendToClientsAround((ISimplePacket)new FaucetActivationPacket(this.field_11867, fluid, isPouring), (class_3218)this.field_11863, this.method_11016());
        }
    }

    public void onActivationPacket(FluidStack fluid, boolean isPouring) {
        this.faucetState = isPouring ? FaucetState.POURING : FaucetState.OFF;
        this.renderFluid = fluid;
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    protected void saveSynced(class_2487 compound) {
        super.saveSynced(compound);
        compound.method_10567(TAG_STATE, (byte)this.faucetState.ordinal());
        if (!this.renderFluid.isEmpty()) {
            compound.method_10566(TAG_RENDER_FLUID, (class_2520)this.renderFluid.writeToNBT(new class_2487()));
        }
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10556(TAG_STOP, this.stopPouring);
        compound.method_10556(TAG_LAST_REDSTONE, this.lastRedstoneState);
        if (!this.drained.isEmpty()) {
            compound.method_10566(TAG_DRAINED, (class_2520)this.drained.writeToNBT(new class_2487()));
        }
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.faucetState = FaucetState.fromIndex(compound.method_10571(TAG_STATE));
        this.stopPouring = compound.method_10577(TAG_STOP);
        this.lastRedstoneState = compound.method_10577(TAG_LAST_REDSTONE);
        this.drained = compound.method_10573(TAG_DRAINED, 10) ? FluidStack.loadFluidStackFromNBT((class_2487)compound.method_10562(TAG_DRAINED)) : FluidStack.EMPTY;
        this.renderFluid = compound.method_10573(TAG_RENDER_FLUID, 10) ? FluidStack.loadFluidStackFromNBT((class_2487)compound.method_10562(TAG_RENDER_FLUID)) : FluidStack.EMPTY;
    }

    public FluidStack getRenderFluid() {
        return this.renderFluid;
    }

    private static enum FaucetState {
        OFF,
        POURING,
        POWERED;


        public static FaucetState fromIndex(int index) {
            switch (index) {
                case 1: {
                    return POURING;
                }
                case 2: {
                    return POWERED;
                }
            }
            return OFF;
        }
    }
}

