/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity;

import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.block.TankModel;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.library.fluid.IFluidTankUpdater;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;

public interface ITankBlockEntity
extends IFluidTankUpdater,
FluidUpdatePacket.IFluidPacketReceiver {
    public FluidTankAnimated getTank();

    default public int comparatorStrength() {
        FluidTankAnimated tank = this.getTank();
        return (int)(15L * tank.getFluidAmount() / tank.getCapacity());
    }

    public int getLastStrength();

    public void setLastStrength(int var1);

    @Override
    default public void onTankContentsChanged() {
        int newStrength = this.comparatorStrength();
        class_2586 te = this.getTE();
        class_1937 world = te.method_10997();
        if (newStrength != this.getLastStrength() && world != null) {
            world.method_8452(te.method_11016(), te.method_11010().method_26204());
            this.setLastStrength(newStrength);
        }
    }

    default public boolean isFluidInModel() {
        return (Boolean)Config.CLIENT.tankFluidModel.get();
    }

    @Override
    default public void updateFluidTo(FluidStack fluid) {
        FluidTankAnimated tank = this.getTank();
        long oldAmount = tank.getFluidAmount();
        long newAmount = fluid.getAmount();
        tank.setFluid(fluid);
        tank.setRenderOffset(tank.getRenderOffset() + (float)newAmount - (float)oldAmount);
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            class_2586 te;
            TankModel.Baked model;
            if (this.isFluidInModel() && (model = (TankModel.Baked)ModelHelper.getBakedModel((class_2680)(te = this.getTE()).method_11010(), TankModel.Baked.class)) != null && (Math.abs(newAmount - oldAmount) >= tank.getCapacity() / (long)model.getFluid().getIncrements() || oldAmount == 0L != (newAmount == 0L))) {
                class_310.method_1551().field_1769.method_8570(null, te.method_11016(), null, null, 3);
            }
        });
    }

    default public class_2586 getTE() {
        return (class_2586)this;
    }

    public static int getComparatorInputOverride(class_1936 world, class_2338 pos) {
        class_2586 te = world.method_8321(pos);
        if (!(te instanceof ITankBlockEntity)) {
            return 0;
        }
        return ((ITankBlockEntity)te).comparatorStrength();
    }
}

