/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.component;

import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import io.github.fabricators_of_create.porting_lib.util.NonNullConsumer;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import slimeknights.mantle.inventory.EmptyItemHandler;
import slimeknights.mantle.transfer.TransferUtil;
import slimeknights.mantle.transfer.fluid.EmptyFluidHandler;
import slimeknights.mantle.transfer.fluid.FluidTransferable;
import slimeknights.mantle.transfer.fluid.IFluidHandler;
import slimeknights.mantle.transfer.item.IItemHandler;
import slimeknights.mantle.transfer.item.ItemTransferable;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.entity.component.SmelteryComponentBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.tank.ISmelteryTankHandler;

public abstract class SmelteryInputOutputBlockEntity<T>
extends SmelteryComponentBlockEntity {
    private final Class<T> capability;
    protected final T emptyInstance;
    protected final NonNullConsumer<LazyOptional<T>> listener = new WeakConsumerWrapper((Object)this, (te, cap) -> te.clearHandler());
    @Nullable
    private LazyOptional<T> capabilityHolder = null;

    protected SmelteryInputOutputBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, Class<T> capability, T emptyInstance) {
        super(type, pos, state);
        this.capability = capability;
        this.emptyInstance = emptyInstance;
    }

    private void clearHandler() {
        if (this.capabilityHolder != null) {
            this.capabilityHolder.invalidate();
            this.capabilityHolder = null;
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.clearHandler();
    }

    @Override
    protected void setMaster(@Nullable class_2338 master, @Nullable class_2248 block) {
        assert (this.field_11863 != null);
        boolean masterChanged = false;
        if (!Objects.equals(this.getMasterPos(), master)) {
            this.clearHandler();
            masterChanged = true;
        }
        super.setMaster(master, block);
        if (masterChanged) {
            this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
        }
    }

    protected LazyOptional<T> getCapability(class_2586 parent) {
        LazyOptional handler = TransferUtil.getHandler((class_2586)parent, null, this.capability);
        if (handler.isPresent()) {
            handler.addListener(this.listener);
            return LazyOptional.of(() -> handler.orElse(this.emptyInstance));
        }
        return LazyOptional.empty();
    }

    protected LazyOptional<T> getCachedCapability() {
        if (this.capabilityHolder == null) {
            class_2586 te;
            class_2338 master;
            if (this.validateMaster() && (master = this.getMasterPos()) != null && this.field_11863 != null && (te = this.field_11863.method_8321(master)) != null) {
                this.capabilityHolder = this.getCapability(te);
                return this.capabilityHolder;
            }
            this.capabilityHolder = LazyOptional.empty();
        }
        return this.capabilityHolder;
    }

    public static class ChuteBlockEntity
    extends SmelteryInputOutputBlockEntity<IItemHandler>
    implements ItemTransferable {
        public ChuteBlockEntity(class_2338 pos, class_2680 state) {
            this((class_2591)TinkerSmeltery.chute.get(), pos, state);
        }

        protected ChuteBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
            super(type, pos, state, IItemHandler.class, EmptyItemHandler.INSTANCE);
        }

        @Nullable
        public LazyOptional<IItemHandler> getItemHandler(@Nullable class_2350 direction) {
            return this.getCachedCapability();
        }
    }

    public static abstract class SmelteryFluidIO
    extends SmelteryInputOutputBlockEntity<IFluidHandler>
    implements FluidTransferable {
        protected SmelteryFluidIO(class_2591<?> type, class_2338 pos, class_2680 state) {
            super(type, pos, state, IFluidHandler.class, EmptyFluidHandler.INSTANCE);
        }

        protected LazyOptional<IFluidHandler> makeWrapper(LazyOptional<IFluidHandler> capability) {
            return LazyOptional.of(() -> (IFluidHandler)capability.orElse((Object)((IFluidHandler)this.emptyInstance)));
        }

        @Override
        protected LazyOptional<IFluidHandler> getCapability(class_2586 parent) {
            LazyOptional<IFluidHandler> capability;
            if (parent instanceof ISmelteryTankHandler && (capability = ((ISmelteryTankHandler)parent).getFluidCapability()).isPresent()) {
                capability.addListener(this.listener);
                return this.makeWrapper(capability);
            }
            return LazyOptional.empty();
        }

        @Nullable
        public LazyOptional<IFluidHandler> getFluidHandler(@Nullable class_2350 direction) {
            return this.getCachedCapability();
        }
    }
}

