/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.component;

import io.github.fabricators_of_create.porting_lib.model.IModelData;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import slimeknights.mantle.client.model.data.SinglePropertyData;
import slimeknights.mantle.transfer.fluid.FluidTransferable;
import slimeknights.mantle.transfer.fluid.IFluidHandler;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.block.entity.ITankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.SmelteryComponentBlockEntity;
import slimeknights.tconstruct.smeltery.item.TankItem;

public class TankBlockEntity
extends SmelteryComponentBlockEntity
implements ITankBlockEntity,
FluidTransferable,
RenderAttachmentBlockEntity {
    public static final long DEFAULT_CAPACITY = 324000L;
    protected final FluidTankAnimated tank;
    private final LazyOptional<IFluidHandler> holder;
    private final IModelData modelData;
    private int lastStrength;

    public static long getCapacity(class_2248 block) {
        if (block instanceof ITankBlock) {
            return ((ITankBlock)block).getCapacity();
        }
        return 324000L;
    }

    public static long getCapacity(class_1792 item) {
        if (item instanceof class_1747) {
            return TankBlockEntity.getCapacity(((class_1747)item).method_7711());
        }
        return 324000L;
    }

    public TankBlockEntity(class_2338 pos, class_2680 state) {
        ITankBlock tank;
        class_2248 class_22482 = state.method_26204();
        this(pos, state, class_22482 instanceof ITankBlock ? (tank = (ITankBlock)class_22482) : (ITankBlock)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.FUEL_TANK));
    }

    public TankBlockEntity(class_2338 pos, class_2680 state, ITankBlock block) {
        this((class_2591)TinkerSmeltery.tank.get(), pos, state, block);
    }

    protected TankBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, ITankBlock block) {
        super(type, pos, state);
        this.lastStrength = -1;
        this.tank = new FluidTankAnimated(block.getCapacity(), this);
        this.holder = LazyOptional.of(() -> this.tank);
        this.modelData = new SinglePropertyData(ModelProperties.FLUID_TANK, (Object)this.tank);
    }

    @Nonnull
    public LazyOptional<IFluidHandler> getFluidHandler(@Nullable class_2350 direction) {
        return this.holder.cast();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    @Nonnull
    public Object getRenderAttachmentData() {
        return this.modelData;
    }

    @Override
    public void onTankContentsChanged() {
        ITankBlockEntity.super.onTankContentsChanged();
        if (this.field_11863 != null) {
            this.field_11863.method_22336().method_15513(this.field_11867);
        }
    }

    @Override
    public void updateFluidTo(FluidStack fluid) {
        ITankBlockEntity.super.updateFluidTo(fluid);
        if (this.field_11863 != null) {
            this.field_11863.method_22336().method_15513(this.field_11867);
        }
    }

    public void setTankTag(class_1799 stack) {
        TankItem.setTank(stack, this.tank);
    }

    public void updateTank(class_2487 nbt) {
        if (nbt.method_33133()) {
            this.tank.setFluid(FluidStack.EMPTY);
        } else {
            this.tank.readFromNBT(nbt);
            if (this.field_11863 != null) {
                this.field_11863.method_22336().method_15513(this.field_11867);
            }
        }
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    @Override
    public void method_11014(class_2487 tag) {
        this.tank.setCapacity(TankBlockEntity.getCapacity(this.method_11010().method_26204()));
        this.updateTank(tag.method_10562("tank"));
        super.method_11014(tag);
    }

    public void saveSynced(class_2487 tag) {
        super.saveSynced(tag);
        if (!this.tank.isEmpty()) {
            tag.method_10566("tank", (class_2520)this.tank.writeToNBT(new class_2487()));
        }
    }

    @Override
    public FluidTankAnimated getTank() {
        return this.tank;
    }

    @Override
    public int getLastStrength() {
        return this.lastStrength;
    }

    @Override
    public void setLastStrength(int lastStrength) {
        this.lastStrength = lastStrength;
    }

    public static interface ITankBlock {
        public long getCapacity();
    }
}

