/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.inventory;

import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import slimeknights.mantle.transfer.fluid.IFluidHandler;
import slimeknights.tconstruct.smeltery.block.entity.inventory.DuctItemHandler;

public class DuctTankWrapper
implements IFluidHandler {
    private final IFluidHandler parent;
    private final DuctItemHandler itemHandler;

    public int getTanks() {
        return this.parent.getTanks();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.parent.getFluidInTank(tank);
    }

    public long getTankCapacity(int tank) {
        return this.parent.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.itemHandler.getFluid().isFluidEqual(stack);
    }

    public long fill(FluidStack resource, boolean sim) {
        if (resource.isEmpty() || !this.itemHandler.getFluid().isFluidEqual(resource)) {
            return 0L;
        }
        return this.parent.fill(resource, sim);
    }

    public FluidStack drain(long maxDrain, boolean sim) {
        FluidStack fluid = this.itemHandler.getFluid();
        if (fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this.parent.drain(new FluidStack(fluid, maxDrain), sim);
    }

    public FluidStack drain(FluidStack resource, boolean sim) {
        if (resource.isEmpty() || !this.itemHandler.getFluid().isFluidEqual(resource)) {
            return FluidStack.EMPTY;
        }
        return this.parent.drain(resource, sim);
    }

    public DuctTankWrapper(IFluidHandler parent, DuctItemHandler itemHandler) {
        this.parent = parent;
        this.itemHandler = itemHandler;
    }
}

