/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module;

import io.github.fabricators_of_create.porting_lib.mixin.common.accessor.DamageSourceAccessor;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3611;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.transfer.fluid.IFluidHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipeCache;

public class EntityMeltingModule {
    public static final class_1282 SMELTERY_DAMAGE = DamageSourceAccessor.port_lib$init((String)TConstruct.prefix("smeltery_heat")).port_lib$setFireDamage();
    public static final class_1282 SMELTERY_MAGIC = DamageSourceAccessor.port_lib$init((String)TConstruct.prefix("smeltery_magic")).method_5515();
    private final MantleBlockEntity parent;
    private final IFluidHandler tank;
    private final BooleanSupplier canMeltEntities;
    private final Function<class_1799, class_1799> insertFunction;
    private final Supplier<class_238> bounds;
    @Nullable
    private EntityMeltingRecipe lastRecipe;

    private class_1937 getLevel() {
        return Objects.requireNonNull(this.parent.method_10997(), "Parent tile entity has null world");
    }

    @Nullable
    private EntityMeltingRecipe findRecipe(class_1299<?> type) {
        if (this.lastRecipe != null && this.lastRecipe.matches(type)) {
            return this.lastRecipe;
        }
        EntityMeltingRecipe recipe = EntityMeltingRecipeCache.findRecipe(this.getLevel().method_8433(), type);
        if (recipe != null) {
            this.lastRecipe = recipe;
        }
        return recipe;
    }

    public static FluidStack getDefaultFluid() {
        return new FluidStack((class_3611)TinkerFluids.blood.get(), 4050L);
    }

    private boolean canMeltEntity(class_1309 entity) {
        return !entity.method_5679(entity.method_5753() ? SMELTERY_MAGIC : SMELTERY_DAMAGE) && (!(entity instanceof class_1657) || !((class_1657)entity).method_31549().field_7480) && !entity.method_6059(class_1294.field_5918);
    }

    public boolean interactWithEntities() {
        class_238 boundingBox = this.bounds.get();
        if (boundingBox == null) {
            return false;
        }
        Boolean canMelt = null;
        boolean melted = false;
        for (class_1297 entity : this.getLevel().method_18467(class_1297.class, boundingBox)) {
            int damage;
            FluidStack fluid;
            if (!entity.method_5805()) continue;
            class_1299 type = entity.method_5864();
            if (entity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)entity;
                class_1799 stack = this.insertFunction.apply(itemEntity.method_6983());
                if (stack.method_7960()) {
                    entity.method_31472();
                    continue;
                }
                itemEntity.method_6979(stack);
                continue;
            }
            if (canMelt == Boolean.FALSE || type.method_20210(TinkerTags.EntityTypes.MELTING_HIDE) || !(entity instanceof class_1309) || !this.canMeltEntity((class_1309)entity)) continue;
            if (canMelt == null) {
                canMelt = this.canMeltEntities.getAsBoolean();
            }
            if (!canMelt.booleanValue()) continue;
            EntityMeltingRecipe recipe = this.findRecipe(entity.method_5864());
            if (recipe != null) {
                fluid = recipe.getOutput((class_1309)entity);
                damage = recipe.getDamage();
            } else {
                fluid = EntityMeltingModule.getDefaultFluid();
                damage = 2;
            }
            if (!entity.method_5643(entity.method_5753() ? SMELTERY_MAGIC : SMELTERY_DAMAGE, (float)damage)) continue;
            this.tank.fill(fluid, false);
            melted = true;
        }
        return melted;
    }

    public EntityMeltingModule(MantleBlockEntity parent, IFluidHandler tank, BooleanSupplier canMeltEntities, Function<class_1799, class_1799> insertFunction, Supplier<class_238> bounds) {
        this.parent = parent;
        this.tank = tank;
        this.canMeltEntities = canMeltEntities;
        this.insertFunction = insertFunction;
        this.bounds = bounds;
    }
}

